/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListLibrary;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.lang.invoke.MethodHandles;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMVaListLibrary.class)
final class LLVMVaListLibraryGen
extends LibraryFactory<LLVMVaListLibrary> {
    private static final Class<LLVMVaListLibrary> LIBRARY_CLASS = LLVMVaListLibraryGen.lazyLibraryClass();
    private static final Message INITIALIZE = new MessageImpl("initialize", 0, false, Void.TYPE, Object.class, Object[].class, Integer.TYPE, Frame.class);
    private static final Message CLEANUP = new MessageImpl("cleanup", 1, false, Void.TYPE, Object.class, Frame.class);
    private static final Message COPY = new MessageImpl("copy", 2, false, Void.TYPE, Object.class, Object.class, Frame.class);
    private static final Message SHIFT = new MessageImpl("shift", 3, false, Object.class, Object.class, Type.class, Frame.class);
    private static final LLVMVaListLibraryGen INSTANCE = new LLVMVaListLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private LLVMVaListLibraryGen() {
        super(LIBRARY_CLASS, List.of(INITIALIZE, CLEANUP, COPY, SHIFT));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        return LLVMVaListLibrary.class;
    }

    protected MethodHandles.Lookup getLookup() {
        return MethodHandles.lookup();
    }

    protected LLVMVaListLibrary createAssertions(LLVMVaListLibrary delegate) {
        return new LLVMVaListLibrary.NoUncachedAssert(delegate);
    }

    protected LLVMVaListLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected LLVMVaListLibrary createDelegate(LLVMVaListLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        LLVMVaListLibrary lib = (LLVMVaListLibrary)originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0: {
                lib.initialize(receiver, (Object[])args[offset], (Integer)args[offset + 1], (Frame)args[offset + 2]);
                return null;
            }
            case 1: {
                lib.cleanup(receiver, (Frame)args[offset]);
                return null;
            }
            case 2: {
                lib.copy(receiver, args[offset], (Frame)args[offset + 1]);
                return null;
            }
            case 3: {
                return lib.shift(receiver, (Type)args[offset], (Frame)args[offset + 1]);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected LLVMVaListLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected LLVMVaListLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<LLVMVaListLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.LLVMVaListLibrary", false, LLVMVaListLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryExport.register(LIBRARY_CLASS, (LibraryExport[])new LibraryExport[]{new Default()});
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=LLVMVaListLibrary.class)
    private static final class Proxy
    extends LLVMVaListLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public void initialize(Object receiver_, Object[] arguments, int numberOfExplicitArguments, Frame frame) {
            try {
                this.lib.send(receiver_, INITIALIZE, new Object[]{arguments, numberOfExplicitArguments, frame});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void cleanup(Object receiver_, Frame frame) {
            try {
                this.lib.send(receiver_, CLEANUP, new Object[]{frame});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public void copy(Object receiver_, Object destVaList, Frame frame) {
            try {
                this.lib.send(receiver_, COPY, new Object[]{destVaList, frame});
                return;
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object shift(Object receiver_, Type type, Frame frame) {
            try {
                return this.lib.send(receiver_, SHIFT, new Object[]{type, frame});
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=LLVMVaListLibrary.class)
    private static final class Delegate
    extends LLVMVaListLibrary {
        @Node.Child
        private LLVMVaListLibrary delegateLibrary;

        Delegate(LLVMVaListLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public void initialize(Object receiver_, Object[] arguments, int numberOfExplicitArguments, Frame frame) {
            if (LLVMVaListLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = LLVMVaListLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((LLVMVaListLibrary)LLVMVaListLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).initialize(delegate, arguments, numberOfExplicitArguments, frame);
                return;
            }
            this.delegateLibrary.initialize(receiver_, arguments, numberOfExplicitArguments, frame);
        }

        @Override
        public void cleanup(Object receiver_, Frame frame) {
            if (LLVMVaListLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = LLVMVaListLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((LLVMVaListLibrary)LLVMVaListLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).cleanup(delegate, frame);
                return;
            }
            this.delegateLibrary.cleanup(receiver_, frame);
        }

        @Override
        public void copy(Object receiver_, Object destVaList, Frame frame) {
            if (LLVMVaListLibraryGen.isDelegated((Library)this.delegateLibrary, (int)2)) {
                Object delegate = LLVMVaListLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                ((LLVMVaListLibrary)LLVMVaListLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).copy(delegate, destVaList, frame);
                return;
            }
            this.delegateLibrary.copy(receiver_, destVaList, frame);
        }

        @Override
        public Object shift(Object receiver_, Type type, Frame frame) {
            if (LLVMVaListLibraryGen.isDelegated((Library)this.delegateLibrary, (int)3)) {
                Object delegate = LLVMVaListLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((LLVMVaListLibrary)LLVMVaListLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).shift(delegate, type, frame);
            }
            return this.delegateLibrary.shift(receiver_, type, frame);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=LLVMVaListLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch
    implements GenerateAOT.Provider {
        private final int limit_;
        private volatile boolean aot_;

        CachedDispatchFirst(LLVMVaListLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        void setAOT(boolean value) {
            this.aot_ = value;
        }

        @Override
        boolean isAOT() {
            return this.aot_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if (this.aot_) {
                return;
            }
            for (LibraryExport export : INSTANCE.getAOTExports()) {
                LLVMVaListLibrary exportLibrary = (LLVMVaListLibrary)INSTANCE.createAOT(export);
                if (this.library == null) {
                    this.library = (LLVMVaListLibrary)this.insert((Node)exportLibrary);
                    continue;
                }
                this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext(exportLibrary, this.next));
            }
            this.aot_ = true;
        }
    }

    @GeneratedBy(value=LLVMVaListLibrary.class)
    private static abstract class CachedDispatch
    extends LLVMVaListLibrary {
        @Node.Child
        LLVMVaListLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(LLVMVaListLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        abstract boolean isAOT();

        abstract void setAOT(boolean var1);

        @Override
        @ExplodeLoop
        public void initialize(Object receiver_, Object[] arguments, int numberOfExplicitArguments, Frame frame) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMVaListLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.initialize(receiver_, arguments, numberOfExplicitArguments, frame);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void cleanup(Object receiver_, Frame frame) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMVaListLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.cleanup(receiver_, frame);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public void copy(Object receiver_, Object destVaList, Frame frame) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMVaListLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    thisLibrary.copy(receiver_, destVaList, frame);
                    return;
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object shift(Object receiver_, Type type, Frame frame) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMVaListLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.shift(receiver_, type, frame);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                if (this.isAOT()) {
                    this.library = null;
                    this.next = null;
                    this.setAOT(false);
                }
                CachedDispatch current = this;
                LLVMVaListLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = (LLVMVaListLibrary)this.insert((Node)((LLVMVaListLibrary)INSTANCE.create(receiver_)));
                } else {
                    int count = 0;
                    do {
                        LLVMVaListLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (LLVMVaListLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((LLVMVaListLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=LLVMVaListLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch
    extends LLVMVaListLibrary
    implements UnadoptableNode {
        private UncachedDispatch() {
        }

        @Override
        public void initialize(Object receiver_, Object[] arguments, int numberOfExplicitArguments, Frame frame) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            ((LLVMVaListLibrary)INSTANCE.getUncached(receiver_)).initialize(receiver_, arguments, numberOfExplicitArguments, frame);
        }

        @Override
        public void cleanup(Object receiver_, Frame frame) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            ((LLVMVaListLibrary)INSTANCE.getUncached(receiver_)).cleanup(receiver_, frame);
        }

        @Override
        public void copy(Object receiver_, Object destVaList, Frame frame) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            ((LLVMVaListLibrary)INSTANCE.getUncached(receiver_)).copy(receiver_, destVaList, frame);
        }

        @Override
        public Object shift(Object receiver_, Type type, Frame frame) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((LLVMVaListLibrary)INSTANCE.getUncached(receiver_)).shift(receiver_, type, frame);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=LLVMVaListLibrary.class)
    private static class MessageImpl
    extends Message {
        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, index, deprecated, returnType, (Class[])parameters);
        }
    }

    @GeneratedBy(value=LLVMVaListLibrary.class)
    private static final class Default
    extends LibraryExport<LLVMVaListLibrary> {
        private Default() {
            super(LLVMVaListLibrary.class, Object.class, false, false, 0);
        }

        protected LLVMVaListLibrary createUncached(Object receiver) {
            Uncached uncached = new Uncached(receiver);
            return uncached;
        }

        protected LLVMVaListLibrary createCached(Object receiver) {
            return new Cached(receiver);
        }

        @GeneratedBy(value=LLVMVaListLibrary.class)
        @DenyReplace
        private static final class Uncached
        extends LLVMVaListLibrary
        implements UnadoptableNode {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = this.dynamicDispatch_.dispatch(receiver);
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public void initialize(Object receiver, Object[] arguments, int numberOfExplicitArguments, Frame frame) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new AbstractMethodError();
            }

            @Override
            public void cleanup(Object receiver, Frame frame) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new AbstractMethodError();
            }

            @Override
            public void copy(Object receiver, Object destVaList, Frame frame) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new AbstractMethodError();
            }

            @Override
            public Object shift(Object receiver, Type type, Frame frame) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new AbstractMethodError();
            }
        }

        @GeneratedBy(value=LLVMVaListLibrary.class)
        private static final class Cached
        extends LLVMVaListLibrary {
            @Node.Child
            private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = (DynamicDispatchLibrary)this.insert((Node)((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.create(receiver)));
                this.dynamicDispatchTarget_ = ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver)).dispatch(receiver);
            }

            public boolean accepts(Object receiver) {
                return this.dynamicDispatch_.accepts(receiver) && this.dynamicDispatch_.dispatch(receiver) == this.dynamicDispatchTarget_;
            }

            @Override
            public void initialize(Object receiver, Object[] arguments, int numberOfExplicitArguments, Frame frame) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new AbstractMethodError();
            }

            @Override
            public void cleanup(Object receiver, Frame frame) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new AbstractMethodError();
            }

            @Override
            public void copy(Object receiver, Object destVaList, Frame frame) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new AbstractMethodError();
            }

            @Override
            public Object shift(Object receiver, Type type, Frame frame) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new AbstractMethodError();
            }
        }
    }

    @GeneratedBy(value=LLVMVaListLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(LLVMVaListLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        void setAOT(boolean value) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        boolean isAOT() {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GeneratedBy(value=LLVMVaListLibrary.class)
    private static final class CachedToUncachedDispatch
    extends LLVMVaListLibrary {
        private CachedToUncachedDispatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void initialize(Object receiver_, Object[] arguments, int numberOfExplicitArguments, Frame frame) {
            assert (LLVMVaListLibraryGen.assertAdopted((Node)((Node)this)));
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((LLVMVaListLibrary)INSTANCE.getUncached(receiver_)).initialize(receiver_, arguments, numberOfExplicitArguments, frame);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cleanup(Object receiver_, Frame frame) {
            assert (LLVMVaListLibraryGen.assertAdopted((Node)((Node)this)));
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((LLVMVaListLibrary)INSTANCE.getUncached(receiver_)).cleanup(receiver_, frame);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void copy(Object receiver_, Object destVaList, Frame frame) {
            assert (LLVMVaListLibraryGen.assertAdopted((Node)((Node)this)));
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                ((LLVMVaListLibrary)INSTANCE.getUncached(receiver_)).copy(receiver_, destVaList, frame);
                return;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object shift(Object receiver_, Type type, Frame frame) {
            assert (LLVMVaListLibraryGen.assertAdopted((Node)((Node)this)));
            CompilerDirectives.transferToInterpreterAndInvalidate();
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((LLVMVaListLibrary)INSTANCE.getUncached(receiver_)).shift(receiver_, type, frame);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }
}

