/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.debug.LLDBSupport;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugTypeConstants;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLDBMemoryValue;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.math.BigInteger;

abstract class LLDBConstant
implements LLVMDebugValue {
    LLDBConstant() {
    }

    @Override
    public Object readBoolean(long bitOffset) {
        return this.cannotInterpret("boolean", bitOffset, 1);
    }

    @Override
    public Object readFloat(long bitOffset) {
        return this.cannotInterpret("float", bitOffset, 32);
    }

    @Override
    public Object readDouble(long bitOffset) {
        return this.cannotInterpret("double", bitOffset, 64);
    }

    @Override
    public Object read80BitFloat(long bitOffset) {
        return this.cannotInterpret("80bit float", bitOffset, 80);
    }

    @Override
    public Object readAddress(long bitOffset) {
        return this.cannotInterpret("address", bitOffset, 64);
    }

    @Override
    public Object readUnknown(long bitOffset, int bitSize) {
        return this.describeValue(bitOffset, bitSize);
    }

    @Override
    public Object computeAddress(long bitOffset) {
        return "<unavailable>";
    }

    @Override
    public Object readBigInteger(long bitOffset, int bitSize, boolean signed) {
        return this.cannotInterpret(LLVMDebugTypeConstants.getIntegerKind(bitSize, signed), bitOffset, bitSize);
    }

    @Override
    public LLVMDebugValue dereferencePointer(long bitOffset) {
        return null;
    }

    @Override
    public boolean isInteropValue() {
        return false;
    }

    @Override
    public Object asInteropValue() {
        return null;
    }

    protected abstract Object getBaseValue();

    @Override
    @CompilerDirectives.TruffleBoundary
    public String describeValue(long bitOffset, int bitSize) {
        if (bitOffset != 0L || bitSize != 0) {
            return String.format("%s at offset %s in %s", LLDBSupport.toSizeString(bitSize), LLDBSupport.toSizeString(bitOffset), this.getBaseValue());
        }
        return String.valueOf(this.getBaseValue());
    }

    static final class InteropValue
    extends LLDBConstant {
        private final Object value;
        private final long offset;

        InteropValue(Object value, long offset) {
            this.value = value;
            this.offset = offset;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object getBaseValue() {
            if (this.offset > 0L) {
                return String.format("offset %d in %s", this.offset, this.value);
            }
            return this.value;
        }

        @Override
        public boolean canRead(long bitOffset, int bits) {
            return true;
        }

        @Override
        public boolean isInteropValue() {
            return true;
        }

        @Override
        public Object asInteropValue() {
            if (((LLVMAsForeignLibrary)LLVMAsForeignLibrary.getFactory().getUncached()).isForeign(this.value)) {
                return ((LLVMAsForeignLibrary)LLVMAsForeignLibrary.getFactory().getUncached()).asForeign(this.value);
            }
            return this.value;
        }
    }

    static final class Function
    extends LLDBConstant {
        private final LLVMFunctionDescriptor value;

        Function(LLVMFunctionDescriptor value) {
            this.value = value;
        }

        @Override
        protected Object getBaseValue() {
            return this.value;
        }

        @Override
        public boolean canRead(long bitOffset, int bits) {
            return bitOffset == 0L && bits == 64;
        }

        @Override
        public Object readAddress(long bitOffset) {
            if (this.canRead(bitOffset, 64)) {
                return this.getBaseValue();
            }
            return this.cannotInterpret("address", bitOffset, 64);
        }
    }

    static final class BigFloat
    extends LLDBConstant {
        private final LLVM80BitFloat value;

        private static boolean isValidBitsize(int bits) {
            return bits == 80 || bits == 128;
        }

        BigFloat(LLVM80BitFloat value) {
            this.value = value;
        }

        @Override
        protected Object getBaseValue() {
            return LLVM80BitFloat.toLLVMString(this.value);
        }

        @Override
        public boolean canRead(long bitOffset, int bits) {
            return bitOffset == 0L && BigFloat.isValidBitsize(bits);
        }

        @Override
        public Object read80BitFloat(long bitOffset) {
            if (this.canRead(bitOffset, 80)) {
                return LLVM80BitFloat.toLLVMString(this.value);
            }
            return this.cannotInterpret("80bit float", bitOffset, 80);
        }
    }

    static final class Double
    extends LLDBConstant {
        private final double value;

        Double(double value) {
            this.value = value;
        }

        @Override
        protected Object getBaseValue() {
            return this.value;
        }

        @Override
        public boolean canRead(long bitOffset, int bits) {
            return (long)(64 - bits) - bitOffset >= 0L;
        }

        private long asLong(long bitOffset) {
            long valAsLong = java.lang.Double.doubleToRawLongBits(this.value);
            if (bitOffset != 0L) {
                valAsLong >>= (int)bitOffset;
            }
            return valAsLong;
        }

        @Override
        public Object readBoolean(long bitOffset) {
            if (bitOffset < 64L) {
                long asLong = this.asLong(bitOffset);
                return (asLong & 1L) != 0L;
            }
            return super.readBoolean(bitOffset);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readFloat(long bitOffset) {
            if (64L - bitOffset >= 32L) {
                int asInt = (int)this.asLong(bitOffset);
                return java.lang.Float.valueOf(java.lang.Float.intBitsToFloat(asInt));
            }
            return this.cannotInterpret("float", bitOffset, 32);
        }

        @Override
        public Object readDouble(long bitOffset) {
            if (bitOffset == 0L) {
                return this.value;
            }
            return this.cannotInterpret("double", bitOffset, 64);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readBigInteger(long bitOffset, int bitSize, boolean signed) {
            if ((long)(64 - bitSize) - bitOffset >= 0L) {
                int shift = 64 - bitSize;
                long asLong = this.asLong(bitOffset);
                if (shift > 0) {
                    asLong <<= shift;
                    long l = asLong = signed ? asLong >> shift : asLong >>> shift;
                }
                if (signed) {
                    return BigInteger.valueOf(asLong);
                }
                return new BigInteger(Long.toUnsignedString(asLong));
            }
            return super.readBigInteger(bitOffset, bitSize, signed);
        }

        @Override
        public Object readAddress(long bitOffset) {
            if (bitOffset == 0L) {
                return LLVMNativePointer.create(this.asLong(bitOffset));
            }
            return super.readAddress(bitOffset);
        }
    }

    static final class Float
    extends LLDBConstant {
        private final float value;

        Float(float value) {
            this.value = value;
        }

        @Override
        protected Object getBaseValue() {
            return java.lang.Float.valueOf(this.value);
        }

        @Override
        public boolean canRead(long bitOffset, int bits) {
            return bitOffset == 0L && bits == 32;
        }

        private int asInt(long bitOffset) {
            int valAsInt = java.lang.Float.floatToRawIntBits(this.value);
            return valAsInt >> (int)bitOffset;
        }

        @Override
        public Object readBoolean(long bitOffset) {
            if (bitOffset < 32L) {
                long asInt = this.asInt(bitOffset);
                return (asInt & 1L) != 0L;
            }
            return super.readBoolean(bitOffset);
        }

        @Override
        public Object readFloat(long bitOffset) {
            if (this.canRead(bitOffset, 32)) {
                return java.lang.Float.valueOf(this.value);
            }
            return this.cannotInterpret("float", bitOffset, 32);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readBigInteger(long bitOffset, int bitSize, boolean signed) {
            if ((long)(32 - bitSize) - bitOffset >= 0L) {
                int shift = 32 - bitSize;
                int intVal = this.asInt(bitOffset);
                if (shift > 0) {
                    intVal <<= shift;
                    int n = intVal = signed ? intVal >> shift : intVal >>> shift;
                }
                if (signed) {
                    return BigInteger.valueOf(intVal);
                }
                return new BigInteger(Long.toUnsignedString(intVal));
            }
            return super.readBigInteger(bitOffset, bitSize, signed);
        }
    }

    static final class Pointer
    extends LLDBConstant {
        private final LLVMPointer pointer;

        Pointer(LLVMPointer pointer) {
            this.pointer = pointer;
        }

        @Override
        protected Object getBaseValue() {
            return this.pointer;
        }

        @Override
        public boolean canRead(long bitOffset, int bits) {
            return (long)(64 - bits) - bitOffset >= 0L;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public String describeValue(long bitOffset, int bitSize) {
            String value = String.valueOf(new LLDBMemoryValue(this.pointer).computeAddress(0L));
            if (bitOffset != 0L || bitSize != 0) {
                value = String.format("%s at offset %s in %s", LLDBSupport.toSizeString(bitSize), LLDBSupport.toSizeString(bitOffset), value);
            }
            return value;
        }

        @Override
        public Object readBoolean(long bitOffset) {
            return !this.pointer.isNull();
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readBigInteger(long bitOffset, int bitSize, boolean signed) {
            if (this.canRead(bitOffset, bitSize)) {
                if (LLVMNativePointer.isInstance(this.pointer)) {
                    int shift;
                    long asLong = LLVMNativePointer.cast(this.pointer).asNative();
                    if (bitOffset != 0L) {
                        asLong >>>= (int)bitOffset;
                    }
                    if ((shift = 64 - bitSize) > 0) {
                        asLong <<= shift;
                        long l = asLong = signed ? asLong >> shift : asLong >>> shift;
                    }
                    if (signed) {
                        return BigInteger.valueOf(asLong);
                    }
                    return new BigInteger(Long.toUnsignedString(asLong));
                }
                if (LLVMManagedPointer.isInstance(this.pointer)) {
                    return this.describeValue(bitOffset, bitSize);
                }
            }
            return super.readBigInteger(bitOffset, bitSize, signed);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readAddress(long bitOffset) {
            if (this.canRead(bitOffset, 64)) {
                return this.pointer;
            }
            return this.cannotInterpret("address", bitOffset, 64);
        }

        @Override
        public Object computeAddress(long bitOffset) {
            return new LLDBMemoryValue(this.pointer).computeAddress(bitOffset);
        }

        @Override
        public boolean isAlwaysSafeToDereference(long bitOffset) {
            if (LLDBSupport.isNestedManagedPointer(this.pointer) || LLDBSupport.pointsToObjectAccess(this.pointer)) {
                return true;
            }
            if (this.pointer.isNull()) {
                return false;
            }
            if (LLVMManagedPointer.isInstance(this.pointer)) {
                LLVMManagedPointer managedPointer = LLVMManagedPointer.cast(this.pointer);
                if (bitOffset != 0L || managedPointer.getOffset() != 0L) {
                    return false;
                }
                Object target = managedPointer.getObject();
                return LLVMManagedPointer.isInstance(target);
            }
            return bitOffset == 0L && this.pointer.getExportType() != null;
        }

        @Override
        public LLVMDebugValue dereferencePointer(long bitOffset) {
            if (this.canRead(bitOffset, 64)) {
                return new LLDBMemoryValue(this.pointer);
            }
            return null;
        }

        @Override
        public Object asInteropValue() {
            if (this.isInteropValue()) {
                Object foreign = null;
                if (LLVMNativePointer.isInstance(this.pointer)) {
                    long address = LLVMNativePointer.cast(this.pointer).asNative();
                    foreign = Pointer.getHandleValue(address);
                } else if (LLVMManagedPointer.isInstance(this.pointer)) {
                    foreign = LLVMManagedPointer.cast(this.pointer).getObject();
                }
                if (((LLVMAsForeignLibrary)LLVMAsForeignLibrary.getFactory().getUncached()).isForeign(foreign)) {
                    return ((LLVMAsForeignLibrary)LLVMAsForeignLibrary.getFactory().getUncached()).asForeign(foreign);
                }
            }
            return super.asInteropValue();
        }

        private static Object getHandleValue(long address) {
            LLVMManagedPointer value;
            LLVMContext context = LLVMLanguage.getContext();
            if (context.getHandleContainer().isHandle(address) && (value = context.getHandleContainer().getValue(null, address)) != null) {
                return value.getObject();
            }
            if (context.getDerefHandleContainer().isHandle(address) && (value = context.getDerefHandleContainer().getValue(null, address)) != null) {
                return value.getObject();
            }
            return null;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isInteropValue() {
            if (this.pointer.isNull()) {
                return false;
            }
            if (LLVMNativePointer.isInstance(this.pointer)) {
                return Pointer.getHandleValue(LLVMNativePointer.cast(this.pointer).asNative()) != null;
            }
            if (LLVMManagedPointer.isInstance(this.pointer)) {
                Object target = LLVMManagedPointer.cast(this.pointer).getObject();
                if (LLVMPointer.isInstance(target)) {
                    return false;
                }
                if (LLDBSupport.pointsToObjectAccess(this.pointer)) {
                    return false;
                }
                return !(target instanceof LLVMTypedForeignObject);
            }
            throw new IllegalStateException("Unsupported Pointer: " + String.valueOf(this.pointer));
        }

        @Override
        public boolean isManagedPointer() {
            return LLVMManagedPointer.isInstance(this.pointer);
        }

        @Override
        public Object getManagedPointerBase() {
            if (LLVMManagedPointer.isInstance(this.pointer)) {
                return LLVMManagedPointer.cast(this.pointer).getObject();
            }
            return null;
        }

        @Override
        public long getManagedPointerOffset() {
            if (LLVMManagedPointer.isInstance(this.pointer)) {
                return LLVMManagedPointer.cast(this.pointer).getOffset();
            }
            return 0L;
        }
    }

    static final class IVarBit
    extends LLDBConstant {
        private final LLVMIVarBit value;

        IVarBit(LLVMIVarBit value) {
            this.value = value;
        }

        @Override
        protected Object getBaseValue() {
            return this.value;
        }

        @Override
        public boolean canRead(long bitOffset, int bits) {
            return bitOffset + (long)bits <= (long)this.value.getBitSize();
        }

        @Override
        public Object readBoolean(long bitOffset) {
            return !this.value.isZero();
        }

        @Override
        public Object readBigInteger(long bitOffset, int bitSize, boolean signed) {
            if (!this.canRead(bitOffset, bitSize)) {
                return this.cannotInterpret(LLVMDebugTypeConstants.getIntegerKind(bitSize, signed), bitOffset, bitSize);
            }
            if (this.value.isZero()) {
                return BigInteger.ZERO;
            }
            LLVMIVarBit result = this.value;
            if (bitSize != this.value.getBitSize()) {
                result = result.leftShift(LLVMIVarBit.fromLong(64, (long)(result.getBitSize() - bitSize) - bitOffset));
                result = signed ? result.arithmeticRightShift(LLVMIVarBit.fromLong(64, result.getBitSize() - bitSize)) : result.logicalRightShift(LLVMIVarBit.fromLong(64, result.getBitSize() - bitSize));
            }
            return result.getDebugValue(signed);
        }

        @Override
        public Object readFloat(long bitOffset) {
            Object bigIntVal = this.readBigInteger(bitOffset, 32, false);
            if (bigIntVal instanceof BigInteger) {
                int intVal = ((BigInteger)bigIntVal).intValue();
                return java.lang.Float.valueOf(java.lang.Float.intBitsToFloat(intVal));
            }
            return super.readFloat(bitOffset);
        }

        @Override
        public Object readDouble(long bitOffset) {
            Object bigIntVal = this.readBigInteger(bitOffset, 64, false);
            if (bigIntVal instanceof BigInteger) {
                long longVal = ((BigInteger)bigIntVal).longValue();
                return java.lang.Double.longBitsToDouble(longVal);
            }
            return super.readDouble(bitOffset);
        }

        @Override
        public Object readAddress(long bitOffset) {
            Object bigIntVal = this.readBigInteger(bitOffset, 64, false);
            if (bigIntVal instanceof BigInteger) {
                long longVal = ((BigInteger)bigIntVal).longValue();
                return LLVMNativePointer.create(longVal);
            }
            return super.readAddress(bitOffset);
        }
    }

    static final class Integer
    extends LLDBConstant {
        private final long size;
        private final long value;

        Integer(long size, long value) {
            this.size = size;
            this.value = value;
        }

        @Override
        protected Object getBaseValue() {
            return this.value;
        }

        @Override
        public boolean canRead(long bitOffset, int bits) {
            return bitOffset + (long)bits <= this.size;
        }

        @Override
        public Object readBoolean(long bitOffset) {
            return this.value != 0L;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object readBigInteger(long bitOffset, int bitSize, boolean signed) {
            if (!this.canRead(bitOffset, bitSize)) {
                return this.describeValue(bitOffset, bitSize);
            }
            long result = this.value;
            result <<= (int)((long)(64 - bitSize) - bitOffset);
            if (signed) {
                return BigInteger.valueOf(result >>= 64 - bitSize);
            }
            return new BigInteger(Long.toUnsignedString(result >>>= 64 - bitSize));
        }

        @Override
        public Object computeAddress(long bitOffset) {
            return new Pointer(LLVMNativePointer.create(this.value)).computeAddress(bitOffset);
        }
    }
}

