/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMPolyglotNativeBufferInfo
extends LLVMNode {
    protected boolean isNativeBuffer(LLVMPointer pointer) {
        return pointer.getExportType() instanceof LLVMInteropType.Buffer;
    }

    protected LLVMInteropType.Buffer asBufferType(LLVMPointer pointer) {
        return (LLVMInteropType.Buffer)pointer.getExportType();
    }

    @GenerateUncached
    public static abstract class GetBufferSize
    extends LLVMPolyglotNativeBufferInfo {
        public abstract long execute(LLVMPointer var1) throws UnsupportedMessageException;

        @Specialization(guards={"isNativeBuffer(impl)"})
        public long getNativeBufferSize(LLVMNativePointer impl) {
            return this.asBufferType(impl).getSize();
        }

        @Specialization(guards={"!foreignsLib.isForeign(pointer)", "isNativeBuffer(pointer)"})
        public long doNonForeign(LLVMManagedPointer pointer, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreignsLib) {
            return this.asBufferType(pointer).getSize();
        }

        @Fallback
        public long unsupported(LLVMPointer receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @GenerateUncached
    public static abstract class IsBufferWritable
    extends LLVMPolyglotNativeBufferInfo {
        public abstract boolean execute(LLVMPointer var1) throws UnsupportedMessageException;

        @Specialization(guards={"isNativeBuffer(impl)"})
        public boolean isNativeBufferWritable(LLVMNativePointer impl) {
            return this.asBufferType(impl).isWritable();
        }

        @Specialization(guards={"!foreignsLib.isForeign(pointer)", "isNativeBuffer(pointer)"})
        public boolean doNonForeign(LLVMManagedPointer pointer, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreignsLib) {
            return this.asBufferType(pointer).isWritable();
        }

        @Fallback
        public boolean unsupported(LLVMPointer receiver) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @GenerateUncached
    public static abstract class HasBufferElements
    extends LLVMPolyglotNativeBufferInfo {
        public abstract boolean execute(LLVMPointer var1);

        @Specialization
        public boolean doNative(LLVMNativePointer pointer) {
            return this.isNativeBuffer(pointer);
        }

        @Specialization(guards={"!foreignsLib.isForeign(pointer)"})
        public boolean doNonForeign(LLVMManagedPointer pointer, @CachedLibrary(limit="3") LLVMAsForeignLibrary foreignsLib) {
            return this.isNativeBuffer(pointer);
        }

        @Fallback
        public boolean unsupported(LLVMPointer receiver) {
            return false;
        }
    }
}

