/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotFromPrimitiveFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class LLVMPolyglotFromPrimitive
extends LLVMIntrinsic {
    @Fallback
    Object onFallback(Object receiver) {
        throw new LLVMPolyglotException(this, "Unexpected argument");
    }

    public static abstract class FromDouble
    extends LLVMPolyglotFromPrimitive {
        @Specialization
        public LLVMManagedPointer asDouble(double value) {
            return LLVMManagedPointer.create(value);
        }

        public static FromDouble create(LLVMExpressionNode arg) {
            return LLVMPolyglotFromPrimitiveFactory.FromDoubleNodeGen.create(arg);
        }
    }

    public static abstract class FromFloat
    extends LLVMPolyglotFromPrimitive {
        @Specialization
        public LLVMManagedPointer asFloat(float value) {
            return LLVMManagedPointer.create(Float.valueOf(value));
        }

        public static FromFloat create(LLVMExpressionNode arg) {
            return LLVMPolyglotFromPrimitiveFactory.FromFloatNodeGen.create(arg);
        }
    }

    public static abstract class FromI64
    extends LLVMPolyglotFromPrimitive {
        @Specialization
        public LLVMManagedPointer asLong(long value) {
            return LLVMManagedPointer.create(value);
        }

        public static FromI64 create(LLVMExpressionNode arg) {
            return LLVMPolyglotFromPrimitiveFactory.FromI64NodeGen.create(arg);
        }
    }

    public static abstract class FromI32
    extends LLVMPolyglotFromPrimitive {
        @Specialization
        public LLVMManagedPointer asInt(int value) {
            return LLVMManagedPointer.create(value);
        }

        public static FromI32 create(LLVMExpressionNode arg) {
            return LLVMPolyglotFromPrimitiveFactory.FromI32NodeGen.create(arg);
        }
    }

    public static abstract class FromI16
    extends LLVMPolyglotFromPrimitive {
        @Specialization
        public LLVMManagedPointer asShort(short value) {
            return LLVMManagedPointer.create(value);
        }

        public static FromI16 create(LLVMExpressionNode arg) {
            return LLVMPolyglotFromPrimitiveFactory.FromI16NodeGen.create(arg);
        }
    }

    public static abstract class FromI8
    extends LLVMPolyglotFromPrimitive {
        @Specialization
        public LLVMManagedPointer asByte(byte value) {
            return LLVMManagedPointer.create(value);
        }

        public static FromI8 create(LLVMExpressionNode arg) {
            return LLVMPolyglotFromPrimitiveFactory.FromI8NodeGen.create(arg);
        }
    }

    public static abstract class FromBoolean
    extends LLVMPolyglotFromPrimitive {
        @Specialization
        public Object asBoolean(boolean bool) {
            return LLVMManagedPointer.create(bool);
        }

        public static FromBoolean create(LLVMExpressionNode arg) {
            return LLVMPolyglotFromPrimitiveFactory.FromBooleanNodeGen.create(arg);
        }
    }
}

