/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.export;

import com.oracle.truffle.api.InternalResource;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignGetSuperElemPtrNode;
import com.oracle.truffle.llvm.runtime.interop.export.LLVMForeignReadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GenerateUncached
public abstract class LLVMForeignVirtualSuperElemPtrNode
extends LLVMForeignGetSuperElemPtrNode {
    @Override
    public abstract LLVMPointer execute(LLVMPointer var1, long var2);

    @Specialization(guards={"!isWindows()"})
    public LLVMPointer doResolveOther(LLVMPointer receiver, long offset, @Cached LLVMForeignReadNode read) {
        Object vtablePointer = read.execute(receiver, LLVMInteropType.ValueKind.POINTER.type);
        LLVMPointer parent = LLVMPointer.cast(vtablePointer).increment(-offset);
        Object parentOffset = read.execute(parent, LLVMInteropType.ValueKind.I64.type);
        return receiver.increment((Long)parentOffset);
    }

    @Specialization(guards={"isWindows()"})
    public LLVMPointer doResolveWindows(LLVMPointer receiver, long offset, @Cached LLVMForeignReadNode read) {
        Object vtablePointer = read.execute(receiver, LLVMInteropType.ValueKind.POINTER.type);
        LLVMPointer parent = LLVMPointer.cast(vtablePointer).increment(offset);
        Object parentOffset = read.execute(parent, LLVMInteropType.ValueKind.I32.type);
        return receiver.increment(((Integer)parentOffset).intValue());
    }

    @Idempotent
    protected boolean isWindows() {
        return this.getLanguage().getCapability(PlatformCapability.class).getOS().equals((Object)InternalResource.OS.WINDOWS);
    }
}

