/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.InternalResource;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.api.Toolchain;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.IDGenerater;
import com.oracle.truffle.llvm.runtime.InternalLibraryLocator;
import com.oracle.truffle.llvm.runtime.LLVMAlias;
import com.oracle.truffle.llvm.runtime.LLVMArgumentBuffer;
import com.oracle.truffle.llvm.runtime.LLVMContextWindows;
import com.oracle.truffle.llvm.runtime.LLVMExitException;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMScope;
import com.oracle.truffle.llvm.runtime.LLVMScopeChain;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LLVMThread;
import com.oracle.truffle.llvm.runtime.LLVMThreadLocalPointer;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.PlatformCapability;
import com.oracle.truffle.llvm.runtime.SulongLibrary;
import com.oracle.truffle.llvm.runtime.debug.LLVMSourceContext;
import com.oracle.truffle.llvm.runtime.except.LLVMIllegalSymbolIndexException;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.instruments.trace.LLVMTracerInstrument;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.memory.LLVMThreadingStack;
import com.oracle.truffle.llvm.runtime.nodes.vars.AggregateTLGlobalInPlaceNode;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.pthread.LLVMPThreadContext;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.Pair;

public final class LLVMContext {
    public static final String SULONG_INIT_CONTEXT = "__sulong_init_context";
    public static final String SULONG_DISPOSE_CONTEXT = "__sulong_dispose_context";
    private static final String START_METHOD_NAME = "_start";
    private static final Level NATIVE_CALL_STATISTICS_LEVEL = Level.FINER;
    private static final Level SYSCALLS_LOGGING_LEVEL = Level.FINER;
    private static final Level LL_DEBUG_VERBOSE_LOGGER_LEVEL = Level.FINER;
    private static final Level LL_DEBUG_WARNING_LOGGER_LEVEL = Level.WARNING;
    private static final Level TRACE_IR_LOGGER_LEVEL = Level.FINER;
    private static final Level PRINT_STACKTRACE_LEVEL = Level.INFO;
    private static final Level PRINT_AST_LOGGING_LEVEL = Level.FINEST;
    private final List<Path> libraryPaths = new ArrayList<Path>();
    private final Object libraryPathsLock = new Object();
    private final Object truffleFilesLock = new Object();
    private final Toolchain toolchain;
    private InternalLibraryLocator internalLibraryLocator;
    private final List<TruffleFile> truffleFiles = new ArrayList<TruffleFile>();
    private final List<String> internalLibraryNames;
    private final ConcurrentHashMap<LLVMPointer, List<LLVMSymbol>> symbolsReverseMap = new ConcurrentHashMap();
    protected final EconomicMap<Integer, Pair<LLVMPointer, Long>> globalsBlockStore = EconomicMap.create();
    protected final EconomicMap<Integer, Pair<LLVMPointer, Long>> globalsReadOnlyStore = EconomicMap.create();
    private final Object globalsStoreLock = new Object();
    public final Object atomicInstructionsLock = new Object();
    private final List<LLVMThread> runningThreads = new ArrayList<LLVMThread>();
    private final ReentrantLock threadInitLock = new ReentrantLock();
    private final EconomicSet<Thread> allRunningThreads = EconomicSet.create((Equivalence)Equivalence.IDENTITY_WITH_SYSTEM_HASHCODE);
    private final List<AggregateTLGlobalInPlaceNode> threadLocalGlobalInitializer = new ArrayList<AggregateTLGlobalInPlaceNode>();
    @CompilerDirectives.CompilationFinal
    private LLVMThreadingStack threadingStack;
    private Object[] mainArguments;
    private final ArrayList<LLVMNativePointer> caughtExceptionStack = new ArrayList();
    private ConcurrentHashMap<String, Integer> nativeCallStatistics;
    private final LLVMMemory.HandleContainer handleContainer;
    private final LLVMMemory.HandleContainer derefHandleContainer;
    private final LLVMSourceContext sourceContext;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private ContextExtension[] contextExtensions;
    @CompilerDirectives.CompilationFinal
    private TruffleLanguage.Env env;
    private LLVMScopeChain headGlobalScopeChain;
    private LLVMScopeChain tailGlobalScopeChain;
    private final DynamicLinkChain dynamicLinkChain;
    private final DynamicLinkChain dynamicLinkChainForScopes;
    private final LLVMFunctionPointerRegistry functionPointerRegistry;
    @CompilerDirectives.CompilationFinal(dimensions=2)
    private LLVMPointer[][] symbolFinalStorage;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private LLVMPointer[][] symbolDynamicStorage;
    @CompilerDirectives.CompilationFinal(dimensions=2)
    private Assumption[][] symbolAssumptions;
    private final EconomicMap<String, CallTarget> loadedLibrariesBySOName = EconomicMap.create();
    private boolean[] libraryLoaded;
    private RootCallTarget[] destructorFunctions;
    private final LLVMNativePointer sigDfl;
    private final LLVMNativePointer sigIgn;
    private final LLVMNativePointer sigErr;
    private LibraryLocator mainLibraryLocator;
    private SulongLibrary mainLibrary;
    private int currentDLError;
    private final LLVMPThreadContext pThreadContext;
    private final LLVMContextWindows windowsContext;
    @CompilerDirectives.CompilationFinal
    Object freeGlobalsBlockFunction;
    @CompilerDirectives.CompilationFinal
    Object allocateGlobalsBlockFunction;
    @CompilerDirectives.CompilationFinal
    Object protectGlobalsBlockFunction;
    protected boolean initialized;
    protected boolean cleanupNecessary;
    protected boolean finalized;
    private State contextState;
    private final LLVMLanguage language;
    private static final TruffleLanguage.ContextReference<LLVMContext> REFERENCE = TruffleLanguage.ContextReference.create(LLVMLanguage.class);
    private static final TruffleLogger loaderLogger = TruffleLogger.getLogger((String)"llvm", (String)"Loader");
    private static final TruffleLogger sysCallsLogger = TruffleLogger.getLogger((String)"llvm", (String)"SysCalls");
    private static final TruffleLogger nativeCallStatsLogger = TruffleLogger.getLogger((String)"llvm", (String)"NativeCallStats");
    private static final TruffleLogger lifetimeAnalysisLogger = TruffleLogger.getLogger((String)"llvm", (String)"LifetimeAnalysis");
    private static final TruffleLogger llDebugLogger = TruffleLogger.getLogger((String)"llvm", (String)"LLDebug");
    public static TruffleLogger traceIRLogger = TruffleLogger.getLogger((String)"llvm", (String)"TraceIR");
    private static final TruffleLogger printAstLogger = TruffleLogger.getLogger((String)"llvm", (String)"AST");
    private static final TruffleLogger stackTraceLogger = TruffleLogger.getLogger((String)"llvm", (String)"StackTrace");
    private static final TruffleLogger llvmLogger = TruffleLogger.getLogger((String)"llvm");

    LLVMContext(LLVMLanguage language, TruffleLanguage.Env env, Toolchain toolchain) {
        this.language = language;
        this.env = env;
        this.initialized = false;
        this.cleanupNecessary = false;
        this.finalized = false;
        this.nativeCallStatistics = LLVMContext.logNativeCallStatsEnabled() ? new ConcurrentHashMap() : null;
        this.sigDfl = LLVMNativePointer.create(0L);
        this.sigIgn = LLVMNativePointer.create(1L);
        this.sigErr = LLVMNativePointer.create(-1L);
        LLVMMemory memory = language.getLLVMMemory();
        this.handleContainer = memory.createHandleContainer(false, language.getNoCommonHandleAssumption());
        this.derefHandleContainer = memory.createHandleContainer(true, language.getNoDerefHandleAssumption());
        this.functionPointerRegistry = new LLVMFunctionPointerRegistry();
        this.sourceContext = new LLVMSourceContext();
        this.toolchain = toolchain;
        this.internalLibraryNames = Collections.unmodifiableList(Arrays.asList(language.getCapability(PlatformCapability.class).getSulongDefaultLibraries()));
        assert (!this.internalLibraryNames.isEmpty()) : "No internal libraries?";
        this.tailGlobalScopeChain = this.headGlobalScopeChain = new LLVMScopeChain();
        this.dynamicLinkChain = new DynamicLinkChain();
        this.dynamicLinkChainForScopes = new DynamicLinkChain();
        this.mainArguments = LLVMContext.getMainArguments(env);
        this.windowsContext = language.getCapability(PlatformCapability.class).getOS().equals((Object)InternalResource.OS.WINDOWS) ? new LLVMContextWindows() : null;
        this.addLibraryPaths(SulongEngineOption.getPolyglotOptionSearchPaths(env));
        this.currentDLError = 0;
        this.pThreadContext = new LLVMPThreadContext(this.getEnv(), this.getLanguage(), language.getDefaultDataLayout());
        this.symbolAssumptions = new Assumption[10][];
        this.symbolDynamicStorage = new LLVMPointer[10][];
        this.symbolFinalStorage = this.symbolDynamicStorage;
        this.libraryLoaded = new boolean[10];
        this.destructorFunctions = new RootCallTarget[10];
        this.contextState = State.CREATED;
    }

    void initializationDeferred() {
        this.contextState = State.INITIALIZATION_DEFERRED;
    }

    boolean patchContext(TruffleLanguage.Env newEnv, ContextExtension[] contextExtens) {
        if (this.contextState == State.INITIALIZED) {
            throw CompilerDirectives.shouldNotReachHere((String)"Context cannot be initialized during context pre-initialization");
        }
        this.env = newEnv;
        this.nativeCallStatistics = LLVMContext.logNativeCallStatsEnabled() ? new ConcurrentHashMap() : null;
        this.mainArguments = LLVMContext.getMainArguments(newEnv);
        if (this.contextState == State.INITIALIZATION_DEFERRED) {
            this.initialize(contextExtens);
        }
        return true;
    }

    private static Object[] getMainArguments(TruffleLanguage.Env environment) {
        Object mainArgs = environment.getConfig().get("Sulong Main Args");
        return mainArgs == null ? environment.getApplicationArguments() : (Object[])mainArgs;
    }

    void initialize(ContextExtension[] contextExtens) {
        this.contextState = State.INITIALIZED;
        assert (this.threadingStack == null);
        this.contextExtensions = contextExtens;
        if (LLVMContext.traceIREnabled()) {
            if (!((Boolean)this.env.getOptions().get(SulongEngineOption.LL_DEBUG)).booleanValue()) {
                LLVMContext.traceIRLog("Trace IR logging is enabled, but '--llvm.llDebug=true' is not set");
            }
            LLVMTracerInstrument.attach(this.env);
        }
        this.threadingStack = new LLVMThreadingStack(Thread.currentThread(), LLVMContext.parseStackSize((String)this.env.getOptions().get(SulongEngineOption.STACK_SIZE)));
        this.internalLibraryLocator = this.language.getCapability(InternalLibraryLocator.class);
        for (ContextExtension ext : this.contextExtensions) {
            ext.initialize(this);
        }
        try {
            PlatformCapability platformCapability = this.language.getCapability(PlatformCapability.class);
            String[] sulongLibraryNames = platformCapability.getSulongDefaultLibraries();
            if (this.language.isDefaultInternalLibraryCacheEmpty()) {
                for (int i = sulongLibraryNames.length - 1; i >= 0; --i) {
                    String libraryName = sulongLibraryNames[i];
                    Source librarySource = this.internalLibraryLocator.locateSource(this, libraryName, "<default bitcode library>");
                    if (librarySource == null) {
                        throw new InternalError("Could not locate library " + libraryName + " with locator " + String.valueOf(this.internalLibraryLocator) + ".");
                    }
                    this.env.parseInternal(librarySource, new String[0]);
                    this.language.setDefaultInternalLibraryCache(librarySource);
                }
            }
            this.setLibsulongAuxFunction(SULONG_INIT_CONTEXT);
            this.setLibsulongAuxFunction(SULONG_DISPOSE_CONTEXT);
            this.setLibsulongAuxFunction(START_METHOD_NAME);
            Source builtinsSource = this.internalLibraryLocator.locateSource(this, platformCapability.getBuiltinsLibrary(), "<builtins library>");
            CallTarget builtinsLibrary = this.env.parseInternal(builtinsSource, new String[0]);
            builtinsLibrary.call(new Object[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public LLVMContextWindows getWindowsContext() {
        assert (this.windowsContext != null);
        return this.windowsContext;
    }

    public boolean isAOTCacheStore() {
        return (Boolean)this.env.getOptions().get(SulongEngineOption.AOTCacheStore);
    }

    public boolean isAOTCacheLoad() {
        return (Boolean)this.env.getOptions().get(SulongEngineOption.AOTCacheLoad);
    }

    private void setLibsulongAuxFunction(String name) {
        LLVMScope fileScope = this.language.getInternalFileScopes("libsulong");
        LLVMSymbol contextFunction = fileScope.get(name);
        if (contextFunction != null && contextFunction.isFunction()) {
            if (name.equals(SULONG_INIT_CONTEXT)) {
                this.language.setSulongInitContext(contextFunction.asFunction());
            } else if (name.equals(SULONG_DISPOSE_CONTEXT)) {
                this.language.setSulongDisposeContext(contextFunction.asFunction());
            } else if (name.equals(START_METHOD_NAME)) {
                this.language.setStartFunctionCode(new LLVMFunctionCode(contextFunction.asFunction()));
            }
        } else {
            throw new IllegalStateException("Context cannot be initialized: " + name + " was not found in sulong libraries");
        }
    }

    ContextExtension getContextExtension(int index) {
        CompilerAsserts.partialEvaluationConstant((int)index);
        return this.contextExtensions[index];
    }

    public LibraryLocator getMainLibraryLocator() {
        return this.mainLibraryLocator;
    }

    public void setMainLibraryLocator(LibraryLocator libraryLocator) {
        this.mainLibraryLocator = libraryLocator;
    }

    public SulongLibrary getMainLibrary() {
        return this.mainLibrary;
    }

    public void setMainLibrary(SulongLibrary mainLibrary) {
        if (mainLibrary == null) {
            this.mainLibrary = mainLibrary;
        }
    }

    public <T extends ContextExtension> T getContextExtension(Class<T> type) {
        CompilerAsserts.neverPartOfCompilation();
        ContextExtension.Key<T> key = this.language.lookupContextExtension(type);
        if (key == null) {
            throw new IllegalStateException("Context extension of type " + type.getSimpleName() + " not found");
        }
        return key.get(this);
    }

    public <T extends ContextExtension> T getContextExtensionOrNull(Class<T> type) {
        CompilerAsserts.neverPartOfCompilation();
        ContextExtension.Key<T> key = this.language.lookupContextExtension(type);
        if (key == null) {
            return null;
        }
        return key.get(this);
    }

    private static long parseStackSize(String v) {
        String valueString = v.trim();
        long scale = 1L;
        switch (valueString.charAt(valueString.length() - 1)) {
            case 'K': 
            case 'k': {
                scale = 1024L;
                break;
            }
            case 'M': 
            case 'm': {
                scale = 0x100000L;
                break;
            }
            case 'G': 
            case 'g': {
                scale = 0x40000000L;
                break;
            }
            case 'T': 
            case 't': {
                scale = 0x10000000000L;
            }
        }
        if (scale != 1L) {
            valueString = valueString.substring(0, valueString.length() - 1);
        }
        return Long.parseLong(valueString) * scale;
    }

    public boolean isInitialized() {
        return this.threadingStack != null;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public Toolchain getToolchain() {
        return this.toolchain;
    }

    @CompilerDirectives.TruffleBoundary
    protected LLVMManagedPointer getApplicationArguments() {
        String[] result;
        if (this.mainArguments == null) {
            result = new String[]{""};
        } else {
            result = new String[this.mainArguments.length + 1];
            result[0] = "";
            for (int i = 1; i < result.length; ++i) {
                result[i] = this.mainArguments[i - 1].toString();
            }
        }
        return LLVMContext.toManagedObjects(result);
    }

    @CompilerDirectives.TruffleBoundary
    protected static LLVMManagedPointer getEnvironmentVariables() {
        String[] result = (String[])System.getenv().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).toArray(String[]::new);
        return LLVMContext.toManagedObjects(result);
    }

    @CompilerDirectives.TruffleBoundary
    protected static LLVMManagedPointer getRandomValues() {
        byte[] result = new byte[16];
        LLVMContext.secureRandom().nextBytes(result);
        return LLVMContext.toManagedPointer(new LLVMArgumentBuffer(result));
    }

    private static SecureRandom secureRandom() {
        return new SecureRandom();
    }

    public static LLVMManagedPointer toManagedObjects(String[] values) {
        LLVMArgumentBuffer[] result = new LLVMArgumentBuffer[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = new LLVMArgumentBuffer(values[i]);
        }
        return LLVMContext.toManagedPointer(new LLVMArgumentBuffer.LLVMArgumentArray(result));
    }

    private static LLVMManagedPointer toManagedPointer(Object value) {
        return LLVMManagedPointer.create(value);
    }

    public static LLVMContext get(Node node) {
        return (LLVMContext)REFERENCE.get(node);
    }

    private void cleanUpNoGuestCode() {
        Thread[] allThreads;
        if (this.language.getFreeGlobalBlocks() != null) {
            this.language.getFreeGlobalBlocks().call(new Object[0]);
        }
        try (TLSInitializerAccess access = this.getTLSInitializerAccess(true);){
            allThreads = access.getAllRunningThreads();
        }
        for (Thread thread : allThreads) {
            LLVMLanguage.LLVMThreadLocalValue value = (LLVMLanguage.LLVMThreadLocalValue)this.language.contextThreadLocal.get(this.getEnv().getContext(), thread);
            if (value == null) continue;
            this.language.freeThreadLocalGlobal(value);
        }
    }

    private void cleanUpGuestCode(LLVMFunction sulongDisposeContext) {
        if (this.cleanupNecessary) {
            try {
                if (sulongDisposeContext == null) {
                    throw new IllegalStateException("Context cannot be disposed: __sulong_dispose_context was not found");
                }
                LLVMPointer pointer = this.getSymbolUncached(sulongDisposeContext);
                if (!LLVMManagedPointer.isInstance(pointer)) {
                    throw new IllegalStateException("Context cannot be disposed: __sulong_dispose_context is not a function or enclosed inside a LLVMManagedPointer");
                }
                LLVMFunctionDescriptor functionDescriptor = (LLVMFunctionDescriptor)LLVMManagedPointer.cast(pointer).getObject();
                RootCallTarget disposeContext = functionDescriptor.getFunctionCode().getLLVMIRFunctionSlowPath();
                LLVMStack stack = this.threadingStack.getStack(this.language);
                disposeContext.call(new Object[]{stack});
            }
            catch (ControlFlowException | LLVMExitException object) {
                // empty catch block
            }
        }
    }

    void exitContext(LLVMFunction sulongDisposeContext) {
        this.cleanUpGuestCode(sulongDisposeContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finalizeContext() {
        this.pThreadContext.joinAllThreads();
        boolean cancelling = this.env.getContext().isCancelling();
        if (!cancelling) {
            this.language.disposeThread(this, Thread.currentThread());
        }
        TruffleSafepoint sp = TruffleSafepoint.getCurrent();
        boolean prev = sp.setAllowActions(false);
        try {
            if (cancelling) {
                this.language.disposeThreadNoGuestCode(this, Thread.currentThread());
            }
            this.cleanUpNoGuestCode();
        }
        finally {
            sp.setAllowActions(prev);
        }
        this.finalized = true;
    }

    void dispose() {
        this.printNativeCallStatistics();
        if (this.isInitialized()) {
            this.getThreadingStack().freeMainStack(this.language.getLLVMMemory());
        }
        for (LLVMPointer pointer : this.symbolsReverseMap.keySet()) {
            Object object;
            if (!LLVMManagedPointer.isInstance(pointer) || !((object = LLVMManagedPointer.cast(pointer).getObject()) instanceof LLVMGlobalContainer)) continue;
            ((LLVMGlobalContainer)object).dispose();
        }
    }

    public Object getFreeGlobalsBlockFunction() {
        if (this.freeGlobalsBlockFunction == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            NativeContextExtension nativeContextExtension = this.getContextExtensionOrNull(NativeContextExtension.class);
            this.freeGlobalsBlockFunction = nativeContextExtension.getNativeFunction("__sulong_free_globals_block", "(POINTER, UINT64):VOID");
        }
        return this.freeGlobalsBlockFunction;
    }

    public Object getProtectReadOnlyGlobalsBlockFunction() {
        if (this.protectGlobalsBlockFunction == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            NativeContextExtension nativeContextExtension = this.getContextExtensionOrNull(NativeContextExtension.class);
            this.protectGlobalsBlockFunction = nativeContextExtension.getNativeFunction("__sulong_protect_readonly_globals_block", "(POINTER, UINT64):VOID");
        }
        return this.protectGlobalsBlockFunction;
    }

    public Object getAllocateGlobalsBlockFunction() {
        if (this.allocateGlobalsBlockFunction == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            NativeContextExtension nativeContextExtension = this.getContextExtensionOrNull(NativeContextExtension.class);
            this.allocateGlobalsBlockFunction = nativeContextExtension.getNativeFunction("__sulong_allocate_globals_block", "(UINT64):POINTER");
        }
        return this.allocateGlobalsBlockFunction;
    }

    public List<String> preprocessDependencies(List<String> libraries, String libraryName, boolean isInternal) {
        return this.language.getCapability(PlatformCapability.class).preprocessDependencies(this, libraryName, isInternal, libraries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TruffleFile getOrAddTruffleFile(TruffleFile file) {
        Object object = this.truffleFilesLock;
        synchronized (object) {
            int index = this.truffleFiles.indexOf(file);
            if (index >= 0) {
                TruffleFile ret = this.truffleFiles.get(index);
                assert (ret.equals((Object)file));
                return ret;
            }
            this.truffleFiles.add(file);
            return file;
        }
    }

    public void addLibraryPaths(List<String> paths) {
        for (String p : paths) {
            this.addLibraryPath(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLibraryPath(String p) {
        Path path = Paths.get(p, new String[0]);
        TruffleFile file = this.getEnv().getInternalTruffleFile(path.toString());
        if (file.isDirectory(new LinkOption[0])) {
            Object object = this.libraryPathsLock;
            synchronized (object) {
                if (!this.libraryPaths.contains(path)) {
                    this.libraryPaths.add(path);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Path> getLibraryPaths() {
        Object object = this.libraryPathsLock;
        synchronized (object) {
            return this.libraryPaths;
        }
    }

    public boolean isLibraryAlreadyLoaded(IDGenerater.BitcodeID bitcodeID) {
        int id = bitcodeID.getId();
        return id < this.libraryLoaded.length && this.libraryLoaded[id];
    }

    public void markLibraryLoaded(IDGenerater.BitcodeID bitcodeID) {
        int id = bitcodeID.getId();
        if (id >= this.libraryLoaded.length) {
            int newLength = id + 1 + (id + 1) / 2;
            boolean[] temp = new boolean[newLength];
            System.arraycopy(this.libraryLoaded, 0, temp, 0, this.libraryLoaded.length);
            this.libraryLoaded = temp;
        }
        this.libraryLoaded[id] = true;
    }

    public void registerDestructorFunctions(IDGenerater.BitcodeID bitcodeID, RootCallTarget destructor) {
        assert (destructor != null);
        int id = bitcodeID.getId();
        if (id >= this.destructorFunctions.length) {
            int newLength = id + 1 + (id + 1) / 2;
            RootCallTarget[] temp = new RootCallTarget[newLength];
            System.arraycopy(this.destructorFunctions, 0, temp, 0, this.destructorFunctions.length);
            this.destructorFunctions = temp;
        }
        this.destructorFunctions[id] = destructor;
    }

    @CompilerDirectives.TruffleBoundary
    public void addCalltargetForLoadedLibrary(String soName, CallTarget callTarget) {
        if (!this.loadedLibrariesBySOName.containsKey((Object)soName)) {
            this.loadedLibrariesBySOName.put((Object)soName, (Object)callTarget);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public CallTarget getCalltargetFromCache(String soName) {
        return (CallTarget)this.loadedLibrariesBySOName.get((Object)soName);
    }

    public LLVMLanguage getLanguage() {
        return this.language;
    }

    public TruffleLanguage.Env getEnv() {
        return this.env;
    }

    public LLVMScopeChain getGlobalScopeChain() {
        return this.headGlobalScopeChain;
    }

    public synchronized void addGlobalScope(LLVMScopeChain scope) {
        if (this.headGlobalScopeChain.getScope() == null && this.headGlobalScopeChain.getId().same(IDGenerater.INVALID_ID)) {
            this.headGlobalScopeChain = scope;
        } else {
            this.tailGlobalScopeChain.concatNextChain(scope);
        }
        this.tailGlobalScopeChain = scope;
    }

    public synchronized void removeGlobalScope(IDGenerater.BitcodeID id) {
        assert (!this.headGlobalScopeChain.getId().equals(id));
        for (LLVMScopeChain tmp = this.headGlobalScopeChain.getNext(); tmp != null; tmp = tmp.getNext()) {
            if (!tmp.getId().equals(id)) continue;
            this.removeGlobalScope(tmp);
            return;
        }
    }

    private synchronized void removeGlobalScope(LLVMScopeChain scope) {
        assert (scope != this.headGlobalScopeChain);
        scope.getPrev().setNext(scope.getNext());
        if (this.tailGlobalScopeChain == scope) {
            this.tailGlobalScopeChain = scope.getPrev();
        } else {
            scope.getNext().setPrev(scope.getPrev());
        }
        scope.setNext(null);
        scope.setPrev(null);
    }

    public LLVMPointer getSymbolUncached(LLVMSymbol symbol) throws LLVMIllegalSymbolIndexException {
        CompilerAsserts.neverPartOfCompilation();
        return this.getSymbol(symbol, BranchProfile.getUncached());
    }

    public LLVMPointer getSymbol(LLVMSymbol symbol, BranchProfile exception) throws LLVMIllegalSymbolIndexException {
        assert (!symbol.isAlias());
        IDGenerater.BitcodeID bitcodeID = symbol.getBitcodeID(exception);
        int id = bitcodeID.getId();
        int index = symbol.getSymbolIndex(exception);
        if (CompilerDirectives.inCompiledCode() && CompilerDirectives.isPartialEvaluationConstant((Object)this) && CompilerDirectives.isPartialEvaluationConstant((Object)symbol)) {
            if (!this.symbolAssumptions[id][index].isValid()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            try {
                return this.symbolFinalStorage[id][index];
            }
            catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
                exception.enter();
                if (LibraryLocator.loggingEnabled()) {
                    loaderLogger.log(Level.FINEST, Arrays.toString(e.getStackTrace()));
                    loaderLogger.log(Level.FINEST, "symbol is: " + symbol.getName());
                    loaderLogger.log(Level.FINEST, "id is: " + id);
                    loaderLogger.log(Level.FINEST, "id name is: " + bitcodeID.getName());
                    loaderLogger.log(Level.FINEST, "index is: " + index);
                }
                throw new LLVMIllegalSymbolIndexException("cannot find symbol");
            }
        }
        try {
            return this.symbolDynamicStorage[id][index];
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            exception.enter();
            if (LibraryLocator.loggingEnabled()) {
                loaderLogger.log(Level.FINEST, Arrays.toString(e.getStackTrace()));
                loaderLogger.log(Level.FINEST, "symbol is: " + symbol.getName());
                loaderLogger.log(Level.FINEST, "id is: " + id);
                loaderLogger.log(Level.FINEST, "id name is: " + bitcodeID.getName());
                loaderLogger.log(Level.FINEST, "index is: " + index);
            }
            throw new LLVMIllegalSymbolIndexException("cannot find symbol");
        }
    }

    public LLVMPointer getSymbolResolved(LLVMSymbol symbol, BranchProfile exception) throws LLVMIllegalSymbolIndexException {
        LLVMPointer target = this.getSymbol(symbol, exception);
        if (symbol.isThreadLocalSymbol()) {
            LLVMThreadLocalPointer pointer = (LLVMThreadLocalPointer)LLVMManagedPointer.cast(target).getObject();
            return pointer.resolve(this.language, exception);
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void initializeSymbol(LLVMSymbol symbol, LLVMPointer value) {
        assert (!symbol.isAlias());
        IDGenerater.BitcodeID bitcodeID = symbol.getBitcodeIDUncached();
        int id = bitcodeID.getId();
        LLVMPointer[] symbols = this.symbolDynamicStorage[id];
        Assumption[] assumptions = this.symbolAssumptions[id];
        LLVMPointer[] lLVMPointerArray = symbols;
        synchronized (symbols) {
            try {
                int index = symbol.getSymbolIndexUncached();
                if (symbols[index] != null && symbols[index].isSame(value)) {
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    return;
                }
                symbols[index] = value;
                assumptions[index] = Truffle.getRuntime().createAssumption();
                if (symbol instanceof LLVMFunction) {
                    ((LLVMFunction)symbol).setValue(value);
                }
            }
            catch (LLVMIllegalSymbolIndexException e) {
                throw new LLVMLinkerException("Writing symbol into symbol table is inconsistent.");
            }
            return;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public boolean checkSymbol(LLVMSymbol symbol) {
        IDGenerater.BitcodeID bitcodeID;
        int id;
        assert (!symbol.isAlias());
        if (symbol.hasValidIndexAndID() && (id = (bitcodeID = symbol.getBitcodeIDUncached()).getId()) < this.symbolDynamicStorage.length && this.symbolDynamicStorage[id] != null) {
            LLVMPointer[] symbols = this.symbolDynamicStorage[id];
            int index = symbol.getSymbolIndexUncached();
            return symbols[index] != null;
        }
        throw new LLVMLinkerException(String.format("External %s %s cannot be found.", symbol.getKind(), symbol.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSymbol(LLVMSymbol symbol, LLVMPointer value) {
        CompilerAsserts.neverPartOfCompilation();
        LLVMSymbol target = LLVMAlias.resolveAlias(symbol);
        IDGenerater.BitcodeID bitcodeID = symbol.getBitcodeIDUncached();
        int id = bitcodeID.getId();
        LLVMPointer[] symbols = this.symbolDynamicStorage[id];
        Assumption[] assumptions = this.symbolAssumptions[id];
        LLVMPointer[] lLVMPointerArray = symbols;
        synchronized (symbols) {
            try {
                int index = target.getSymbolIndexUncached();
                symbols[index] = value;
                assumptions[index].invalidate();
                assumptions[index] = Truffle.getRuntime().createAssumption();
                if (target instanceof LLVMFunction) {
                    ((LLVMFunction)target).setValue(value);
                }
            }
            catch (LLVMIllegalSymbolIndexException e) {
                throw CompilerDirectives.shouldNotReachHere((String)("symbol to be replaced was not found: " + String.valueOf(target)));
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void initializeSymbolTable(IDGenerater.BitcodeID bitcodeID, int globalLength) {
        LLVMContext lLVMContext = this;
        synchronized (lLVMContext) {
            int index = bitcodeID.getId();
            assert (this.symbolDynamicStorage == this.symbolFinalStorage);
            if (index < this.symbolDynamicStorage.length && this.symbolDynamicStorage[index] != null) {
                return;
            }
            if (index >= this.symbolDynamicStorage.length) {
                int newLength = index + 1 + (index + 1) / 2;
                this.symbolAssumptions = (Assumption[][])Arrays.copyOf(this.symbolAssumptions, newLength);
                this.symbolDynamicStorage = (LLVMPointer[][])Arrays.copyOf(this.symbolDynamicStorage, newLength);
                this.symbolFinalStorage = this.symbolDynamicStorage;
            }
            this.symbolAssumptions[index] = new Assumption[globalLength];
            this.symbolDynamicStorage[index] = new LLVMPointer[globalLength];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSymbolTable(IDGenerater.BitcodeID id) {
        LLVMContext lLVMContext = this;
        synchronized (lLVMContext) {
            int index = id.getId();
            this.symbolAssumptions[index] = null;
            this.symbolDynamicStorage[index] = null;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMFunctionDescriptor getFunctionDescriptor(LLVMNativePointer handle) {
        return this.functionPointerRegistry.getDescriptor(handle);
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMFunctionDescriptor createFunctionDescriptor(LLVMFunction functionDetail, LLVMFunctionCode functionCode) {
        return this.functionPointerRegistry.create(functionDetail, functionCode);
    }

    @CompilerDirectives.TruffleBoundary
    public void registerFunctionPointer(LLVMNativePointer address, LLVMFunctionDescriptor descriptor) {
        this.functionPointerRegistry.register(address, descriptor);
    }

    public LLVMNativePointer getSigDfl() {
        return this.sigDfl;
    }

    public LLVMNativePointer getSigIgn() {
        return this.sigIgn;
    }

    public LLVMNativePointer getSigErr() {
        return this.sigErr;
    }

    public LLVMMemory.HandleContainer getHandleContainer() {
        return this.handleContainer;
    }

    public LLVMMemory.HandleContainer getDerefHandleContainer() {
        return this.derefHandleContainer;
    }

    @CompilerDirectives.TruffleBoundary
    public void registerNativeCall(LLVMFunctionDescriptor descriptor) {
        if (this.nativeCallStatistics != null) {
            String name = descriptor.getLLVMFunction().getName() + " " + String.valueOf(descriptor.getLLVMFunction().getType());
            if (this.nativeCallStatistics.containsKey(name)) {
                int count = this.nativeCallStatistics.get(name) + 1;
                this.nativeCallStatistics.put(name, count);
            } else {
                this.nativeCallStatistics.put(name, 1);
            }
        }
    }

    public List<LLVMNativePointer> getCaughtExceptionStack() {
        return this.caughtExceptionStack;
    }

    public LLVMThreadingStack getThreadingStack() {
        assert (this.threadingStack != null);
        return this.threadingStack;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isScopeLoaded(LLVMScope scope) {
        return this.dynamicLinkChain.containsScope(scope);
    }

    @CompilerDirectives.TruffleBoundary
    public void registerScope(LLVMScope scope) {
        this.dynamicLinkChain.addScope(scope);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isScopeLoadedForScopes(LLVMScope scope) {
        return this.dynamicLinkChainForScopes.containsScope(scope);
    }

    @CompilerDirectives.TruffleBoundary
    public void registerScopeForScopes(LLVMScope scope) {
        this.dynamicLinkChainForScopes.addScope(scope);
    }

    public synchronized void registerThread(LLVMThread thread) {
        assert (!this.runningThreads.contains(thread));
        this.runningThreads.add(thread);
    }

    public synchronized void unregisterThread(LLVMThread thread) {
        this.runningThreads.remove(thread);
        assert (!this.runningThreads.contains(thread));
    }

    public TLSInitializerAccess getTLSInitializerAccess(boolean interruptible) {
        return new TLSInitializerAccess(interruptible);
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void shutdownThreads() {
        for (LLVMThread node : new ArrayList<LLVMThread>(this.runningThreads)) {
            node.stop();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public synchronized void awaitThreadTermination() {
        this.shutdownThreads();
        while (!this.runningThreads.isEmpty()) {
            LLVMThread node = this.runningThreads.get(0);
            node.awaitFinish();
            assert (!this.runningThreads.contains(node));
        }
    }

    public RootCallTarget[] getDestructorFunctions() {
        return this.destructorFunctions;
    }

    public synchronized List<LLVMThread> getRunningThreads() {
        return Collections.unmodifiableList(this.runningThreads);
    }

    public LLVMSourceContext getSourceContext() {
        return this.sourceContext;
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMGlobal findGlobal(LLVMPointer pointer) {
        List<LLVMSymbol> symbols = this.symbolsReverseMap.get(pointer);
        if (symbols == null) {
            return null;
        }
        return symbols.get(0).asGlobalVariable();
    }

    @CompilerDirectives.TruffleBoundary
    public List<LLVMSymbol> findSymbols(LLVMPointer pointer) {
        return this.symbolsReverseMap.get(pointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void registerGlobals(int id, LLVMPointer base, long size, NodeFactory nodeFactory) {
        Object object = this.globalsStoreLock;
        synchronized (object) {
            this.language.initFreeGlobalBlocks(nodeFactory);
            this.globalsBlockStore.put((Object)id, (Object)Pair.create((Object)base, (Object)size));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public void registerReadOnlyGlobals(int id, LLVMPointer base, long size, NodeFactory nodeFactory) {
        Object object = this.globalsStoreLock;
        synchronized (object) {
            this.language.initFreeGlobalBlocks(nodeFactory);
            this.globalsReadOnlyStore.put((Object)id, (Object)Pair.create((Object)base, (Object)size));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public Pair<LLVMPointer, Long> getGlobals(IDGenerater.BitcodeID bitcodeID) {
        Object object = this.globalsStoreLock;
        synchronized (object) {
            return (Pair)this.globalsBlockStore.get((Object)bitcodeID.getId());
        }
    }

    public LLVMPointer getGlobalsBase(IDGenerater.BitcodeID bitcodeID) {
        Pair<LLVMPointer, Long> pair = this.getGlobals(bitcodeID);
        return pair == null ? null : (LLVMPointer)pair.getLeft();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public Pair<LLVMPointer, Long> getReadOnlyGlobals(IDGenerater.BitcodeID bitcodeID) {
        Object object = this.globalsStoreLock;
        synchronized (object) {
            return (Pair)this.globalsReadOnlyStore.get((Object)bitcodeID.getId());
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void registerSymbolReverseMap(List<LLVMSymbol> symbols, LLVMPointer pointer) {
        this.symbolsReverseMap.put(pointer, symbols);
    }

    @CompilerDirectives.TruffleBoundary
    public void registerSymbol(LLVMSymbol symbol, LLVMPointer pointer) {
        this.symbolsReverseMap.get(pointer).add(symbol);
    }

    @CompilerDirectives.TruffleBoundary
    public List<LLVMSymbol> removeSymbolReverseMap(LLVMPointer pointer) {
        return this.symbolsReverseMap.remove(pointer);
    }

    public void setCleanupNecessary(boolean value) {
        this.cleanupNecessary = value;
    }

    private void printNativeCallStatistics() {
        if (LLVMContext.logNativeCallStatsEnabled()) {
            LinkedHashMap sorted = this.nativeCallStatistics.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
            for (String s : sorted.keySet()) {
                nativeCallStatsLogger.log(NATIVE_CALL_STATISTICS_LEVEL, String.format("Function %s \t count: %d\n", s, sorted.get(s)));
            }
        }
    }

    public void setDLError(int error) {
        this.currentDLError = error;
    }

    public int getCurrentDLError() {
        return this.currentDLError;
    }

    public LLVMPThreadContext getpThreadContext() {
        return this.pThreadContext;
    }

    public static TruffleLogger loaderLogger() {
        return loaderLogger;
    }

    public static TruffleLogger sysCallsLogger() {
        return sysCallsLogger;
    }

    public static boolean logSysCallsEnabled() {
        return LLVMContext.sysCallsLogger().isLoggable(SYSCALLS_LOGGING_LEVEL);
    }

    @CompilerDirectives.TruffleBoundary
    public static void logSysCall(String message) {
        LLVMContext.sysCallsLogger().log(SYSCALLS_LOGGING_LEVEL, message);
    }

    public static boolean logNativeCallStatsEnabled() {
        return nativeCallStatsLogger.isLoggable(NATIVE_CALL_STATISTICS_LEVEL);
    }

    public static TruffleLogger lifetimeAnalysisLogger() {
        return lifetimeAnalysisLogger;
    }

    public static boolean llDebugVerboseEnabled() {
        return llDebugLogger.isLoggable(LL_DEBUG_VERBOSE_LOGGER_LEVEL);
    }

    public static void llDebugVerboseLog(String message) {
        llDebugLogger.log(LL_DEBUG_VERBOSE_LOGGER_LEVEL, message);
    }

    public static boolean llDebugWarningEnabled() {
        return llDebugLogger.isLoggable(LL_DEBUG_WARNING_LOGGER_LEVEL);
    }

    public static void llDebugWarningLog(String message) {
        llDebugLogger.log(LL_DEBUG_WARNING_LOGGER_LEVEL, message);
    }

    public static TruffleLogger llDebugLogger() {
        return llDebugLogger;
    }

    public static TruffleLogger traceIRLogger() {
        return traceIRLogger;
    }

    public static boolean traceIREnabled() {
        return traceIRLogger.isLoggable(TRACE_IR_LOGGER_LEVEL);
    }

    public static void traceIRLog(String message) {
        traceIRLogger.log(TRACE_IR_LOGGER_LEVEL, message);
    }

    public static TruffleLogger printAstLogger() {
        return printAstLogger;
    }

    public static boolean printAstEnabled() {
        return printAstLogger.isLoggable(PRINT_AST_LOGGING_LEVEL);
    }

    public static void printAstLog(String message) {
        printAstLogger.log(PRINT_AST_LOGGING_LEVEL, message);
    }

    public static boolean stackTraceEnabled() {
        return stackTraceLogger.isLoggable(PRINT_STACKTRACE_LEVEL);
    }

    public static void stackTraceLog(String message) {
        stackTraceLogger.log(PRINT_STACKTRACE_LEVEL, message);
    }

    public static TruffleLogger llvmLogger() {
        return llvmLogger;
    }

    private final class LLVMFunctionPointerRegistry {
        private final HashMap<LLVMNativePointer, LLVMFunctionDescriptor> functionDescriptors = new HashMap();

        private LLVMFunctionPointerRegistry() {
        }

        synchronized LLVMFunctionDescriptor getDescriptor(LLVMNativePointer pointer) {
            return this.functionDescriptors.get(pointer);
        }

        synchronized void register(LLVMNativePointer pointer, LLVMFunctionDescriptor desc) {
            this.functionDescriptors.put(pointer, desc);
        }

        synchronized LLVMFunctionDescriptor create(LLVMFunction functionDetail, LLVMFunctionCode functionCode) {
            return new LLVMFunctionDescriptor(functionDetail, functionCode);
        }
    }

    private static class DynamicLinkChain {
        private final ArrayList<LLVMScope> scopes = new ArrayList();

        DynamicLinkChain() {
        }

        private void addScope(LLVMScope newScope) {
            if (!this.scopes.contains(newScope)) {
                this.scopes.add(newScope);
            }
        }

        private boolean containsScope(LLVMScope scope) {
            return this.scopes.contains(scope);
        }
    }

    private static enum State {
        CREATED,
        INITIALIZATION_DEFERRED,
        INITIALIZED;

    }

    public final class TLSInitializerAccess
    implements AutoCloseable {
        @CompilerDirectives.TruffleBoundary
        private TLSInitializerAccess(boolean interruptible) {
            if (interruptible) {
                TruffleSafepoint.setBlockedThreadInterruptible(null, ReentrantLock::lockInterruptibly, (Object)LLVMContext.this.threadInitLock);
            } else {
                LLVMContext.this.threadInitLock.lock();
            }
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public void close() {
            LLVMContext.this.threadInitLock.unlock();
        }

        public void registerLiveThread(Thread thread) {
            assert (!LLVMContext.this.allRunningThreads.contains((Object)thread));
            LLVMContext.this.allRunningThreads.add((Object)thread);
        }

        public void unregisterLiveThread(Thread thread) {
            LLVMContext.this.allRunningThreads.remove((Object)thread);
            assert (!LLVMContext.this.allRunningThreads.contains((Object)thread));
        }

        @CompilerDirectives.TruffleBoundary
        public Thread[] getAllRunningThreads() {
            return (Thread[])LLVMContext.this.allRunningThreads.toArray((Object[])new Thread[LLVMContext.this.allRunningThreads.size()]);
        }

        @CompilerDirectives.TruffleBoundary
        public void addThreadLocalGlobalInitializer(AggregateTLGlobalInPlaceNode inPlaceNode) {
            assert (!LLVMContext.this.threadLocalGlobalInitializer.contains((Object)inPlaceNode));
            LLVMContext.this.threadLocalGlobalInitializer.add(inPlaceNode);
        }

        public void removeThreadLocalGlobalInitializer(AggregateTLGlobalInPlaceNode inPlaceNode) {
            LLVMContext.this.threadLocalGlobalInitializer.remove((Object)inPlaceNode);
            assert (!LLVMContext.this.threadLocalGlobalInitializer.contains((Object)inPlaceNode));
        }

        public List<AggregateTLGlobalInPlaceNode> getThreadLocalGlobalInitializer() {
            return LLVMContext.this.threadLocalGlobalInitializer;
        }
    }

    public static final class InternalLocator {
        public static LibraryLocator INSTANCE = new LibraryLocator(){

            @Override
            protected Object locateLibrary(LLVMContext context, String lib, Object reason) {
                return context.internalLibraryLocator.locateLibrary(context, lib, reason);
            }
        };

        private InternalLocator() {
        }
    }
}

