/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants;

import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.constants.AbstractConstant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.Constant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class SelectConstant
extends AbstractConstant {
    private Constant condition;
    private Constant trueValue;
    private Constant falseValue;

    private SelectConstant(Type type) {
        super(type);
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.condition == original) {
            this.condition = (Constant)replacement;
        }
        if (this.falseValue == original) {
            this.falseValue = (Constant)replacement;
        }
        if (this.trueValue == original) {
            this.trueValue = (Constant)replacement;
        }
    }

    public static SelectConstant fromSymbols(SymbolTable symbols, Type type, int condition, int trueValue, int falseValue) {
        SelectConstant constant = new SelectConstant(type);
        constant.condition = symbols.getForwardReferenced(condition, constant);
        constant.trueValue = symbols.getForwardReferenced(trueValue, constant);
        constant.falseValue = symbols.getForwardReferenced(falseValue, constant);
        return constant;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public LLVMExpressionNode createNode(LLVMParserRuntime runtime, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        LLVMExpressionNode conditionNode = this.condition.createNode(runtime, dataLayout, stackFactory);
        LLVMExpressionNode trueValueNode = this.trueValue.createNode(runtime, dataLayout, stackFactory);
        LLVMExpressionNode falseValueNode = this.falseValue.createNode(runtime, dataLayout, stackFactory);
        return runtime.getNodeFactory().createSelect(this.getType(), conditionNode, trueValueNode, falseValueNode);
    }
}

