/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.factories;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.LLVMIntrinsicProvider;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMArgNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMRaiseExceptionNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMRaiseExceptionWindowsNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMWindowsInitThreadIntrinsicsFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMAbortNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMCMathsIntrinsicsFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMCTypeIntrinsicsFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMDLCloseNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMDLOpenNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMDLSymNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMExitNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMMemIntrinsicFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMSignalNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMSyscall;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.handles.GraalVMCreateDerefHandleNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.handles.GraalVMCreateHandleNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.handles.GraalVMIsHandleNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.handles.GraalVMPointsToHandleSpaceNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.handles.GraalVMReleaseHandleNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.handles.GraalVMResolveFunctionNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.handles.GraalVMResolveHandleNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.handles.LLVMTruffleCannotBeHandle;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotAsPrimitive;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotAsString;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotBoxedPredicateNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotBufferInfo;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotEval;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotExportNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotFromBufferNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotFromPrimitive;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotFromString;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotGetArraySizeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotGetStringSizeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotHasMemberNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotImportNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotInstantFromTimeNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotInvokeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotIsValueNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotJavaTypeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotNewInstanceNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotReadFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotRemoveFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotTimeZoneFromIdNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotTimeZoneGetIdNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMPolyglotWrite;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMTruffleDecorateFunctionNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMTruffleManagedMallocNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMTruffleWriteManagedToSymbolNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMVirtualMallocNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed.LLVMArrayTypeIDNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed.LLVMPolyglotAsTyped;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed.LLVMPolyglotFromTyped;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed.LLVMTypeIDNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsicRootNodeFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMMemoryIntrinsic;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMMemoryIntrinsicFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith.LLVMComplex80BitFloatDivNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith.LLVMComplex80BitFloatMulNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith.LLVMComplexDoubleDivNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith.LLVMComplexDoubleMulNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith.LLVMComplexFloatDivNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith.LLVMComplexFloatMulNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va.GraalVMVAArgNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMThreadIntrinsicsFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMThreadKeyIntrinsicsFactory;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.rust.LLVMPanicNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.sulong.LLVMPrintStackTraceNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.sulong.LLVMRunDestructorFunctionsNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.sulong.LLVMShouldPrintStackTraceOnAbortNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.sulong.LLVMToolchainNodeFactory;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.UnaryOperator;

public class BasicIntrinsicsProvider
implements LLVMIntrinsicProvider {
    protected final LLVMLanguage language;
    protected static final Demangler DEMANGLER = new Demangler();
    protected static final ConcurrentHashMap<String, LLVMTypedIntrinsicFactory> FACTORIES = new ConcurrentHashMap();

    @Override
    @CompilerDirectives.TruffleBoundary
    public final boolean isIntrinsified(String name) {
        return this.getFactory(name) != null;
    }

    @Override
    public final RootCallTarget generateIntrinsicTarget(String name, final List<Type> argTypes, NodeFactory nodeFactory) {
        CompilerAsserts.neverPartOfCompilation();
        LLVMTypedIntrinsicFactory factory = this.getFactory(name);
        if (factory == null) {
            return null;
        }
        return this.wrap(name, factory.generate((List<LLVMExpressionNode>)new AbstractList<LLVMExpressionNode>(this){
            final /* synthetic */ BasicIntrinsicsProvider this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public LLVMExpressionNode get(int index) {
                return LLVMArgNodeGen.create(index);
            }

            @Override
            public int size() {
                return argTypes.size();
            }
        }, nodeFactory, this.language, argTypes.toArray(Type.EMPTY_ARRAY)));
    }

    @Override
    public final LLVMExpressionNode generateIntrinsicNode(String name, LLVMExpressionNode[] arguments, Type[] argTypes, NodeFactory nodeFactory) {
        CompilerAsserts.neverPartOfCompilation();
        LLVMTypedIntrinsicFactory factory = this.getFactory(name);
        if (factory == null) {
            return null;
        }
        return factory.generate(Arrays.asList(arguments), nodeFactory, this.language, argTypes);
    }

    protected static LLVMTypedIntrinsicFactory getFactoryDemangle(String name, Map<String, LLVMTypedIntrinsicFactory> factories) {
        LLVMTypedIntrinsicFactory factory = factories.get(name);
        if (factory != null) {
            return factory;
        }
        String demangledName = DEMANGLER.demangle(name);
        if (demangledName == null || (factory = factories.get(demangledName)) == null) {
            return null;
        }
        BasicIntrinsicsProvider.add(name, factory, factories);
        return factory;
    }

    protected LLVMTypedIntrinsicFactory getFactory(String name) {
        return BasicIntrinsicsProvider.getFactoryDemangle(name, FACTORIES);
    }

    private RootCallTarget wrap(String functionName, LLVMExpressionNode node) {
        return LLVMIntrinsicRootNodeFactory.LLVMIntrinsicExpressionNodeGen.create(this.language, functionName, node).getCallTarget();
    }

    public BasicIntrinsicsProvider(LLVMLanguage language) {
        this.language = language;
    }

    protected Map<String, LLVMTypedIntrinsicFactory> getFactories() {
        return FACTORIES;
    }

    protected static LLVMExpressionNode[] argumentsArray(List<LLVMExpressionNode> arguments, int startIndex, int arity) {
        LLVMExpressionNode[] args = new LLVMExpressionNode[arity];
        for (int i = 0; i < arity; ++i) {
            args[i] = arguments.get(i + startIndex);
        }
        return args;
    }

    private static void registerThreadIntrinsics() {
        BasicIntrinsicsProvider.add("__sulong_thread_create", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMThreadIntrinsicsFactory.LLVMThreadCreateNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2))), (LLVMExpressionNode)((Object)((Object)args.get(3)))));
        BasicIntrinsicsProvider.add("pthread_exit", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMThreadIntrinsicsFactory.LLVMThreadExitNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("thrd_exit", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMThreadIntrinsicsFactory.LLVMThreadExitNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("__sulong_thread_setname_np", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMThreadIntrinsicsFactory.LLVMThreadSetNameNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("__sulong_thread_getname_np", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMThreadIntrinsicsFactory.LLVMThreadGetNameNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2))), (LLVMExpressionNode)((Object)((Object)args.get(3)))));
        BasicIntrinsicsProvider.add("__sulong_thread_join", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMThreadIntrinsicsFactory.LLVMThreadJoinNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("__sulong_thread_self", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMThreadIntrinsicsFactory.LLVMThreadSelfNodeGen.create());
        BasicIntrinsicsProvider.add("__sulong_thread_key_create", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMThreadKeyIntrinsicsFactory.LLVMThreadKeyCreateNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("__sulong_thread_key_delete", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMThreadKeyIntrinsicsFactory.LLVMThreadKeyDeleteNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("__sulong_thread_getspecific", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMThreadKeyIntrinsicsFactory.LLVMThreadGetSpecificNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("__sulong_thread_setspecific", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMThreadKeyIntrinsicsFactory.LLVMThreadSetSpecificNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("__sulong_thread_yield", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMThreadIntrinsicsFactory.LLVMThreadYieldNodeGen.create());
        BasicIntrinsicsProvider.add("__sulong_thread_sleep", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMThreadIntrinsicsFactory.LLVMThreadSleepNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
    }

    private static void registerSulongIntrinsics() {
        BasicIntrinsicsProvider.add("__sulong_destructor_functions", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMRunDestructorFunctionsNodeGen.create());
        BasicIntrinsicsProvider.add("__sulong_print_stacktrace", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPrintStackTraceNodeGen.create());
        BasicIntrinsicsProvider.add("__sulong_should_print_stacktrace_on_abort", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMShouldPrintStackTraceOnAbortNodeGen.create());
    }

    private static void registerToolchainIntrinsics() {
        BasicIntrinsicsProvider.add("toolchain_api_tool", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMToolchainNodeFactory.LLVMToolchainToolNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("toolchain_api_paths", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMToolchainNodeFactory.LLVMToolchainPathNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("toolchain_api_identifier", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMToolchainNodeFactory.LLVMToolchainIdentifierNodeGen.create());
    }

    private static void registerTruffleIntrinsics() {
        BasicIntrinsicsProvider.add("polyglot_import", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotImportNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_export", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotExportNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("polyglot_eval", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotEval.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("polyglot_eval_file", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotEval.createFile((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("polyglot_java_type", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotJavaTypeNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_is_value", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotIsValueNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_is_number", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBoxedPredicateNodeGen.create(InteropLibrary::isNumber, (LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_is_boolean", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBoxedPredicateNodeGen.create(InteropLibrary::isBoolean, (LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_is_string", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBoxedPredicateNodeGen.create(InteropLibrary::isString, (LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_is_date", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBoxedPredicateNodeGen.create(InteropLibrary::isDate, (LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_is_time", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBoxedPredicateNodeGen.create(InteropLibrary::isTime, (LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_is_timezone", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBoxedPredicateNodeGen.create(InteropLibrary::isTimeZone, (LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_is_instant", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBoxedPredicateNodeGen.create(InteropLibrary::isInstant, (LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_fits_in_i8", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBoxedPredicateNodeGen.create(InteropLibrary::fitsInByte, (LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_fits_in_i16", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBoxedPredicateNodeGen.create(InteropLibrary::fitsInShort, (LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_fits_in_i32", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBoxedPredicateNodeGen.create(InteropLibrary::fitsInInt, (LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_fits_in_i64", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBoxedPredicateNodeGen.create(InteropLibrary::fitsInLong, (LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_fits_in_float", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBoxedPredicateNodeGen.create(InteropLibrary::fitsInFloat, (LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_fits_in_double", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBoxedPredicateNodeGen.create(InteropLibrary::fitsInDouble, (LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_put_member", (List<LLVMExpressionNode> args, NodeFactory nodeFactory, LLVMLanguage language, Type[] types) -> LLVMPolyglotWrite.LLVMPolyglotPutMember.create(types, (LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2))), (LLVMExpressionNode)((Object)((Object)args.get(3)))));
        BasicIntrinsicsProvider.add("polyglot_set_array_element", (List<LLVMExpressionNode> args, NodeFactory nodeFactory, LLVMLanguage language, Type[] types) -> LLVMPolyglotWrite.LLVMPolyglotSetArrayElement.create(types, (LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2))), (LLVMExpressionNode)((Object)((Object)args.get(3)))));
        BasicIntrinsicsProvider.add("polyglot_get_member", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotReadFactory.LLVMPolyglotGetMemberNodeGen.create(CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.POINTER), (LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("polyglot_get_array_element", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotReadFactory.LLVMPolyglotGetArrayElementNodeGen.create(CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.POINTER), (LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("polyglot_remove_member", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotRemoveFactory.LLVMPolyglotRemoveMemberNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("polyglot_remove_array_element", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotRemoveFactory.LLVMPolyglotRemoveArrayElementNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("polyglot_as_i8", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotAsPrimitive.AsI8.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_as_i16", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotAsPrimitive.AsI16.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_as_i32", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotAsPrimitive.AsI32.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_as_i64", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotAsPrimitive.AsI64.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_as_float", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotAsPrimitive.AsFloat.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_as_double", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotAsPrimitive.AsDouble.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_as_boolean", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotAsPrimitive.AsBoolean.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_from_const_buffer", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotFromBufferNode.create(false, (LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("polyglot_from_buffer", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotFromBufferNode.create(true, (LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("polyglot_has_buffer_elements", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBufferInfo.HasBufferElements.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_get_buffer_size", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBufferInfo.GetBufferSize.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_is_buffer_writable", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBufferInfo.IsBufferWritable.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_instant_from_time", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotInstantFromTimeNode.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_timezone_from_id", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotTimeZoneFromIdNode.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_timezone_get_id", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotTimeZoneGetIdNode.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_from_boolean", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotFromPrimitive.FromBoolean.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_from_i8", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotFromPrimitive.FromI8.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_from_i16", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotFromPrimitive.FromI16.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_from_i32", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotFromPrimitive.FromI32.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_from_i64", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotFromPrimitive.FromI64.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_from_float", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotFromPrimitive.FromFloat.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_from_double", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotFromPrimitive.FromDouble.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_new_instance", (List<LLVMExpressionNode> args, NodeFactory nodeFactory, LLVMLanguage language, Type[] types) -> LLVMPolyglotNewInstanceNodeGen.create(BasicIntrinsicsProvider.argumentsArray(args, 2, args.size() - 2), Arrays.copyOfRange(types, 2, types.length), (LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_invoke", (List<LLVMExpressionNode> args, NodeFactory nodeFactory, LLVMLanguage language, Type[] types) -> LLVMPolyglotInvokeNodeGen.create(CommonNodeFactory.createForeignToLLVM(ForeignToLLVM.ForeignToLLVMType.POINTER), BasicIntrinsicsProvider.argumentsArray(args, 3, args.size() - 3), Arrays.copyOfRange(types, 3, types.length), (LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("truffle_decorate_function", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMTruffleDecorateFunctionNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("polyglot_can_execute", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBoxedPredicateNodeGen.create(InteropLibrary::isExecutable, (LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_can_instantiate", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBoxedPredicateNodeGen.create(InteropLibrary::isInstantiable, (LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_is_null", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBoxedPredicateNodeGen.create(InteropLibrary::isNull, (LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_has_array_elements", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBoxedPredicateNodeGen.create(InteropLibrary::hasArrayElements, (LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_has_members", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotBoxedPredicateNodeGen.create(InteropLibrary::hasMembers, (LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_has_member", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotHasMemberNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("polyglot_get_array_size", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotGetArraySizeNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_get_string_size", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotGetStringSizeNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_as_string", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotAsString.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2))), (LLVMExpressionNode)((Object)((Object)args.get(3))), (LLVMExpressionNode)((Object)((Object)args.get(4)))));
        BasicIntrinsicsProvider.add("polyglot_from_string", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotFromString.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("polyglot_from_string_n", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotFromString.createN((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2))), (LLVMExpressionNode)((Object)((Object)args.get(3)))));
        BasicIntrinsicsProvider.add("__polyglot_as_typeid", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMTypeIDNode.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("polyglot_as_typed", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotAsTyped.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("polyglot_from_typed", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPolyglotFromTyped.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("polyglot_array_typeid", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMArrayTypeIDNode.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
    }

    private static void registerManagedAllocationIntrinsics() {
        BasicIntrinsicsProvider.add("_graalvm_llvm_create_handle", "truffle_handle_for_managed", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> GraalVMCreateHandleNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("_graalvm_llvm_resolve_handle", "truffle_managed_from_handle", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> GraalVMResolveHandleNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("_graalvm_llvm_release_handle", "truffle_release_handle", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> GraalVMReleaseHandleNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("_graalvm_llvm_create_deref_handle", "truffle_deref_handle_for_managed", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> GraalVMCreateDerefHandleNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("_graalvm_llvm_is_handle", "truffle_is_handle_to_managed", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> GraalVMIsHandleNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("_graalvm_llvm_points_to_handle_space", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> GraalVMPointsToHandleSpaceNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("_graalvm_llvm_resolve_function", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> GraalVMResolveFunctionNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("_graalvm_llvm_va_arg", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> GraalVMVAArgNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("truffle_cannot_be_handle", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMTruffleCannotBeHandle.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("truffle_managed_malloc", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMTruffleManagedMallocNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("truffle_assign_managed", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMTruffleWriteManagedToSymbolNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("truffle_virtual_malloc", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMVirtualMallocNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
    }

    private static void registerAbortIntrinsics() {
        BasicIntrinsicsProvider.add("_gfortran_abort", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMAbortNodeGen.create());
        BasicIntrinsicsProvider.add("__sulong_signal", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMSignalNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("syscall", "__syscall", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMSyscall.create(BasicIntrinsicsProvider.argumentsArray(args, 1, args.size() - 1)));
    }

    private static void registerRustIntrinsics() {
        BasicIntrinsicsProvider.add("std::process::exit", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMExitNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("core::panicking::panic", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMPanicNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
    }

    private static void registerWindowsIntrinsics() {
        BasicIntrinsicsProvider.add("ExitProcess", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMExitNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("_Init_thread_lock", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMWindowsInitThreadIntrinsicsFactory.InitThreadLockNodeGen.create());
        BasicIntrinsicsProvider.add("_Init_thread_wait", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMWindowsInitThreadIntrinsicsFactory.InitThreadWaitNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("_Init_thread_unlock", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMWindowsInitThreadIntrinsicsFactory.InitThreadUnlockNodeGen.create());
        BasicIntrinsicsProvider.add("_Init_thread_notify", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMWindowsInitThreadIntrinsicsFactory.InitThreadNotifyNodeGen.create());
    }

    private static void registerMathFunctionIntrinsics() {
        BasicIntrinsicsProvider.addFloatingPointMathFunction("sqrt", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMSqrtNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("log", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMLogNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("log2", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMLog2NodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("log10", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMLog10NodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("log1p", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMLog1pNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("rint", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMRintNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("ceil", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMCeilNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("floor", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMFloorNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("fabs", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMFAbsNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("minnum", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMMinnumNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("maxnum", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMMaxnumNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("pow", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMPowNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("exp", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMExpNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("exp2", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMExp2NodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("expm1", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMExpm1NodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("sin", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMSinNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("cos", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMCosNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("tan", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMTanNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("atan2", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMATan2NodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("asin", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMASinNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("acos", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMACosNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("atan", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMATanNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("sinh", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMSinhNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("cosh", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMCoshNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("tanh", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMTanhNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("ldexp", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMLdexpNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("modf", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMModfNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("fmod", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMFmodNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.addFloatingPointMathFunction("copysign", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMCopySignNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.addIntegerMathFunction("abs", (args, nodeFactory) -> LLVMCMathsIntrinsicsFactory.LLVMAbsNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
    }

    private static void registerCTypeIntrinsics() {
        BasicIntrinsicsProvider.add("isalpha", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMCTypeIntrinsicsFactory.LLVMIsalphaNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("tolower", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMCTypeIntrinsicsFactory.LLVMTolowerNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("toupper", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMCTypeIntrinsicsFactory.LLVMToUpperNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("isspace", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMCTypeIntrinsicsFactory.LLVMIsspaceNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("isupper", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMCTypeIntrinsicsFactory.LLVMIsupperNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
    }

    private static void registerDynamicLibraryIntrinsics() {
        BasicIntrinsicsProvider.add("dlopen", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMDLOpenNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("dlsym", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMDLSymNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("dlclose", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMDLCloseNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
    }

    private static void registerMemoryFunctionIntrinsics() {
        BasicIntrinsicsProvider.add("malloc", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMMemoryIntrinsicFactory.LLVMMallocNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("calloc", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMMemoryIntrinsicFactory.LLVMCallocNodeGen.create(nodeFactory.createMemSet(), (LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("realloc", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMMemoryIntrinsicFactory.LLVMReallocNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("posix_memalign", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMMemoryIntrinsic.LLVMPosixMemalign.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2))), (LLVMExpressionNode)((Object)((Object)args.get(3)))));
        BasicIntrinsicsProvider.add("aligned_alloc", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMMemoryIntrinsicFactory.LLVMAlignedAllocNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("free", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMMemoryIntrinsicFactory.LLVMFreeNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("memset", "__memset_chk", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMMemIntrinsicFactory.LLVMLibcMemsetNodeGen.create(nodeFactory.createMemSet(), (LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2))), (LLVMExpressionNode)((Object)((Object)args.get(3)))));
        LLVMIntrinsicFactory memmoveFactory = (args, nodeFactory) -> LLVMMemIntrinsicFactory.LLVMLibcMemMoveNodeGen.create(nodeFactory.createMemMove(), (LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2))), (LLVMExpressionNode)((Object)((Object)args.get(3))));
        BasicIntrinsicsProvider.add("memcpy", "__memcpy_chk", memmoveFactory);
        BasicIntrinsicsProvider.add("memmove", "__memmove_chk", memmoveFactory);
    }

    private static void registerExceptionIntrinsics() {
        BasicIntrinsicsProvider.add("_CxxThrowException", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMRaiseExceptionWindowsNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2)))));
        BasicIntrinsicsProvider.add("_Unwind_RaiseException", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMRaiseExceptionNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1)))));
        BasicIntrinsicsProvider.add("__cxa_call_unexpected", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMAbortNodeGen.create());
    }

    private static void registerComplexNumberIntrinsics() {
        BasicIntrinsicsProvider.add("__divsc3", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMComplexFloatDivNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2))), (LLVMExpressionNode)((Object)((Object)args.get(3))), (LLVMExpressionNode)((Object)((Object)args.get(4)))));
        BasicIntrinsicsProvider.add("__mulsc3", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMComplexFloatMulNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2))), (LLVMExpressionNode)((Object)((Object)args.get(3))), (LLVMExpressionNode)((Object)((Object)args.get(4)))));
        BasicIntrinsicsProvider.add("__divdc3", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMComplexDoubleDivNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2))), (LLVMExpressionNode)((Object)((Object)args.get(3))), (LLVMExpressionNode)((Object)((Object)args.get(4))), (LLVMExpressionNode)((Object)((Object)args.get(5)))));
        BasicIntrinsicsProvider.add("__muldc3", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMComplexDoubleMulNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2))), (LLVMExpressionNode)((Object)((Object)args.get(3))), (LLVMExpressionNode)((Object)((Object)args.get(4))), (LLVMExpressionNode)((Object)((Object)args.get(5)))));
        BasicIntrinsicsProvider.add("__divxc3", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMComplex80BitFloatDivNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2))), (LLVMExpressionNode)((Object)((Object)args.get(3))), (LLVMExpressionNode)((Object)((Object)args.get(4))), (LLVMExpressionNode)((Object)((Object)args.get(5)))));
        BasicIntrinsicsProvider.add("__mulxc3", (List<LLVMExpressionNode> args, NodeFactory nodeFactory) -> LLVMComplex80BitFloatMulNodeGen.create((LLVMExpressionNode)((Object)((Object)args.get(1))), (LLVMExpressionNode)((Object)((Object)args.get(2))), (LLVMExpressionNode)((Object)((Object)args.get(3))), (LLVMExpressionNode)((Object)((Object)args.get(4))), (LLVMExpressionNode)((Object)((Object)args.get(5)))));
    }

    protected static void add(String name, LLVMTypedIntrinsicFactory factory, Map<String, LLVMTypedIntrinsicFactory> factories) {
        LLVMTypedIntrinsicFactory existing = factories.put(name, factory);
        assert (existing == null) : "same intrinsic was added more than once";
    }

    private static void add(String name, LLVMTypedIntrinsicFactory factory) {
        BasicIntrinsicsProvider.add(name, factory, FACTORIES);
    }

    private static void add(String name, LLVMIntrinsicFactory factory) {
        BasicIntrinsicsProvider.add(name, factory, FACTORIES);
    }

    private static void add(String name1, String name2, LLVMIntrinsicFactory factory) {
        BasicIntrinsicsProvider.add(name1, factory, FACTORIES);
        BasicIntrinsicsProvider.add(name2, factory, FACTORIES);
    }

    private static void addFloatingPointMathFunction(String functionName, LLVMIntrinsicFactory factory) {
        BasicIntrinsicsProvider.add(functionName, factory, FACTORIES);
        BasicIntrinsicsProvider.add(functionName + "f", factory, FACTORIES);
    }

    private static void addIntegerMathFunction(String functionName, LLVMIntrinsicFactory factory) {
        BasicIntrinsicsProvider.add(functionName, factory, FACTORIES);
        BasicIntrinsicsProvider.add("l" + functionName, factory, FACTORIES);
    }

    static {
        BasicIntrinsicsProvider.registerTruffleIntrinsics();
        BasicIntrinsicsProvider.registerToolchainIntrinsics();
        BasicIntrinsicsProvider.registerSulongIntrinsics();
        BasicIntrinsicsProvider.registerAbortIntrinsics();
        BasicIntrinsicsProvider.registerRustIntrinsics();
        BasicIntrinsicsProvider.registerMathFunctionIntrinsics();
        BasicIntrinsicsProvider.registerMemoryFunctionIntrinsics();
        BasicIntrinsicsProvider.registerExceptionIntrinsics();
        BasicIntrinsicsProvider.registerComplexNumberIntrinsics();
        BasicIntrinsicsProvider.registerCTypeIntrinsics();
        BasicIntrinsicsProvider.registerManagedAllocationIntrinsics();
        BasicIntrinsicsProvider.registerThreadIntrinsics();
        BasicIntrinsicsProvider.registerDynamicLibraryIntrinsics();
        BasicIntrinsicsProvider.registerWindowsIntrinsics();
    }

    public static interface LLVMTypedIntrinsicFactory {
        public LLVMExpressionNode generate(List<LLVMExpressionNode> var1, NodeFactory var2, LLVMLanguage var3, Type[] var4);
    }

    protected static class Demangler {
        protected final List<UnaryOperator<String>> demanglerFunctions = Arrays.asList(new RustDemangleFunction());

        protected Demangler() {
        }

        protected String demangle(String name) {
            CompilerAsserts.neverPartOfCompilation();
            for (UnaryOperator<String> func : this.demanglerFunctions) {
                String demangledName = (String)func.apply(name);
                if (demangledName == null) continue;
                return demangledName;
            }
            return null;
        }

        protected static class RustDemangleFunction
        implements UnaryOperator<String> {
            protected RustDemangleFunction() {
            }

            @Override
            public String apply(String name) {
                int elemLen;
                if (!name.endsWith("E")) {
                    return null;
                }
                NameScanner scanner = new NameScanner(name);
                if (!scanner.skip("_ZN") && !scanner.skip("ZN")) {
                    return null;
                }
                StringBuilder builder = new StringBuilder();
                while ((elemLen = scanner.scanUnsignedInt()) != -1) {
                    String elem = scanner.scan(elemLen);
                    if (elem == null) {
                        return null;
                    }
                    if (elem.matches("h[0-9a-fA-F]+")) break;
                    builder.append(elem);
                    builder.append("::");
                }
                if (builder.length() < 2 || !scanner.skip("E")) {
                    return null;
                }
                builder.delete(builder.length() - 2, builder.length());
                return builder.toString();
            }
        }

        protected static class NameScanner {
            protected final String name;
            protected int index;

            protected NameScanner(String name) {
                this.name = name;
                this.index = 0;
            }

            protected boolean skip(String str) {
                int endi = this.index + str.length();
                if (endi <= this.name.length() && str.equals(this.name.substring(this.index, endi))) {
                    this.index = endi;
                    return true;
                }
                return false;
            }

            protected String scan(int nchars) {
                if (this.index + nchars > this.name.length()) {
                    return null;
                }
                String result = this.name.substring(this.index, this.index + nchars);
                this.index += nchars;
                return result;
            }

            protected int scanUnsignedInt() {
                int endi;
                for (endi = this.index; endi < this.name.length() && Character.isDigit(this.name.charAt(endi)); ++endi) {
                }
                try {
                    int result = Integer.parseInt(this.name.substring(this.index, endi));
                    this.index = endi;
                    return result;
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
        }
    }

    public static interface LLVMIntrinsicFactory
    extends LLVMTypedIntrinsicFactory {
        public LLVMExpressionNode generate(List<LLVMExpressionNode> var1, NodeFactory var2);

        @Override
        default public LLVMExpressionNode generate(List<LLVMExpressionNode> args, NodeFactory nodeFactory, LLVMLanguage language, Type[] argTypes) {
            return this.generate(args, nodeFactory);
        }
    }

    public static abstract class LLVMIntrinsicArgFactory {
        public abstract int size();

        public abstract LLVMExpressionNode get(int var1);
    }
}

