/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64LockedInstructionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMAMD64LockedInstructionNode.class)
public final class LLVMAMD64LockedInstructionNodeGen
extends LLVMAMD64LockedInstructionNode
implements GenerateAOT.Provider {
    @Node.Child
    private LLVMExpressionNode address_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private LLVMAMD64LockedInstructionNodeGen(LLVMStatementNode statement, LLVMExpressionNode address) {
        super(statement);
        this.address_ = address;
    }

    @Override
    public void execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            this.executeAndSpecialize(frameValue, addressValue_);
            return;
        }
        if ((state_0 & 6) != 0) {
            if ((state_0 & 2) != 0 && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                this.doNative(frameValue, addressValue__);
                return;
            }
            if ((state_0 & 4) != 0 && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                this.doManaged(frameValue, addressValue__);
                return;
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        this.executeAndSpecialize(frameValue, addressValue_);
    }

    private void executeAndSpecialize(VirtualFrame frameValue, Object addressValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isNativePointer(addressValue)) {
            LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
            this.state_0_ = state_0 |= 2;
            this.doNative(frameValue, addressValue_);
            return;
        }
        if (LLVMTypes.isManagedPointer(addressValue)) {
            LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
            this.state_0_ = state_0 |= 4;
            this.doManaged(frameValue, addressValue_);
            return;
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.address_}, new Object[]{addressValue});
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ |= 2;
        this.state_0_ |= 4;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMAMD64LockedInstructionNode create(LLVMStatementNode statement, LLVMExpressionNode address) {
        return new LLVMAMD64LockedInstructionNodeGen(statement, address);
    }
}

