/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64StoreFlags;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteBooleanNode;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMAMD64StoreFlags.class)
public final class LLVMAMD64StoreFlagsFactory {

    @GeneratedBy(value=LLVMAMD64StoreFlags.LLVMAMD64WriteFlagswNode.class)
    public static final class LLVMAMD64WriteFlagswNodeGen
    extends LLVMAMD64StoreFlags.LLVMAMD64WriteFlagswNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode flags_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMAMD64WriteFlagswNodeGen(LLVMAMD64WriteBooleanNode cf, LLVMAMD64WriteBooleanNode pf, LLVMAMD64WriteBooleanNode af, LLVMAMD64WriteBooleanNode zf, LLVMAMD64WriteBooleanNode sf, LLVMAMD64WriteBooleanNode of, LLVMExpressionNode flags) {
            super(cf, pf, af, zf, sf, of);
            this.flags_ = flags;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            short flagsValue_;
            int state_0 = this.state_0_;
            try {
                flagsValue_ = this.flags_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, flagsValue_);
                return;
            }
            if ((state_0 & 2) != 0) {
                this.doObject(frameValue, flagsValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, flagsValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object flagsValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (flagsValue instanceof Short) {
                short flagsValue_ = (Short)flagsValue;
                this.state_0_ = state_0 |= 2;
                this.doObject(frameValue, flagsValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.flags_}, new Object[]{flagsValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64StoreFlags.LLVMAMD64WriteFlagswNode create(LLVMAMD64WriteBooleanNode cf, LLVMAMD64WriteBooleanNode pf, LLVMAMD64WriteBooleanNode af, LLVMAMD64WriteBooleanNode zf, LLVMAMD64WriteBooleanNode sf, LLVMAMD64WriteBooleanNode of, LLVMExpressionNode flags) {
            return new LLVMAMD64WriteFlagswNodeGen(cf, pf, af, zf, sf, of, flags);
        }
    }

    @GeneratedBy(value=LLVMAMD64StoreFlags.LLVMAMD64SahfNode.class)
    public static final class LLVMAMD64SahfNodeGen
    extends LLVMAMD64StoreFlags.LLVMAMD64SahfNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode flags_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMAMD64SahfNodeGen(LLVMAMD64WriteBooleanNode cf, LLVMAMD64WriteBooleanNode pf, LLVMAMD64WriteBooleanNode af, LLVMAMD64WriteBooleanNode zf, LLVMAMD64WriteBooleanNode sf, LLVMExpressionNode flags) {
            super(cf, pf, af, zf, sf);
            this.flags_ = flags;
        }

        @Override
        public void execute(VirtualFrame frameValue) {
            byte flagsValue_;
            int state_0 = this.state_0_;
            try {
                flagsValue_ = this.flags_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.executeAndSpecialize(frameValue, ex.getResult());
                return;
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, flagsValue_);
                return;
            }
            if ((state_0 & 2) != 0) {
                this.doObject(frameValue, flagsValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, flagsValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object flagsValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (flagsValue instanceof Byte) {
                byte flagsValue_ = (Byte)flagsValue;
                this.state_0_ = state_0 |= 2;
                this.doObject(frameValue, flagsValue_);
                return;
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.flags_}, new Object[]{flagsValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMAMD64StoreFlags.LLVMAMD64SahfNode create(LLVMAMD64WriteBooleanNode cf, LLVMAMD64WriteBooleanNode pf, LLVMAMD64WriteBooleanNode af, LLVMAMD64WriteBooleanNode zf, LLVMAMD64WriteBooleanNode sf, LLVMExpressionNode flags) {
            return new LLVMAMD64SahfNodeGen(cf, pf, af, zf, sf, flags);
        }
    }
}

