/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.api;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.except.LLVMException;
import com.oracle.truffle.llvm.runtime.memory.LLVMAllocateNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLazyExceptionFactory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;

public abstract class LLVMLazyException {
    public static <E extends Throwable> LLVMAllocateNode createAllocateNode(LLVMExceptionFactory<E> factory, E cause) {
        return LLVMLazyExceptionFactory.LazyExceptionExpressionNodeGen.create(new ExceptionThrower<E>(factory, cause));
    }

    public static <E extends Throwable> LLVMExpressionNode createExpressionNode(LLVMExceptionFactory<E> factory, E cause) {
        return LLVMLazyExceptionFactory.LazyExceptionExpressionNodeGen.create(new ExceptionThrower<E>(factory, cause));
    }

    public static <E extends Throwable> LLVMStatementNode createStatementNode(LLVMExceptionFactory<E> factory, E cause) {
        return LLVMLazyExceptionFactory.LazyExceptionStatementNodeGen.create(new ExceptionThrower<E>(factory, cause));
    }

    static class ExceptionThrower<E extends Throwable> {
        private final LLVMExceptionFactory<E> factory;
        private final E cause;

        ExceptionThrower(LLVMExceptionFactory<E> factory, E cause) {
            this.factory = factory;
            this.cause = cause;
        }

        LLVMException doThrow(Node node) {
            throw this.factory.create(node, this.cause);
        }
    }

    @FunctionalInterface
    public static interface LLVMExceptionFactory<E extends Throwable> {
        public LLVMException create(Node var1, E var2);
    }

    static abstract class LazyExceptionExpressionNode
    extends LLVMExpressionNode
    implements LLVMAllocateNode {
        private final ExceptionThrower<?> thrower;

        LazyExceptionExpressionNode(ExceptionThrower<?> thrower) {
            this.thrower = thrower;
        }

        @Specialization
        Object doThrow() {
            return LLVMManagedPointer.create(new Undef(this.thrower));
        }
    }

    static abstract class LazyExceptionStatementNode
    extends LLVMStatementNode {
        private final ExceptionThrower<?> thrower;

        LazyExceptionStatementNode(ExceptionThrower<?> thrower) {
            this.thrower = thrower;
        }

        @Specialization
        void doThrow() {
            throw this.thrower.doThrow(this);
        }
    }

    @ExportLibrary(value=ReflectionLibrary.class)
    static final class Undef
    implements TruffleObject {
        private final ExceptionThrower<?> thrower;

        Undef(ExceptionThrower<?> thrower) {
            this.thrower = thrower;
        }

        @ExportMessage
        Object send(Message message, Object[] args, @CachedLibrary(value="this") ReflectionLibrary selfNode) throws Exception {
            throw this.thrower.doThrow((Node)selfNode);
        }
    }
}

