/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibraryDefaults;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.lang.invoke.MethodHandles;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMNativeLibrary.class)
final class LLVMNativeLibraryGen
extends LibraryFactory<LLVMNativeLibrary> {
    private static final Class<LLVMNativeLibrary> LIBRARY_CLASS = LLVMNativeLibraryGen.lazyLibraryClass();
    private static final Message IS_POINTER = new MessageImpl("isPointer", 0, false, Boolean.TYPE, Object.class);
    private static final Message AS_POINTER = new MessageImpl("asPointer", 1, false, Long.TYPE, Object.class);
    private static final Message TO_NATIVE_POINTER = new MessageImpl("toNativePointer", 2, false, LLVMNativePointer.class, Object.class);
    private static final LLVMNativeLibraryGen INSTANCE = new LLVMNativeLibraryGen();

    private LLVMNativeLibraryGen() {
        super(LIBRARY_CLASS, List.of(IS_POINTER, AS_POINTER, TO_NATIVE_POINTER));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        if (receiver instanceof Long) {
            return LLVMNativeLibraryDefaults.LongLibrary.class;
        }
        if (receiver instanceof byte[]) {
            return LLVMNativeLibraryDefaults.ArrayLibrary.class;
        }
        return LLVMNativeLibraryDefaults.DefaultLibrary.class;
    }

    protected MethodHandles.Lookup getLookup() {
        return MethodHandles.lookup();
    }

    protected LLVMNativeLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected LLVMNativeLibrary createDelegate(LLVMNativeLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        LLVMNativeLibrary lib = (LLVMNativeLibrary)originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0: {
                return lib.isPointer(receiver);
            }
            case 1: {
                return lib.asPointer(receiver);
            }
            case 2: {
                return lib.toNativePointer(receiver);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected LLVMNativeLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected LLVMNativeLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<LLVMNativeLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary", false, LLVMNativeLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=LLVMNativeLibrary.class)
    private static final class Proxy
    extends LLVMNativeLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isPointer(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_POINTER, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            try {
                return (Long)this.lib.send(receiver_, AS_POINTER, new Object[0]);
            }
            catch (UnsupportedMessageException | RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public LLVMNativePointer toNativePointer(Object receiver_) {
            try {
                return (LLVMNativePointer)this.lib.send(receiver_, TO_NATIVE_POINTER, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=LLVMNativeLibrary.class)
    private static final class Delegate
    extends LLVMNativeLibrary {
        @Node.Child
        private LLVMNativeLibrary delegateLibrary;

        Delegate(LLVMNativeLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isPointer(Object receiver_) {
            if (LLVMNativeLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = LLVMNativeLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((LLVMNativeLibrary)LLVMNativeLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).isPointer(delegate);
            }
            return this.delegateLibrary.isPointer(receiver_);
        }

        @Override
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            if (LLVMNativeLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = LLVMNativeLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((LLVMNativeLibrary)LLVMNativeLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).asPointer(delegate);
            }
            return this.delegateLibrary.asPointer(receiver_);
        }

        @Override
        public LLVMNativePointer toNativePointer(Object receiver_) {
            if (LLVMNativeLibraryGen.isDelegated((Library)this.delegateLibrary, (int)2)) {
                Object delegate = LLVMNativeLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((LLVMNativeLibrary)LLVMNativeLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).toNativePointer(delegate);
            }
            return this.delegateLibrary.toNativePointer(receiver_);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=LLVMNativeLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch
    implements GenerateAOT.Provider {
        private final int limit_;
        private volatile boolean aot_;

        CachedDispatchFirst(LLVMNativeLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        void setAOT(boolean value) {
            this.aot_ = value;
        }

        @Override
        boolean isAOT() {
            return this.aot_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if (this.aot_) {
                return;
            }
            for (LibraryExport export : INSTANCE.getAOTExports()) {
                LLVMNativeLibrary exportLibrary = (LLVMNativeLibrary)INSTANCE.createAOT(export);
                if (this.library == null) {
                    this.library = (LLVMNativeLibrary)this.insert((Node)exportLibrary);
                    continue;
                }
                this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext(exportLibrary, this.next));
            }
            this.aot_ = true;
        }
    }

    @GeneratedBy(value=LLVMNativeLibrary.class)
    private static abstract class CachedDispatch
    extends LLVMNativeLibrary {
        @Node.Child
        LLVMNativeLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(LLVMNativeLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        abstract boolean isAOT();

        abstract void setAOT(boolean var1);

        @Override
        @ExplodeLoop
        public boolean isPointer(Object receiver_) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMNativeLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isPointer(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMNativeLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.asPointer(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public LLVMNativePointer toNativePointer(Object receiver_) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMNativeLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.toNativePointer(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                if (this.isAOT()) {
                    this.library = null;
                    this.next = null;
                    this.setAOT(false);
                }
                CachedDispatch current = this;
                LLVMNativeLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = (LLVMNativeLibrary)this.insert((Node)((LLVMNativeLibrary)INSTANCE.create(receiver_)));
                } else {
                    int count = 0;
                    do {
                        LLVMNativeLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (LLVMNativeLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((LLVMNativeLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=LLVMNativeLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch
    extends LLVMNativeLibrary
    implements UnadoptableNode {
        private UncachedDispatch() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isPointer(Object receiver_) {
            return ((LLVMNativeLibrary)INSTANCE.getUncached(receiver_)).isPointer(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            return ((LLVMNativeLibrary)INSTANCE.getUncached(receiver_)).asPointer(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public LLVMNativePointer toNativePointer(Object receiver_) {
            return ((LLVMNativeLibrary)INSTANCE.getUncached(receiver_)).toNativePointer(receiver_);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=LLVMNativeLibrary.class)
    private static class MessageImpl
    extends Message {
        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, index, deprecated, returnType, (Class[])parameters);
        }
    }

    @GeneratedBy(value=LLVMNativeLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(LLVMNativeLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        void setAOT(boolean value) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        boolean isAOT() {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GeneratedBy(value=LLVMNativeLibrary.class)
    private static final class CachedToUncachedDispatch
    extends LLVMNativeLibrary {
        private CachedToUncachedDispatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isPointer(Object receiver_) {
            assert (LLVMNativeLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((LLVMNativeLibrary)INSTANCE.getUncached(receiver_)).isPointer(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public long asPointer(Object receiver_) throws UnsupportedMessageException {
            assert (LLVMNativeLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                long l = ((LLVMNativeLibrary)INSTANCE.getUncached(receiver_)).asPointer(receiver_);
                return l;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public LLVMNativePointer toNativePointer(Object receiver_) {
            assert (LLVMNativeLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                LLVMNativePointer lLVMNativePointer = ((LLVMNativeLibrary)INSTANCE.getUncached(receiver_)).toNativePointer(receiver_);
                return lLVMNativePointer;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }
}

