/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.type;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceType;
import java.util.function.Function;
import java.util.function.Supplier;

public class LLVMSourceDecoratorType
extends LLVMSourceType {
    private final Function<String, String> nameDecorator;
    @CompilerDirectives.CompilationFinal
    private LLVMSourceType baseType;
    @CompilerDirectives.CompilationFinal
    private long size;

    public LLVMSourceDecoratorType(long size, long align, long offset, Function<String, String> nameDecorator, LLVMSourceLocation location) {
        super(size, align, offset, location);
        this.nameDecorator = nameDecorator;
        this.baseType = LLVMSourceType.UNKNOWN;
        this.size = size;
    }

    protected LLVMSourceDecoratorType(Supplier<String> nameSupplier, long size, long align, long offset, LLVMSourceType baseType, Function<String, String> nameDecorator, LLVMSourceLocation location) {
        super(nameSupplier, size, align, offset, location);
        this.baseType = baseType;
        this.nameDecorator = nameDecorator;
        this.size = size;
    }

    public void setBaseType(LLVMSourceType baseType) {
        CompilerAsserts.neverPartOfCompilation();
        this.baseType = baseType;
    }

    public LLVMSourceType getBaseType() {
        return this.baseType;
    }

    @Override
    public LLVMSourceType getActualType() {
        return this.baseType.getActualType();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String getName() {
        return this.nameDecorator.apply(this.baseType.getName());
    }

    @Override
    public void setName(Supplier<String> nameSupplier) {
        CompilerAsserts.neverPartOfCompilation();
        this.baseType.setName(nameSupplier);
    }

    public void setSize(long size) {
        CompilerAsserts.neverPartOfCompilation();
        this.size = size;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getAlign() {
        return this.baseType.getAlign();
    }

    @Override
    public long getOffset() {
        return this.baseType.getOffset();
    }

    @Override
    public boolean isPointer() {
        return this.baseType.isPointer();
    }

    @Override
    public boolean isReference() {
        return this.baseType.isReference();
    }

    @Override
    public boolean isAggregate() {
        return this.baseType.isAggregate();
    }

    @Override
    public boolean isEnum() {
        return this.baseType.isEnum();
    }

    @Override
    public int getElementCount() {
        return this.baseType.getElementCount();
    }

    @Override
    public String getElementName(long i) {
        return this.baseType.getElementName(i);
    }

    @Override
    public LLVMSourceType getElementType(long i) {
        return this.baseType.getElementType(i);
    }

    @Override
    public LLVMSourceType getElementType(String name) {
        return this.baseType.getElementType(name);
    }

    @Override
    public LLVMSourceLocation getElementDeclaration(long i) {
        return this.baseType.getElementDeclaration(i);
    }

    @Override
    public LLVMSourceLocation getElementDeclaration(String name) {
        return this.baseType.getElementDeclaration(name);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public LLVMSourceType getOffset(long newOffset) {
        LLVMSourceType offsetBaseType = this.baseType.getOffset(newOffset);
        return new LLVMSourceDecoratorType(this::getName, this.getSize(), this.getAlign(), this.getOffset(), offsetBaseType, this.nameDecorator, this.getLocation());
    }
}

