/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.constants.aggregate;

import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.model.symbols.constants.Constant;
import com.oracle.truffle.llvm.parser.model.symbols.constants.aggregate.AggregateConstant;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class StructureConstant
extends AggregateConstant {
    StructureConstant(StructureType type, int valueCount) {
        super(type, valueCount);
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public Type getElementType(int index) {
        return this.getElement(index).getType();
    }

    public boolean isPacked() {
        return ((StructureType)this.getType()).isPacked();
    }

    @Override
    public String toString() {
        return String.format("{%s}", super.toString());
    }

    @Override
    public LLVMExpressionNode createNode(LLVMParserRuntime runtime, DataLayout dataLayout, GetStackSpaceFactory stackFactory) {
        int elementCount = this.getElementCount();
        Type[] types = new Type[elementCount];
        LLVMExpressionNode[] constants = new LLVMExpressionNode[elementCount];
        for (int i = 0; i < elementCount; ++i) {
            types[i] = this.getElementType(i);
            constants[i] = this.getElement(i).createNode(runtime, dataLayout, stackFactory);
        }
        return runtime.getNodeFactory().createStructureConstantNode(this.getType(), stackFactory, this.isPacked(), types, constants);
    }

    @Override
    public void addToBuffer(Constant.Buffer buffer, LLVMParserRuntime runtime, DataLayout dataLayout, GetStackSpaceFactory stackFactory) throws Type.TypeOverflowException {
        long startOffset = buffer.getBuffer().position();
        long offset = 0L;
        boolean packed = this.isPacked();
        for (int i = 0; i < this.getElementCount(); ++i) {
            Type resolvedType = this.getElementType(i);
            if (!packed) {
                int padding = Type.getPadding(offset, resolvedType, dataLayout);
                for (int j = 0; j < padding; ++j) {
                    buffer.getBuffer().put((byte)0);
                }
                offset = Type.addUnsignedExact(offset, padding);
            }
            this.getElement(i).addToBuffer(buffer, runtime, dataLayout, stackFactory);
            offset = Type.addUnsignedExact(offset, resolvedType.getSize(dataLayout));
        }
        buffer.getBuffer().position((int)(startOffset + this.getType().getSize(dataLayout)));
    }
}

