/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.listeners;

import com.oracle.truffle.llvm.parser.listeners.ParserListener;
import com.oracle.truffle.llvm.parser.listeners.Types;
import com.oracle.truffle.llvm.parser.model.attributes.Attribute;
import com.oracle.truffle.llvm.parser.model.attributes.AttributesCodeEntry;
import com.oracle.truffle.llvm.parser.model.attributes.AttributesGroup;
import com.oracle.truffle.llvm.parser.scanner.RecordBuffer;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.ArrayList;
import java.util.List;

public class ParameterAttributes
implements ParserListener {
    private static final int PARAMATTR_CODE_ENTRY_OLD = 1;
    private static final int PARAMATTR_CODE_ENTRY = 2;
    private static final int PARAMATTR_GRP_CODE_ENTRY = 3;
    private static final int WELL_KNOWN_ATTRIBUTE_KIND = 0;
    private static final int WELL_KNOWN_INTEGER_ATTRIBUTE_KIND = 1;
    private static final int STRING_ATTRIBUTE_KIND = 3;
    private static final int STRING_VALUE_ATTRIBUTE_KIND = 4;
    private static final int BYVAL_ATTRIBUTE_KIND = 5;
    private static final int TYPED_BYVAL_ATTRIBUTE_KIND = 6;
    private final List<AttributesGroup> attributes = new ArrayList<AttributesGroup>();
    private final List<AttributesCodeEntry> parameterCodeEntry = new ArrayList<AttributesCodeEntry>();
    private final Types types;

    public ParameterAttributes(Types types) {
        this.types = types;
    }

    public AttributesCodeEntry getCodeEntry(long idx) {
        if (idx <= 0L || (long)this.parameterCodeEntry.size() < idx) {
            return AttributesCodeEntry.EMPTY;
        }
        return this.parameterCodeEntry.get((int)(idx - 1L));
    }

    @Override
    public void record(RecordBuffer buffer) {
        int id = buffer.getId();
        switch (id) {
            case 1: {
                this.decodeOldCodeEntry(buffer);
                break;
            }
            case 2: {
                this.decodeCodeEntry(buffer);
                break;
            }
            case 3: {
                this.decodeGroupCodeEntry(buffer);
                break;
            }
        }
    }

    private void decodeOldCodeEntry(RecordBuffer buffer) {
        ArrayList<AttributesGroup> attrGroup = new ArrayList<AttributesGroup>();
        for (int i = 0; i < buffer.size(); i += 2) {
            attrGroup.add(ParameterAttributes.decodeOldGroupCodeEntry(buffer.read(), buffer.read()));
        }
        this.parameterCodeEntry.add(new AttributesCodeEntry(attrGroup));
    }

    private static AttributesGroup decodeOldGroupCodeEntry(long paramIdx, long attr) {
        AttributesGroup group = new AttributesGroup(-1L, paramIdx);
        if ((attr & 1L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.ZEROEXT));
        }
        if ((attr & 2L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.SIGNEXT));
        }
        if ((attr & 4L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.NORETURN));
        }
        if ((attr & 8L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.INREG));
        }
        if ((attr & 0x10L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.SRET));
        }
        if ((attr & 0x20L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.NOUNWIND));
        }
        if ((attr & 0x40L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.NOALIAS));
        }
        if ((attr & 0x80L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.BYVAL));
        }
        if ((attr & 0x100L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.NEST));
        }
        if ((attr & 0x200L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.READNONE));
        }
        if ((attr & 0x400L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.READONLY));
        }
        if ((attr & 0x800L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.NOINLINE));
        }
        if ((attr & 0x1000L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.ALWAYSINLINE));
        }
        if ((attr & 0x2000L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.OPTSIZE));
        }
        if ((attr & 0x4000L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.SSP));
        }
        if ((attr & 0x8000L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.SSPREQ));
        }
        if ((attr & 0xFF0000L) != 0L) {
            int align = (int)(attr >> 16 & 0xFFL);
            group.addAttribute(new Attribute.KnownIntegerValueAttribute(Attribute.Kind.ALIGN, align));
        }
        if ((attr & 0x100000000L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.NOCAPTURE));
        }
        if ((attr & 0x200000000L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.NOREDZONE));
        }
        if ((attr & 0x400000000L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.NOIMPLICITFLOAT));
        }
        if ((attr & 0x800000000L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.NAKED));
        }
        if ((attr & 0x1000000000L) != 0L) {
            group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.INLINEHINT));
        }
        if ((attr & 0xE000000000L) != 0L) {
            int alignstack = 1 << (int)(attr >> 37 & 7L) - 1;
            group.addAttribute(new Attribute.KnownIntegerValueAttribute(Attribute.Kind.ALIGNSTACK, alignstack));
        }
        return group;
    }

    private void decodeCodeEntry(RecordBuffer buffer) {
        ArrayList<AttributesGroup> attrGroup = new ArrayList<AttributesGroup>();
        block0: while (buffer.remaining() > 0) {
            long groupId = buffer.read();
            for (AttributesGroup attr : this.attributes) {
                if (attr.getGroupId() != groupId) continue;
                attrGroup.add(attr);
                continue block0;
            }
        }
        if (attrGroup.size() != buffer.size()) {
            throw new LLVMParserException("Mismatching number of defined and found attributes in AttributesGroup");
        }
        this.parameterCodeEntry.add(new AttributesCodeEntry(attrGroup));
    }

    private void decodeGroupCodeEntry(RecordBuffer buffer) {
        long groupId = buffer.read();
        long paramIdx = buffer.read();
        AttributesGroup group = new AttributesGroup(groupId, paramIdx);
        this.attributes.add(group);
        block8: while (buffer.remaining() > 0) {
            int type = buffer.readInt();
            switch (type) {
                case 0: {
                    Attribute.Kind attr = Attribute.Kind.decode(buffer.read());
                    group.addAttribute(new Attribute.KnownAttribute(attr));
                    continue block8;
                }
                case 1: {
                    Attribute.Kind attr = Attribute.Kind.decode(buffer.read());
                    group.addAttribute(new Attribute.KnownIntegerValueAttribute(attr, buffer.read()));
                    continue block8;
                }
                case 3: {
                    String strAttr = ParameterAttributes.readString(buffer);
                    group.addAttribute(new Attribute.StringAttribute(strAttr));
                    continue block8;
                }
                case 4: {
                    String strAttr = ParameterAttributes.readString(buffer);
                    String strVal = ParameterAttributes.readString(buffer);
                    group.addAttribute(new Attribute.StringValueAttribute(strAttr, strVal));
                    continue block8;
                }
                case 5: {
                    Attribute.Kind attr = Attribute.Kind.decode(buffer.read());
                    if (attr != Attribute.Kind.BYVAL) continue block8;
                    group.addAttribute(new Attribute.KnownAttribute(Attribute.Kind.BYVAL));
                    continue block8;
                }
                case 6: {
                    Attribute.Kind attr = Attribute.Kind.decode(buffer.read());
                    if (attr == Attribute.Kind.BYVAL) {
                        Type valueType = this.types.get(buffer.read());
                        group.addAttribute(new Attribute.KnownTypedAttribute(Attribute.Kind.BYVAL, valueType));
                        continue block8;
                    }
                    if (attr != Attribute.Kind.SRET && attr != Attribute.Kind.ELEMENTTYPE) continue block8;
                    Type typeParam = this.types.get(buffer.read());
                    group.addAttribute(new Attribute.KnownTypedAttribute(attr, typeParam));
                    continue block8;
                }
            }
            throw new LLVMParserException("Unexpected code of attribute group: " + type);
        }
    }

    private static String readString(RecordBuffer buffer) {
        long value;
        StringBuilder sb = new StringBuilder();
        while ((value = buffer.read()) != 0L) {
            sb.append((char)value);
        }
        return sb.toString();
    }
}

