/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI1LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMOffsetLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMI1LoadNode
extends LLVMLoadNode {
    public static LLVMI1LoadNode create() {
        return LLVMI1LoadNodeGen.create(null);
    }

    public abstract boolean executeWithTarget(Object var1);

    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected boolean doI1Native(LLVMNativePointer addr) {
        return this.getLanguage().getLLVMMemory().getI1((Node)this, addr);
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"})
    protected boolean doI1DerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
        return this.doI1Managed(getReceiver.execute(addr), nativeRead);
    }

    @Specialization(limit="3")
    @GenerateAOT.Exclude
    protected boolean doI1Managed(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
        return nativeRead.readI8(addr.getObject(), addr.getOffset()) != 0;
    }

    @GenerateUncached
    public static abstract class LLVMI1OffsetLoadNode
    extends LLVMOffsetLoadNode {
        public static LLVMI1OffsetLoadNode create() {
            return LLVMI1LoadNodeGen.LLVMI1OffsetLoadNodeGen.create();
        }

        public abstract boolean executeWithTarget(LLVMPointer var1, long var2);

        @Specialization(guards={"!isAutoDerefHandle(addr)"})
        protected boolean doI1Native(LLVMNativePointer addr, long offset) {
            return this.getLanguage().getLLVMMemory().getI1((Node)this, addr.asNative() + offset);
        }

        @Specialization(guards={"isAutoDerefHandle(addr)"})
        protected boolean doI1DerefHandle(LLVMNativePointer addr, long offset, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
            return this.doI1Managed(getReceiver.execute(addr), offset, nativeRead);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        protected boolean doI1Managed(LLVMManagedPointer addr, long offset, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            return nativeRead.readI8(addr.getObject(), addr.getOffset() + offset) != 0;
        }
    }
}

