/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMAsForeignNode;
import com.oracle.truffle.llvm.runtime.interop.LLVMTypedForeignObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed.LLVMPolyglotAsTypedNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChildren(value={@NodeChild(value="ptr", type=LLVMExpressionNode.class), @NodeChild(value="typeid", type=LLVMExpressionNode.class)})
public abstract class LLVMPolyglotAsTyped
extends LLVMIntrinsic {
    public static LLVMPolyglotAsTyped create(LLVMExpressionNode ptr, LLVMExpressionNode typeid) {
        return LLVMPolyglotAsTypedNodeGen.create(ptr, typeid);
    }

    @Specialization(guards={"!foreignsLib.isForeign(pointer)"}, limit="3")
    @GenerateAOT.Exclude
    LLVMManagedPointer doManaged(LLVMManagedPointer pointer, LLVMInteropType.Structured type, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib) {
        return LLVMManagedPointer.create(LLVMTypedForeignObject.create(pointer, type));
    }

    @Specialization(guards={"foreignsLib.isForeign(pointer)"}, limit="3")
    @GenerateAOT.Exclude
    LLVMManagedPointer doAsTyped(LLVMManagedPointer pointer, LLVMInteropType.Structured type, @Cached(value="create()") LLVMAsForeignNode asForeign, @CachedLibrary(value="pointer") LLVMAsForeignLibrary foreignsLib) {
        Object foreign = asForeign.execute(pointer);
        return LLVMManagedPointer.create(LLVMTypedForeignObject.create(foreign, type));
    }

    @Specialization
    LLVMManagedPointer doNative(LLVMNativePointer address, LLVMInteropType.Structured type) {
        return LLVMManagedPointer.create(LLVMTypedForeignObject.create(address, type));
    }

    @Specialization
    LLVMManagedPointer doError(LLVMPointer object, LLVMInteropType.Value type) {
        throw new LLVMPolyglotException((Node)this, "polyglot_as_typed cannot be used with primitive type (%s).", new Object[]{type.kind});
    }
}

