/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMRetNode;

@GeneratedBy(value=LLVMRetNode.class)
final class LLVMRetNodeWrapper
extends LLVMRetNode
implements InstrumentableNode.WrapperNode {
    @Node.Child
    private LLVMRetNode delegateNode;
    @Node.Child
    private ProbeNode probeNode;

    LLVMRetNodeWrapper(LLVMRetNode delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    public LLVMRetNode getDelegateNode() {
        return this.delegateNode;
    }

    public ProbeNode getProbeNode() {
        return this.probeNode;
    }

    public NodeCost getCost() {
        return NodeCost.NONE;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object returnValue;
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                this.probeNode.onEnter(frame);
                returnValue = this.delegateNode.execute(frame);
                wasOnReturnExecuted = true;
                this.probeNode.onReturnValue(frame, this.delegateNode.convertOutgoing(returnValue));
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result != null) {
                    returnValue = result;
                    break;
                }
                throw t;
            }
            break;
        }
        return returnValue;
    }
}

