/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.api;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NonIdempotent;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.memory.LLVMHandleMemoryBase;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMHasDatalayoutNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMInstrumentableNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;

@TypeSystemReference(value=LLVMTypes.class)
@GenerateAOT
@ImportStatic(value={LLVMLanguage.class})
public abstract class LLVMNode
extends Node {
    public static final int DOUBLE_SIZE_IN_BYTES = 8;
    public static final int FLOAT_SIZE_IN_BYTES = 4;
    public static final int I16_SIZE_IN_BYTES = 2;
    public static final int I16_SIZE_IN_BITS = 16;
    public static final int I16_MASK = 65535;
    public static final int I32_SIZE_IN_BYTES = 4;
    public static final int I32_SIZE_IN_BITS = 32;
    public static final long I32_MASK = 0xFFFFFFFFL;
    public static final int I64_SIZE_IN_BYTES = 8;
    public static final int I64_SIZE_IN_BITS = 64;
    public static final int I8_SIZE_IN_BYTES = 1;
    public static final int I8_SIZE_IN_BITS = 8;
    public static final int I8_MASK = 255;
    public static final int I1_SIZE_IN_BYTES = 1;
    public static final int ADDRESS_SIZE_IN_BYTES = 8;
    private static final WeakHashMap<Node, Long> nodeIdentifiers = new WeakHashMap();
    private static final AtomicLong identifiers = new AtomicLong();

    protected static final boolean nativeCallStatisticsEnabled() {
        CompilerAsserts.neverPartOfCompilation();
        return LLVMContext.logNativeCallStatsEnabled();
    }

    protected static boolean isFunctionDescriptor(Object object) {
        return object instanceof LLVMFunctionDescriptor;
    }

    protected static LLVMFunctionDescriptor asFunctionDescriptor(Object object) {
        return object instanceof LLVMFunctionDescriptor ? (LLVMFunctionDescriptor)object : null;
    }

    protected static boolean isSameObject(Object a, Object b) {
        return a == b;
    }

    public final DataLayout getDataLayout() {
        return LLVMNode.findDataLayout(this);
    }

    public static DataLayout findDataLayout(Node node) {
        Node datalayoutNode = node;
        while (!(datalayoutNode instanceof LLVMHasDatalayoutNode)) {
            if (datalayoutNode.getParent() != null) {
                assert (!(datalayoutNode instanceof RootNode)) : "root node must not have a parent";
                datalayoutNode = datalayoutNode.getParent();
                continue;
            }
            return LLVMLanguage.get(null).getDefaultDataLayout();
        }
        return ((LLVMHasDatalayoutNode)datalayoutNode).getDatalayout();
    }

    private static synchronized long getNodeId(Node node) {
        return nodeIdentifiers.computeIfAbsent(node, n -> identifiers.incrementAndGet());
    }

    protected final String getShortString(String ... fields) {
        return LLVMNode.getShortString(this, fields);
    }

    public static String getShortString(Node node, String ... fields) {
        LLVMInstrumentableNode instruction;
        CompilerAsserts.neverPartOfCompilation();
        StringBuilder str = new StringBuilder();
        if (node instanceof LLVMInstrumentableNode && (instruction = (LLVMInstrumentableNode)node).hasTag(StandardTags.StatementTag.class)) {
            LLVMSourceLocation location = instruction.getSourceLocation();
            str.append(location.getName()).append(":").append(location.getLine()).append(" ");
        }
        str.append(node.getClass().getSimpleName()).append("#").append(LLVMNode.getNodeId(node));
        block2: for (String field : fields) {
            for (Class<?> c = node.getClass(); c != Object.class; c = c.getSuperclass()) {
                try {
                    Field declaredField = c.getDeclaredField(field);
                    declaredField.setAccessible(true);
                    Object value = declaredField.get(node);
                    str.append(" ").append(field).append("=").append(LLVMNode.formatFieldValue(value));
                    continue block2;
                }
                catch (IllegalAccessException | NoSuchFieldException | RuntimeException exception) {
                    continue;
                }
            }
        }
        return str.toString();
    }

    public String toString() {
        return this.getShortString(new String[0]);
    }

    private static Object formatFieldValue(Object value) {
        if (value != null && value.getClass().isArray()) {
            if (value instanceof int[]) {
                return Arrays.toString((int[])value);
            }
            if (value instanceof long[]) {
                return Arrays.toString((long[])value);
            }
            if (value instanceof byte[]) {
                return Arrays.toString((byte[])value);
            }
            if (value instanceof boolean[]) {
                return Arrays.toString((boolean[])value);
            }
            if (value instanceof short[]) {
                return Arrays.toString((short[])value);
            }
            if (value instanceof char[]) {
                return Arrays.toString((char[])value);
            }
            if (value instanceof float[]) {
                return Arrays.toString((float[])value);
            }
            if (value instanceof double[]) {
                return Arrays.toString((double[])value);
            }
            return Arrays.asList((Object[])value).toString();
        }
        return String.valueOf(value);
    }

    @NonIdempotent
    public final boolean isAutoDerefHandle(LLVMNativePointer addr) {
        return this.isAutoDerefHandle(addr.asNative());
    }

    @NonIdempotent
    public final boolean isAutoDerefHandle(long addr) {
        if (CompilerDirectives.inCompiledCode() && this.getLanguage().getNoDerefHandleAssumption().isValid()) {
            return false;
        }
        return LLVMHandleMemoryBase.isDerefHandleMemory(addr);
    }

    public static <T extends Node> T getParent(Node node, Class<T> clazz) {
        for (Node current = node; current != null; current = current.getParent()) {
            Node delegate;
            if (clazz.isInstance(current)) {
                return (T)((Node)clazz.cast(current));
            }
            if (!(current instanceof InstrumentableNode.WrapperNode) || !clazz.isInstance(delegate = ((InstrumentableNode.WrapperNode)current).getDelegateNode())) continue;
            return (T)((Node)clazz.cast(delegate));
        }
        return null;
    }

    public final LLVMContext getContext() {
        return LLVMContext.get(this);
    }

    public final LLVMLanguage getLanguage() {
        return LLVMLanguage.get(this);
    }

    public static final class AOTInitHelper
    extends Node
    implements GenerateAOT.Provider {
        private final GenerateAOT.Provider delegate;

        public AOTInitHelper(final BiConsumer<TruffleLanguage<?>, RootNode> delegate) {
            this.delegate = new GenerateAOT.Provider(){

                public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
                    delegate.accept(language, root);
                }
            };
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            this.delegate.prepareForAOT(language, root);
        }
    }
}

