/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

abstract class LLVMNativeLibraryDefaults {
    LLVMNativeLibraryDefaults() {
    }

    @ExportLibrary(value=LLVMNativeLibrary.class, receiverType=byte[].class, useForAOT=false)
    static class ArrayLibrary {
        ArrayLibrary() {
        }

        @ExportMessage
        static boolean isPointer(byte[] receiver) {
            return false;
        }

        @ExportMessage
        static long asPointer(byte[] receiver) throws UnsupportedMessageException {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnsupportedMessageException.create();
        }

        @ExportMessage
        static LLVMNativePointer toNativePointer(byte[] receiver, @CachedLibrary(value="receiver") LLVMNativeLibrary self) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new LLVMPolyglotException((Node)self, "Cannot convert virtual allocation object to native pointer.");
        }
    }

    @ExportLibrary(value=LLVMNativeLibrary.class, receiverType=Long.class, useForAOT=false)
    static class LongLibrary {
        LongLibrary() {
        }

        @ExportMessage
        static boolean isPointer(Long receiver) {
            return true;
        }

        @ExportMessage
        static long asPointer(Long receiver) {
            return receiver;
        }

        @ExportMessage
        static LLVMNativePointer toNativePointer(Long receiver) {
            return LLVMNativePointer.create(receiver);
        }
    }

    @ExportLibrary(value=LLVMNativeLibrary.class, receiverType=Object.class, useForAOT=false)
    static class DefaultLibrary {
        DefaultLibrary() {
        }

        @ExportMessage
        static class ToNativePointer {
            ToNativePointer() {
            }

            @Specialization(guards={"interop.isNull(receiver)"})
            static LLVMNativePointer doNull(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop) {
                return LLVMNativePointer.createNull();
            }

            @Specialization(guards={"!interop.isNull(receiver)", "interop.isPointer(receiver)"}, rewriteOn={UnsupportedMessageException.class})
            static LLVMNativePointer doAlreadyNative(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop) throws UnsupportedMessageException {
                return LLVMNativePointer.create(interop.asPointer(receiver));
            }

            @Specialization(replaces={"doAlreadyNative"}, guards={"!interop.isNull(receiver)"})
            static LLVMNativePointer doNotNull(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached.Shared(value="exception") @Cached BranchProfile exceptionProfile) {
                try {
                    if (!interop.isPointer(receiver)) {
                        interop.toNative(receiver);
                    }
                    return LLVMNativePointer.create(interop.asPointer(receiver));
                }
                catch (UnsupportedMessageException ex) {
                    exceptionProfile.enter();
                    throw new LLVMPolyglotException((Node)interop, "Cannot convert %s to native pointer.", receiver);
                }
            }
        }

        @ExportMessage
        static class AsPointer {
            AsPointer() {
            }

            @Specialization(guards={"interop.isPointer(receiver)"})
            static long doPointer(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached.Shared(value="exception") @Cached BranchProfile exceptionProfile) throws UnsupportedMessageException {
                try {
                    return interop.asPointer(receiver);
                }
                catch (UnsupportedMessageException ex) {
                    exceptionProfile.enter();
                    if (interop.isNull(receiver)) {
                        return 0L;
                    }
                    throw ex;
                }
            }

            @Specialization(guards={"!interop.isPointer(receiver)"})
            static long doNullCheck(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached.Shared(value="exception") @Cached BranchProfile exceptionProfile) throws UnsupportedMessageException {
                if (interop.isNull(receiver)) {
                    return 0L;
                }
                exceptionProfile.enter();
                throw UnsupportedMessageException.create();
            }
        }

        @ExportMessage
        static class IsPointer {
            IsPointer() {
            }

            @Specialization(guards={"interop.isPointer(receiver)"})
            static boolean doPointer(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop) {
                return true;
            }

            @Specialization(guards={"!interop.isPointer(receiver)"})
            static boolean doOther(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop) {
                return interop.isNull(receiver);
            }
        }
    }
}

