/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.scope;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.llvm.runtime.debug.LLVMDebuggerValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

@ExportLibrary(value=InteropLibrary.class)
public final class LLVMDebuggerScopeEntries
extends LLVMDebuggerValue {
    static final LLVMDebuggerScopeEntries EMPTY_SCOPE = new LLVMDebuggerScopeEntries("EMPTY_SCOPE");
    private LLVMDebuggerScopeEntries parentScope;
    private final ArrayList<String> flattenedScopeEntries;
    private final Map<String, Object> flattenedScopeMap;
    private final Map<String, Object> entries = new HashMap<String, Object>();
    private final String scopeName;
    private boolean isScopeFlattened = false;

    LLVMDebuggerScopeEntries() {
        this("LLVM");
    }

    LLVMDebuggerScopeEntries(String scopeName) {
        this.flattenedScopeEntries = new ArrayList();
        this.flattenedScopeMap = new HashMap<String, Object>();
        this.scopeName = scopeName;
    }

    @CompilerDirectives.TruffleBoundary
    void add(String name, Object value) {
        this.entries.put(name, value);
    }

    @CompilerDirectives.TruffleBoundary
    boolean contains(String name) {
        return this.entries.containsKey(name);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected int getElementCountForDebugger() {
        if (!this.isScopeFlattened) {
            this.flattenScopeEntries();
        }
        return this.flattenedScopeEntries.size();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected String[] getKeysForDebugger() {
        int count;
        if (!this.isScopeFlattened) {
            this.flattenScopeEntries();
        }
        if ((count = this.getElementCountForDebugger()) == 0) {
            return NO_KEYS;
        }
        return this.flattenedScopeEntries.toArray(NO_KEYS);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    protected Object getElementForDebugger(String key) {
        if (!this.isScopeFlattened) {
            this.flattenScopeEntries();
        }
        return this.flattenedScopeMap.get(key);
    }

    @CompilerDirectives.TruffleBoundary
    void removeElement(String key) {
        this.entries.remove(key);
    }

    protected void setParentScope(LLVMDebuggerScopeEntries parentScope) {
        CompilerAsserts.neverPartOfCompilation();
        this.parentScope = parentScope;
    }

    private void flattenScopeEntries() {
        CompilerAsserts.neverPartOfCompilation();
        LLVMDebuggerScopeEntries tempScope = this;
        while (tempScope != null) {
            this.flattenedScopeMap.putAll(tempScope.entries);
            this.flattenedScopeEntries.addAll(tempScope.entries.keySet());
            tempScope = tempScope.parentScope;
        }
        this.isScopeFlattened = true;
    }

    @ExportMessage
    public boolean isScope() {
        return true;
    }

    @ExportMessage
    public boolean hasScopeParent() {
        return this.parentScope != null;
    }

    @ExportMessage
    public Object getScopeParent() throws UnsupportedMessageException {
        if (!this.hasScopeParent()) {
            throw UnsupportedMessageException.create();
        }
        return this.parentScope;
    }

    @Override
    @ExportMessage
    public String toDisplayString(boolean allowSideEffects) {
        return this.scopeName;
    }
}

