/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.IDGenerater;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMScopeChain;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import com.oracle.truffle.llvm.runtime.except.LLVMIllegalSymbolIndexException;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMGlobalRootNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;

@ExportLibrary(value=InteropLibrary.class)
public final class SulongLibrary
implements TruffleObject {
    private final String name;
    private final LLVMScopeChain scope;
    private final LLVMContext context;
    final CachedMainFunction main;
    private final LibraryLocator libraryLocator;
    private final IDGenerater.BitcodeID bitcodeID;

    public SulongLibrary(String name, LLVMScopeChain scope, CachedMainFunction main, LLVMContext context, LibraryLocator libraryLocator, IDGenerater.BitcodeID bitcodeID) {
        this.name = name;
        this.scope = scope;
        this.main = main;
        this.context = context;
        this.libraryLocator = libraryLocator;
        this.bitcodeID = bitcodeID;
    }

    private LLVMFunctionDescriptor lookupFunctionDescriptor(String symbolName) {
        CompilerAsserts.neverPartOfCompilation();
        try {
            LLVMPointer value;
            LLVMFunction function = this.scope.getFunction(symbolName);
            if (function != null && (value = this.context.getSymbolUncached(function)) != null) {
                return (LLVMFunctionDescriptor)LLVMManagedPointer.cast(value).getObject();
            }
        }
        catch (LLVMIllegalSymbolIndexException | LLVMLinkerException lLVMException) {
            // empty catch block
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public IDGenerater.BitcodeID getBitcodeID() {
        return this.bitcodeID;
    }

    @ExportMessage
    Object readMember(String member, @Cached.Shared(value="lookup") @Cached LookupNode lookup, @Cached @Cached.Shared(value="notFound") BranchProfile notFound) throws UnknownIdentifierException {
        LLVMFunctionDescriptor ret = lookup.execute(this, member);
        if (ret == null) {
            notFound.enter();
            throw UnknownIdentifierException.create((String)member);
        }
        return ret;
    }

    @ExportMessage
    Object invokeMember(String member, Object[] arguments, @Cached.Shared(value="lookup") @Cached LookupNode lookup, @CachedLibrary(limit="1") InteropLibrary interop, @Cached @Cached.Shared(value="notFound") BranchProfile notFound) throws ArityException, UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException {
        LLVMFunctionDescriptor fn = lookup.execute(this, member);
        if (fn == null) {
            notFound.enter();
            throw UnknownIdentifierException.create((String)member);
        }
        return interop.execute((Object)fn, arguments);
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return this.scope.getKeys();
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isMemberReadable"), @ExportMessage(name="isMemberInvocable")})
    boolean memberExists(String member, @Cached.Shared(value="lookup") @Cached LookupNode lookup) {
        return lookup.execute(this, member) != null;
    }

    @ExportMessage
    boolean isExecutable() {
        return this.main != null;
    }

    @ExportMessage
    boolean hasLanguage() {
        return true;
    }

    @ExportMessage
    Class<? extends TruffleLanguage<?>> getLanguage() {
        return LLVMLanguage.class;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    String toDisplayString(boolean allowSideEffects) {
        return "LLVMLibrary:" + this.getName();
    }

    public static final class CachedMainFunction {
        private final LLVMFunction mainFunction;
        private CallTarget mainCallTarget;

        public CachedMainFunction(LLVMFunction mainFunction) {
            this.mainFunction = mainFunction;
        }

        public CallTarget getMainCallTarget() {
            if (this.mainCallTarget == null) {
                this.mainCallTarget = this.createCallTarget();
            }
            return this.mainCallTarget;
        }

        @CompilerDirectives.TruffleBoundary
        private CallTarget createCallTarget() {
            LLVMLanguage language = LLVMLanguage.get(null);
            RootCallTarget startCallTarget = language.getStartFunctionCode().getLLVMIRFunctionSlowPath();
            Path applicationPath = Paths.get(this.mainFunction.getStringPath(), new String[0]);
            LLVMGlobalRootNode rootNode = new LLVMGlobalRootNode(language, this.mainFunction, (CallTarget)startCallTarget, Objects.toString(applicationPath, ""));
            return rootNode.getCallTarget();
        }
    }

    @GenerateUncached
    static abstract class LookupNode
    extends LLVMNode {
        LookupNode() {
        }

        abstract LLVMFunctionDescriptor execute(SulongLibrary var1, String var2);

        @Specialization(guards={"library == cachedLibrary", "name.equals(cachedName)", "isSingleContext($node)"})
        LLVMFunctionDescriptor doCached(SulongLibrary library, String name, @Cached(value="library") SulongLibrary cachedLibrary, @Cached(value="name") String cachedName, @Cached(value="lookupFunctionDescriptor(cachedLibrary, cachedName)") LLVMFunctionDescriptor cachedDescriptor) {
            return cachedDescriptor;
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        static LLVMFunctionDescriptor doGeneric(SulongLibrary library, String name) {
            return LookupNode.lookupFunctionDescriptor(library, name);
        }

        protected static LLVMFunctionDescriptor lookupFunctionDescriptor(SulongLibrary library, String name) {
            CompilerAsserts.neverPartOfCompilation();
            return library.lookupFunctionDescriptor(name);
        }
    }

    @ExportMessage
    static abstract class Execute {
        Execute() {
        }

        @Specialization(guards={"library.main == cachedMain", "cachedMain != null"})
        static Object doCached(SulongLibrary library, Object[] args, @Cached(value="library.main") CachedMainFunction cachedMain, @Cached(value="create(cachedMain.getMainCallTarget())") DirectCallNode call) {
            LLVMContext.get((Node)call).setMainLibraryLocator(library.libraryLocator);
            return call.call(args);
        }

        @Specialization(replaces={"doCached"}, guards={"library.main != null"})
        static Object doGeneric(SulongLibrary library, Object[] args, @Cached(value="create()") IndirectCallNode call) {
            LLVMContext.get((Node)call).setMainLibraryLocator(library.libraryLocator);
            return call.call(library.main.getMainCallTarget(), args);
        }

        @Specialization(guards={"library.main == null"})
        static Object doUnsupported(SulongLibrary library, Object[] args) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }
}

