/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMElemPtrSymbol;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LLVMThreadLocalSymbol;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class LLVMScope
implements TruffleObject {
    private final HashMap<String, LLVMSymbol> symbols;
    private final ArrayList<String> functionKeys;
    private final HashMap<String, String> linkageNames;

    public LLVMScope() {
        this.symbols = new HashMap();
        this.functionKeys = new ArrayList();
        this.linkageNames = new HashMap();
    }

    public LLVMScope(HashMap<String, LLVMSymbol> symbols, ArrayList<String> functionKeys, HashMap<String, String> linkageNames) {
        this.symbols = symbols;
        this.functionKeys = functionKeys;
        this.linkageNames = linkageNames;
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMSymbol get(String name) {
        return this.symbols.get(name);
    }

    @CompilerDirectives.TruffleBoundary
    public String getKey(int idx) {
        return this.functionKeys.get(idx);
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMFunction getFunction(String name) {
        LLVMSymbol symbol = this.get(name);
        if (symbol != null && symbol.isFunction()) {
            return symbol.asFunction();
        }
        String newName = this.linkageNames.get(name);
        if (newName != null && (symbol = this.get(newName)) != null && symbol.isFunction()) {
            return symbol.asFunction();
        }
        return null;
    }

    public void registerLinkageName(String name, String linkageName) {
        this.linkageNames.put(name, linkageName);
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMThreadLocalSymbol getThreadLocalVariable(String name) {
        LLVMSymbol symbol = this.get(name);
        if (symbol != null && symbol.isThreadLocalSymbol()) {
            return symbol.asThreadLocalSymbol();
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMGlobal getGlobalVariable(String name) {
        LLVMSymbol symbol = this.get(name);
        if (symbol != null && symbol.isGlobalVariable()) {
            return symbol.asGlobalVariable();
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public LLVMElemPtrSymbol getGetElementPtrSymbol(String name) {
        LLVMSymbol symbol = this.get(name);
        if (symbol != null && symbol.isElemPtrExpression()) {
            return symbol.asElemPtrExpression();
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public void register(LLVMSymbol symbol) {
        LLVMSymbol existing = this.symbols.get(symbol.getName());
        if (existing == null) {
            this.put(symbol.getName(), symbol);
        } else assert (existing == symbol);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean contains(String name) {
        return this.symbols.containsKey(name);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean exports(LLVMContext context, String name) {
        LLVMSymbol localSymbol = this.get(name);
        LLVMSymbol globalSymbol = context.getGlobalScopeChain().get(name);
        return localSymbol != null && localSymbol == globalSymbol;
    }

    public boolean isEmpty() {
        return this.symbols.isEmpty();
    }

    @CompilerDirectives.TruffleBoundary
    public Collection<LLVMSymbol> values() {
        return this.symbols.values();
    }

    @CompilerDirectives.TruffleBoundary
    public void rename(String oldName, LLVMSymbol symbol) {
        this.remove(oldName);
        this.register(symbol);
    }

    public long getFunctionSize() {
        return this.functionKeys.size();
    }

    private void put(String name, LLVMSymbol symbol) {
        assert (!this.symbols.containsKey(name));
        this.symbols.put(name, symbol);
        if (symbol.isFunction()) {
            assert (!this.functionKeys.contains(name));
            assert (this.functionKeys.size() < this.symbols.size());
            this.functionKeys.add(name);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void remove(String name) {
        assert (this.symbols.containsKey(name));
        LLVMSymbol removedSymbol = this.symbols.remove(name);
        if (removedSymbol.isFunction()) {
            boolean contained = this.functionKeys.remove(name);
            assert (contained);
        }
    }
}

