/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;

@ExportLibrary(value=InteropLibrary.class)
public final class LLVMExitException
extends AbstractTruffleException {
    private static final long serialVersionUID = 1L;
    private static final int UNIX_SIGABORT = 134;
    private final int returnCode;

    public static LLVMExitException abort(Node location) {
        return new LLVMExitException(134, location);
    }

    public static LLVMExitException exit(int returnCode, Node location) {
        return new LLVMExitException(returnCode, location);
    }

    private LLVMExitException(int returnCode, Node location) {
        super(location);
        this.returnCode = returnCode;
    }

    @ExportMessage
    ExceptionType getExceptionType() {
        return ExceptionType.EXIT;
    }

    @ExportMessage
    public int getExceptionExitStatus() {
        return this.returnCode;
    }
}

