/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.TerminatingInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.VoidInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;

public final class SwitchOldInstruction
extends VoidInstruction
implements TerminatingInstruction {
    private SymbolImpl condition;
    private final InstructionBlock defaultBlock;
    private final long[] cases;
    private final InstructionBlock[] blocks;

    private SwitchOldInstruction(InstructionBlock defaultBlock, long[] cases, InstructionBlock[] blocks) {
        this.defaultBlock = defaultBlock;
        this.cases = cases;
        this.blocks = blocks;
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public InstructionBlock getCaseBlock(int index) {
        return this.blocks[index];
    }

    public int getCaseCount() {
        return this.cases.length;
    }

    public long getCaseValue(int index) {
        return this.cases[index];
    }

    public SymbolImpl getCondition() {
        return this.condition;
    }

    public InstructionBlock getDefaultBlock() {
        return this.defaultBlock;
    }

    @Override
    public int getSuccessorCount() {
        return this.blocks.length + 1;
    }

    @Override
    public InstructionBlock getSuccessor(int index) {
        assert (index >= 0 && index < this.getSuccessorCount());
        if (index >= this.blocks.length) {
            return this.defaultBlock;
        }
        return this.blocks[index];
    }

    @Override
    public void replace(SymbolImpl original, SymbolImpl replacement) {
        if (this.condition == original) {
            this.condition = replacement;
        }
    }

    public static SwitchOldInstruction generate(FunctionDefinition function, SymbolTable symbols, int condition, int defaultBlock, long[] cases, int[] targetBlocks) {
        InstructionBlock[] blocks = new InstructionBlock[targetBlocks.length];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = function.getBlock(targetBlocks[i]);
        }
        SwitchOldInstruction inst = new SwitchOldInstruction(function.getBlock(defaultBlock), cases, blocks);
        inst.condition = symbols.getForwardReferenced(condition, inst);
        return inst;
    }
}

