/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.macho;

import com.oracle.truffle.llvm.parser.macho.MachOReader;

public final class MachOHeader {
    private final int cpuType;
    private final int cpuSubType;
    private final int fileType;
    private final int nCmds;
    private final int sizeOfCmds;
    private final int flags;
    private final int reserved;

    public MachOHeader(int cpuType, int cpuSubType, int fileType, int nrOfCmds, int sizeOfCmds, int flags, int reserved) {
        this.cpuType = cpuType;
        this.cpuSubType = cpuSubType;
        this.fileType = fileType;
        this.nCmds = nrOfCmds;
        this.sizeOfCmds = sizeOfCmds;
        this.flags = flags;
        this.reserved = reserved;
    }

    public int getCpuType() {
        return this.cpuType;
    }

    public int getCpuSubType() {
        return this.cpuSubType;
    }

    public int getFileType() {
        return this.fileType;
    }

    public int getNCmds() {
        return this.nCmds;
    }

    public int getSizeOfCmds() {
        return this.sizeOfCmds;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getReserved() {
        return this.reserved;
    }

    public static MachOHeader create(MachOReader reader) {
        int cpuType = reader.getInt();
        int cpuSubType = reader.getInt();
        int fileType = reader.getInt();
        int nrOfCmds = reader.getInt();
        int sizeOfCmds = reader.getInt();
        int flags = reader.getInt();
        int reserved = reader.is64Bit() ? reader.getInt() : 0;
        return new MachOHeader(cpuType, cpuSubType, fileType, nrOfCmds, sizeOfCmds, flags, reserved);
    }
}

