/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.UnaryOperation;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMUnaryNode;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMUnaryNode.class)
public final class LLVMUnaryNodeFactory {

    @GeneratedBy(value=LLVMUnaryNode.LLVMFP128UnaryNode.class)
    public static final class LLVMFP128UnaryNodeGen
    extends LLVMUnaryNode.LLVMFP128UnaryNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode operandNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMFP128UnaryNodeGen(UnaryOperation op, LLVMExpressionNode operandNode) {
            super(op);
            this.operandNode_ = operandNode;
        }

        @Override
        public Object executeWithTarget(Object operandNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(operandNodeValue);
            }
            if ((state_0 & 2) != 0 && operandNodeValue instanceof LLVM128BitFloat) {
                LLVM128BitFloat operandNodeValue_ = (LLVM128BitFloat)operandNodeValue;
                return this.do128BitFloat(operandNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(operandNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object operandNodeValue_ = this.operandNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(operandNodeValue_);
            }
            if ((state_0 & 2) != 0 && operandNodeValue_ instanceof LLVM128BitFloat) {
                LLVM128BitFloat operandNodeValue__ = (LLVM128BitFloat)operandNodeValue_;
                return this.do128BitFloat(operandNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(operandNodeValue_);
        }

        private LLVM128BitFloat executeAndSpecialize(Object operandNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (operandNodeValue instanceof LLVM128BitFloat) {
                LLVM128BitFloat operandNodeValue_ = (LLVM128BitFloat)operandNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.do128BitFloat(operandNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.operandNode_}, new Object[]{operandNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMUnaryNode.LLVMFP128UnaryNode create(UnaryOperation op, LLVMExpressionNode operandNode) {
            return new LLVMFP128UnaryNodeGen(op, operandNode);
        }
    }

    @GeneratedBy(value=LLVMUnaryNode.LLVMFP80UnaryNode.class)
    public static final class LLVMFP80UnaryNodeGen
    extends LLVMUnaryNode.LLVMFP80UnaryNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode operandNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMFP80UnaryNodeGen(UnaryOperation op, LLVMExpressionNode operandNode) {
            super(op);
            this.operandNode_ = operandNode;
        }

        @Override
        public Object executeWithTarget(Object operandNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(operandNodeValue);
            }
            if ((state_0 & 2) != 0 && operandNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat operandNodeValue_ = (LLVM80BitFloat)operandNodeValue;
                return this.do80BitFloat(operandNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(operandNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object operandNodeValue_ = this.operandNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(operandNodeValue_);
            }
            if ((state_0 & 2) != 0 && operandNodeValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat operandNodeValue__ = (LLVM80BitFloat)operandNodeValue_;
                return this.do80BitFloat(operandNodeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(operandNodeValue_);
        }

        private LLVM80BitFloat executeAndSpecialize(Object operandNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (operandNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat operandNodeValue_ = (LLVM80BitFloat)operandNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.do80BitFloat(operandNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.operandNode_}, new Object[]{operandNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMUnaryNode.LLVMFP80UnaryNode create(UnaryOperation op, LLVMExpressionNode operandNode) {
            return new LLVMFP80UnaryNodeGen(op, operandNode);
        }
    }

    @GeneratedBy(value=LLVMUnaryNode.LLVMDoubleUnaryNode.class)
    public static final class LLVMDoubleUnaryNodeGen
    extends LLVMUnaryNode.LLVMDoubleUnaryNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode operandNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMDoubleUnaryNodeGen(UnaryOperation op, LLVMExpressionNode operandNode) {
            super(op);
            this.operandNode_ = operandNode;
        }

        @Override
        public Object executeWithTarget(Object operandNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(operandNodeValue);
            }
            if ((state_0 & 2) != 0 && operandNodeValue instanceof Double) {
                double operandNodeValue_ = (Double)operandNodeValue;
                return this.doDouble(operandNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(operandNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            double operandNodeValue_;
            int state_0 = this.state_0_;
            try {
                operandNodeValue_ = this.operandNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(operandNodeValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doDouble(operandNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(operandNodeValue_);
        }

        @Override
        public double executeDouble(VirtualFrame frameValue) {
            double operandNodeValue_;
            int state_0 = this.state_0_;
            try {
                operandNodeValue_ = this.operandNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(operandNodeValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doDouble(operandNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(operandNodeValue_);
        }

        private double executeAndSpecialize(Object operandNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (operandNodeValue instanceof Double) {
                double operandNodeValue_ = (Double)operandNodeValue;
                this.state_0_ = state_0 |= 2;
                return this.doDouble(operandNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.operandNode_}, new Object[]{operandNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMUnaryNode.LLVMDoubleUnaryNode create(UnaryOperation op, LLVMExpressionNode operandNode) {
            return new LLVMDoubleUnaryNodeGen(op, operandNode);
        }
    }

    @GeneratedBy(value=LLVMUnaryNode.LLVMFloatUnaryNode.class)
    public static final class LLVMFloatUnaryNodeGen
    extends LLVMUnaryNode.LLVMFloatUnaryNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode operandNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMFloatUnaryNodeGen(UnaryOperation op, LLVMExpressionNode operandNode) {
            super(op);
            this.operandNode_ = operandNode;
        }

        @Override
        public Object executeWithTarget(Object operandNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return Float.valueOf(this.executeAndSpecialize(operandNodeValue));
            }
            if ((state_0 & 2) != 0 && operandNodeValue instanceof Float) {
                float operandNodeValue_ = ((Float)operandNodeValue).floatValue();
                return Float.valueOf(this.doFloat(operandNodeValue_));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return Float.valueOf(this.executeAndSpecialize(operandNodeValue));
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            float operandNodeValue_;
            int state_0 = this.state_0_;
            try {
                operandNodeValue_ = this.operandNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return Float.valueOf(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return Float.valueOf(this.executeAndSpecialize(Float.valueOf(operandNodeValue_)));
            }
            if ((state_0 & 2) != 0) {
                return Float.valueOf(this.doFloat(operandNodeValue_));
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return Float.valueOf(this.executeAndSpecialize(Float.valueOf(operandNodeValue_)));
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) {
            float operandNodeValue_;
            int state_0 = this.state_0_;
            try {
                operandNodeValue_ = this.operandNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(Float.valueOf(operandNodeValue_));
            }
            if ((state_0 & 2) != 0) {
                return this.doFloat(operandNodeValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(Float.valueOf(operandNodeValue_));
        }

        private float executeAndSpecialize(Object operandNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (operandNodeValue instanceof Float) {
                float operandNodeValue_ = ((Float)operandNodeValue).floatValue();
                this.state_0_ = state_0 |= 2;
                return this.doFloat(operandNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.operandNode_}, new Object[]{operandNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMUnaryNode.LLVMFloatUnaryNode create(UnaryOperation op, LLVMExpressionNode operandNode) {
            return new LLVMFloatUnaryNodeGen(op, operandNode);
        }
    }
}

