/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesLongPointer;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMBuiltin;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMFunnelShiftNodeFactory;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;

@NodeChildren(value={@NodeChild(value="left"), @NodeChild(value="right"), @NodeChild(value="shift")})
public abstract class LLVMFunnelShiftNode
extends LLVMExpressionNode {
    public static LLVMBuiltin.TypedBuiltinFactory getFshlFactory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case I8: {
                return LLVMBuiltin.TypedBuiltinFactory.vector3(LLVMFunnelShiftNodeFactory.Fshl_I8NodeGen::create, LLVMFunnelShiftNodeFactory.Fshl_I8VectorNodeGen::create);
            }
            case I16: {
                return LLVMBuiltin.TypedBuiltinFactory.vector3(LLVMFunnelShiftNodeFactory.Fshl_I16NodeGen::create, LLVMFunnelShiftNodeFactory.Fshl_I16VectorNodeGen::create);
            }
            case I32: {
                return LLVMBuiltin.TypedBuiltinFactory.vector3(LLVMFunnelShiftNodeFactory.Fshl_I32NodeGen::create, LLVMFunnelShiftNodeFactory.Fshl_I32VectorNodeGen::create);
            }
            case I64: {
                return LLVMBuiltin.TypedBuiltinFactory.vector3(LLVMFunnelShiftNodeFactory.Fshl_I64NodeGen::create, LLVMFunnelShiftNodeFactory.Fshl_I64VectorNodeGen::create);
            }
        }
        return null;
    }

    public static LLVMBuiltin.TypedBuiltinFactory getFshrFactory(PrimitiveType.PrimitiveKind type) {
        switch (type) {
            case I8: {
                return LLVMBuiltin.TypedBuiltinFactory.vector3(LLVMFunnelShiftNodeFactory.Fshr_I8NodeGen::create, LLVMFunnelShiftNodeFactory.Fshr_I8VectorNodeGen::create);
            }
            case I16: {
                return LLVMBuiltin.TypedBuiltinFactory.vector3(LLVMFunnelShiftNodeFactory.Fshr_I16NodeGen::create, LLVMFunnelShiftNodeFactory.Fshr_I16VectorNodeGen::create);
            }
            case I32: {
                return LLVMBuiltin.TypedBuiltinFactory.vector3(LLVMFunnelShiftNodeFactory.Fshr_I32NodeGen::create, LLVMFunnelShiftNodeFactory.Fshr_I32VectorNodeGen::create);
            }
            case I64: {
                return LLVMBuiltin.TypedBuiltinFactory.vector3(LLVMFunnelShiftNodeFactory.Fshr_I64NodeGen::create, LLVMFunnelShiftNodeFactory.Fshr_I64VectorNodeGen::create);
            }
        }
        return null;
    }

    public static abstract class Fshr_I64Vector
    extends LLVMFunnelShiftNode {
        private final int vectorSize;

        Fshr_I64Vector(int vectorSize) {
            this.vectorSize = vectorSize;
        }

        @Specialization
        LLVMI64Vector doFshl(LLVMI64Vector left, LLVMI64Vector right, LLVMI64Vector shift) {
            assert (left.getLength() == this.vectorSize && right.getLength() == this.vectorSize && shift.getLength() == this.vectorSize);
            long[] ret = new long[this.vectorSize];
            for (int i = 0; i < this.vectorSize; ++i) {
                long sh = shift.getValue(i);
                ret[i] = left.getValue(i) << (int)(64L - sh) | right.getValue(i) >>> (int)sh;
            }
            return LLVMI64Vector.create(ret);
        }
    }

    public static abstract class Fshr_I64
    extends LLVMFunnelShiftNode {
        @Specialization
        long doFshl(long left, long right, long shift) {
            return left << (int)(64L - shift) | right >>> (int)shift;
        }
    }

    public static abstract class Fshr_I32Vector
    extends LLVMFunnelShiftNode {
        private final int vectorSize;

        Fshr_I32Vector(int vectorSize) {
            this.vectorSize = vectorSize;
        }

        @Specialization
        LLVMI32Vector doFshl(LLVMI32Vector left, LLVMI32Vector right, LLVMI32Vector shift) {
            assert (left.getLength() == this.vectorSize && right.getLength() == this.vectorSize && shift.getLength() == this.vectorSize);
            int[] ret = new int[this.vectorSize];
            for (int i = 0; i < this.vectorSize; ++i) {
                int sh = shift.getValue(i);
                ret[i] = left.getValue(i) << 32 - sh | right.getValue(i) >>> sh;
            }
            return LLVMI32Vector.create(ret);
        }
    }

    public static abstract class Fshr_I32
    extends LLVMFunnelShiftNode {
        @Specialization
        int doFshl(int left, int right, int shift) {
            return left << 32 - shift | right >>> shift;
        }
    }

    public static abstract class Fshr_I16Vector
    extends LLVMFunnelShiftNode {
        private final int vectorSize;

        Fshr_I16Vector(int vectorSize) {
            this.vectorSize = vectorSize;
        }

        @Specialization
        LLVMI16Vector doFshl(LLVMI16Vector left, LLVMI16Vector right, LLVMI16Vector shift) {
            assert (left.getLength() == this.vectorSize && right.getLength() == this.vectorSize && shift.getLength() == this.vectorSize);
            short[] ret = new short[this.vectorSize];
            for (int i = 0; i < this.vectorSize; ++i) {
                short sh = shift.getValue(i);
                ret[i] = (short)(left.getValue(i) << 16 - sh | (short)((right.getValue(i) & 0xFFFF) >>> sh));
            }
            return LLVMI16Vector.create(ret);
        }
    }

    public static abstract class Fshr_I16
    extends LLVMFunnelShiftNode {
        @Specialization
        short doFshl(short left, short right, short shift) {
            return (short)(left << 16 - shift | (short)((right & 0xFFFF) >>> shift));
        }
    }

    public static abstract class Fshr_I8Vector
    extends LLVMFunnelShiftNode {
        private final int vectorSize;

        Fshr_I8Vector(int vectorSize) {
            this.vectorSize = vectorSize;
        }

        @Specialization
        LLVMI8Vector doFshl(LLVMI8Vector left, LLVMI8Vector right, LLVMI8Vector shift) {
            assert (left.getLength() == this.vectorSize && right.getLength() == this.vectorSize && shift.getLength() == this.vectorSize);
            byte[] ret = new byte[this.vectorSize];
            for (int i = 0; i < this.vectorSize; ++i) {
                byte sh = shift.getValue(i);
                ret[i] = (byte)(left.getValue(i) << 8 - sh | (byte)((right.getValue(i) & 0xFF) >>> sh));
            }
            return LLVMI8Vector.create(ret);
        }
    }

    public static abstract class Fshr_I8
    extends LLVMFunnelShiftNode {
        @Specialization
        byte doFshl(byte left, byte right, byte shift) {
            return (byte)(left << 8 - shift | (byte)((right & 0xFF) >>> shift));
        }
    }

    public static abstract class Fshl_I64Vector
    extends LLVMFunnelShiftNode {
        private final int vectorSize;

        Fshl_I64Vector(int vectorSize) {
            this.vectorSize = vectorSize;
        }

        @Specialization
        LLVMI64Vector doFshl(LLVMI64Vector left, LLVMI64Vector right, LLVMI64Vector shift) {
            assert (left.getLength() == this.vectorSize && right.getLength() == this.vectorSize && shift.getLength() == this.vectorSize);
            long[] ret = new long[this.vectorSize];
            for (int i = 0; i < this.vectorSize; ++i) {
                long sh = shift.getValue(i);
                ret[i] = left.getValue(i) << (int)sh | right.getValue(i) >>> (int)(64L - sh);
            }
            return LLVMI64Vector.create(ret);
        }
    }

    @TypeSystemReference(value=LLVMTypesLongPointer.class)
    public static abstract class Fshl_I64
    extends LLVMFunnelShiftNode {
        @Specialization
        long doFshl(long left, long right, long shift) {
            return left << (int)shift | right >>> (int)(64L - shift);
        }

        @Specialization
        long doFshl(LLVMPointer left, LLVMPointer right, long shift, @Cached LLVMNativePointerSupport.ToNativePointerNode toNativePointerLeft, @Cached LLVMNativePointerSupport.ToNativePointerNode toNativePointerRight) {
            return this.doFshl(toNativePointerLeft.execute(left).asNative(), toNativePointerRight.execute(right).asNative(), shift);
        }
    }

    public static abstract class Fshl_I32Vector
    extends LLVMFunnelShiftNode {
        private final int vectorSize;

        Fshl_I32Vector(int vectorSize) {
            this.vectorSize = vectorSize;
        }

        @Specialization
        LLVMI32Vector doFshl(LLVMI32Vector left, LLVMI32Vector right, LLVMI32Vector shift) {
            assert (left.getLength() == this.vectorSize && right.getLength() == this.vectorSize && shift.getLength() == this.vectorSize);
            int[] ret = new int[this.vectorSize];
            for (int i = 0; i < this.vectorSize; ++i) {
                int sh = shift.getValue(i);
                ret[i] = left.getValue(i) << sh | right.getValue(i) >>> 32 - sh;
            }
            return LLVMI32Vector.create(ret);
        }
    }

    public static abstract class Fshl_I32
    extends LLVMFunnelShiftNode {
        @Specialization
        int doFshl(int left, int right, int shift) {
            return left << shift | right >>> 32 - shift;
        }
    }

    public static abstract class Fshl_I16Vector
    extends LLVMFunnelShiftNode {
        private final int vectorSize;

        Fshl_I16Vector(int vectorSize) {
            this.vectorSize = vectorSize;
        }

        @Specialization
        LLVMI16Vector doFshl(LLVMI16Vector left, LLVMI16Vector right, LLVMI16Vector shift) {
            assert (left.getLength() == this.vectorSize && right.getLength() == this.vectorSize && shift.getLength() == this.vectorSize);
            short[] ret = new short[this.vectorSize];
            for (int i = 0; i < this.vectorSize; ++i) {
                short sh = shift.getValue(i);
                ret[i] = (short)(left.getValue(i) << sh | (short)((right.getValue(i) & 0xFFFF) >>> 16 - sh));
            }
            return LLVMI16Vector.create(ret);
        }
    }

    public static abstract class Fshl_I16
    extends LLVMFunnelShiftNode {
        @Specialization
        short doFshl(short left, short right, short shift) {
            return (short)(left << shift | (short)((right & 0xFFFF) >>> 16 - shift));
        }
    }

    public static abstract class Fshl_I8Vector
    extends LLVMFunnelShiftNode {
        private final int vectorSize;

        Fshl_I8Vector(int vectorSize) {
            this.vectorSize = vectorSize;
        }

        @Specialization
        LLVMI8Vector doFshl(LLVMI8Vector left, LLVMI8Vector right, LLVMI8Vector shift) {
            assert (left.getLength() == this.vectorSize && right.getLength() == this.vectorSize && shift.getLength() == this.vectorSize);
            byte[] ret = new byte[this.vectorSize];
            for (int i = 0; i < this.vectorSize; ++i) {
                byte sh = shift.getValue(i);
                ret[i] = (byte)(left.getValue(i) << sh | (byte)((right.getValue(i) & 0xFF) >>> 8 - sh));
            }
            return LLVMI8Vector.create(ret);
        }
    }

    public static abstract class Fshl_I8
    extends LLVMFunnelShiftNode {
        @Specialization
        byte doFshl(byte left, byte right, byte shift) {
            return (byte)(left << shift | (byte)((right & 0xFF) >>> 8 - shift));
        }
    }
}

