/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMDoubleStoreNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMDoubleStoreNode
extends LLVMStoreNode {
    public abstract void executeWithTarget(LLVMPointer var1, double var2);

    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected void doOp(LLVMNativePointer addr, double value) {
        this.getLanguage().getLLVMMemory().putDouble((Node)this, addr, value);
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"})
    protected static void doOpDerefHandle(LLVMNativePointer addr, double value, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
        LLVMDoubleStoreNode.doOpManaged(getReceiver.execute(addr), value, nativeWrite);
    }

    @Specialization(limit="3")
    @GenerateAOT.Exclude
    protected static void doOpManaged(LLVMManagedPointer address, double value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
        nativeWrite.writeDouble(address.getObject(), address.getOffset(), value);
    }

    public static LLVMDoubleStoreNode create() {
        return LLVMDoubleStoreNodeGen.create(null, null);
    }

    @GenerateUncached
    public static abstract class LLVMDoubleOffsetStoreNode
    extends LLVMOffsetStoreNode {
        public static LLVMDoubleOffsetStoreNode create() {
            return LLVMDoubleStoreNodeGen.LLVMDoubleOffsetStoreNodeGen.create(null, null, null);
        }

        public static LLVMDoubleOffsetStoreNode create(LLVMExpressionNode value) {
            return LLVMDoubleStoreNodeGen.LLVMDoubleOffsetStoreNodeGen.create(null, null, value);
        }

        public abstract void executeWithTarget(LLVMPointer var1, long var2, double var4);

        @Specialization(guards={"!isAutoDerefHandle(addr)"})
        protected void doOp(LLVMNativePointer addr, long offset, double value) {
            this.getLanguage().getLLVMMemory().putDouble((Node)this, addr.asNative() + offset, value);
        }

        @Specialization(guards={"isAutoDerefHandle(addr)"})
        protected static void doOpDerefHandle(LLVMNativePointer addr, long offset, double value, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedWriteLibrary nativeWrite) {
            LLVMDoubleOffsetStoreNode.doOpManaged(getReceiver.execute(addr), offset, value, nativeWrite);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        protected static void doOpManaged(LLVMManagedPointer address, long offset, double value, @CachedLibrary(value="address.getObject()") LLVMManagedWriteLibrary nativeWrite) {
            nativeWrite.writeDouble(address.getObject(), address.getOffset() + offset, value);
        }
    }
}

