/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMOffsetLoadNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMI32LoadNode
extends LLVMLoadNode {
    public static LLVMI32LoadNode create() {
        return LLVMI32LoadNodeGen.create(null);
    }

    public abstract int executeWithTarget(Object var1);

    @Specialization(guards={"!isAutoDerefHandle(addr)"})
    protected int doI32Native(LLVMNativePointer addr) {
        return this.getLanguage().getLLVMMemory().getI32((Node)this, addr);
    }

    @Specialization(guards={"isAutoDerefHandle(addr)"})
    protected int doI32DerefHandle(LLVMNativePointer addr, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
        return this.doI32Managed(getReceiver.execute(addr), nativeRead);
    }

    @Specialization(limit="3")
    @GenerateAOT.Exclude
    protected int doI32Managed(LLVMManagedPointer addr, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
        return nativeRead.readI32(addr.getObject(), addr.getOffset());
    }

    @GenerateUncached
    public static abstract class LLVMI32OffsetLoadNode
    extends LLVMOffsetLoadNode {
        public static LLVMI32OffsetLoadNode create() {
            return LLVMI32LoadNodeGen.LLVMI32OffsetLoadNodeGen.create();
        }

        public abstract int executeWithTarget(LLVMPointer var1, long var2);

        @Specialization(guards={"!isAutoDerefHandle(addr)"})
        protected int doI32Native(LLVMNativePointer addr, long offset) {
            return this.getLanguage().getLLVMMemory().getI32((Node)this, addr.asNative() + offset);
        }

        @Specialization(guards={"isAutoDerefHandle(addr)"})
        protected int doI32DerefHandle(LLVMNativePointer addr, long offset, @Cached LLVMDerefHandleGetReceiverNode getReceiver, @CachedLibrary(limit="3") LLVMManagedReadLibrary nativeRead) {
            return this.doI32Managed(getReceiver.execute(addr), offset, nativeRead);
        }

        @Specialization(limit="3")
        @GenerateAOT.Exclude
        protected int doI32Managed(LLVMManagedPointer addr, long offset, @CachedLibrary(value="addr.getObject()") LLVMManagedReadLibrary nativeRead) {
            return nativeRead.readI32(addr.getObject(), addr.getOffset() + offset);
        }
    }
}

