/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.SlowPathException;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMCompareExchangeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI16LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI32LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI64LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMI8LoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMPointerLoadNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI1StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMAddressEqualsNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.Type;

@NodeChildren(value={@NodeChild(type=LLVMExpressionNode.class, value="address"), @NodeChild(type=LLVMExpressionNode.class, value="comparisonValue"), @NodeChild(type=LLVMExpressionNode.class, value="newValue")})
public abstract class LLVMCompareExchangeNode
extends LLVMExpressionNode {
    @Node.Child
    private LLVMCMPXCHInternalNode cmpxch;

    public static LLVMCompareExchangeNode create(LLVMExpressionNode resultAllocation, AggregateType returnType, DataLayout dataLayout, LLVMExpressionNode address, LLVMExpressionNode comparisonValue, LLVMExpressionNode newValue) throws Type.TypeOverflowException {
        long secondValueOffset = returnType.getOffsetOf(1L, dataLayout);
        return LLVMCompareExchangeNodeGen.create(resultAllocation, secondValueOffset, address, comparisonValue, newValue);
    }

    public LLVMCompareExchangeNode(LLVMExpressionNode resultAllocation, long secondValueOffset) {
        AllocResultNode allocResult = LLVMCompareExchangeNodeGen.AllocResultNodeGen.create(secondValueOffset, resultAllocation);
        this.cmpxch = LLVMCompareExchangeNodeGen.LLVMCMPXCHInternalNodeGen.create(allocResult);
    }

    @Specialization
    protected Object doOp(VirtualFrame frame, LLVMPointer address, Object comparisonValue, Object newValue) {
        return this.cmpxch.executeWithTarget(frame, address, comparisonValue, newValue);
    }

    static abstract class AllocResultNode
    extends LLVMNode {
        private final long secondValueOffset;
        @Node.Child
        LLVMExpressionNode resultAllocation;
        @Node.Child
        LLVMI1StoreNode.LLVMI1OffsetStoreNode successStore;

        protected abstract Object execute(VirtualFrame var1, Object var2, boolean var3);

        protected abstract Object execute(VirtualFrame var1, byte var2, boolean var3);

        protected abstract Object execute(VirtualFrame var1, short var2, boolean var3);

        protected abstract Object execute(VirtualFrame var1, int var2, boolean var3);

        protected abstract Object execute(VirtualFrame var1, long var2, boolean var4);

        AllocResultNode(long secondValueOffset, LLVMExpressionNode resultAllocation) {
            this.secondValueOffset = secondValueOffset;
            this.resultAllocation = resultAllocation;
            this.successStore = LLVMI1StoreNode.LLVMI1OffsetStoreNode.create();
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        LLVMPointer doByte(VirtualFrame frame, byte value, boolean success, @Cached LLVMI8StoreNode.LLVMI8OffsetStoreNode valueStore) throws UnexpectedResultException {
            LLVMPointer ret = this.resultAllocation.executeLLVMPointer(frame);
            valueStore.executeWithTarget(ret, 0L, value);
            this.successStore.executeWithTarget(ret, this.secondValueOffset, success);
            return ret;
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        LLVMPointer doShort(VirtualFrame frame, short value, boolean success, @Cached LLVMI16StoreNode.LLVMI16OffsetStoreNode valueStore) throws UnexpectedResultException {
            LLVMPointer ret = this.resultAllocation.executeLLVMPointer(frame);
            valueStore.executeWithTarget(ret, 0L, value);
            this.successStore.executeWithTarget(ret, this.secondValueOffset, success);
            return ret;
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        LLVMPointer doInt(VirtualFrame frame, int value, boolean success, @Cached LLVMI32StoreNode.LLVMI32OffsetStoreNode valueStore) throws UnexpectedResultException {
            LLVMPointer ret = this.resultAllocation.executeLLVMPointer(frame);
            valueStore.executeWithTarget(ret, 0L, value);
            this.successStore.executeWithTarget(ret, this.secondValueOffset, success);
            return ret;
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        LLVMPointer doLong(VirtualFrame frame, long value, boolean success, @Cached LLVMI64StoreNode.LLVMI64OffsetStoreNode valueStore) throws UnexpectedResultException {
            LLVMPointer ret = this.resultAllocation.executeLLVMPointer(frame);
            valueStore.executeWithTarget(ret, 0L, value);
            this.successStore.executeWithTarget(ret, this.secondValueOffset, success);
            return ret;
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        LLVMPointer doPointer(VirtualFrame frame, LLVMPointer value, boolean success, @Cached LLVMPointerStoreNode.LLVMPointerOffsetStoreNode valueStore) throws UnexpectedResultException {
            LLVMPointer ret = this.resultAllocation.executeLLVMPointer(frame);
            valueStore.executeWithTarget(ret, 0L, value);
            this.successStore.executeWithTarget(ret, this.secondValueOffset, success);
            return ret;
        }
    }

    static abstract class LLVMCMPXCHInternalNode
    extends LLVMNode {
        @Node.Child
        AllocResultNode allocResult;

        LLVMCMPXCHInternalNode(AllocResultNode allocResult) {
            this.allocResult = allocResult;
        }

        public abstract Object executeWithTarget(VirtualFrame var1, Object var2, Object var3, Object var4);

        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMNativePointer address, byte comparisonValue, byte newValue) {
            LLVMMemory memory = this.getLanguage().getLLVMMemory();
            LLVMMemory.CMPXCHGI8 compareAndSwapI8 = memory.compareAndSwapI8(this, address, comparisonValue, newValue);
            return this.allocResult.execute(frame, compareAndSwapI8.getValue(), compareAndSwapI8.isSwap());
        }

        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMNativePointer address, short comparisonValue, short newValue) {
            LLVMMemory memory = this.getLanguage().getLLVMMemory();
            LLVMMemory.CMPXCHGI16 compareAndSwapI16 = memory.compareAndSwapI16(this, address, comparisonValue, newValue);
            return this.allocResult.execute(frame, compareAndSwapI16.getValue(), compareAndSwapI16.isSwap());
        }

        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMNativePointer address, int comparisonValue, int newValue) {
            LLVMMemory memory = this.getLanguage().getLLVMMemory();
            LLVMMemory.CMPXCHGI32 compareAndSwapI32 = memory.compareAndSwapI32(this, address, comparisonValue, newValue);
            return this.allocResult.execute(frame, compareAndSwapI32.getValue(), compareAndSwapI32.isSwap());
        }

        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMNativePointer address, long comparisonValue, long newValue) {
            LLVMMemory memory = this.getLanguage().getLLVMMemory();
            LLVMMemory.CMPXCHGI64 compareAndSwapI64 = memory.compareAndSwapI64(this, address, comparisonValue, newValue);
            return this.allocResult.execute(frame, compareAndSwapI64.getValue(), compareAndSwapI64.isSwap());
        }

        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMNativePointer address, LLVMNativePointer comparisonValue, LLVMNativePointer newValue) {
            return this.doOp(frame, address, comparisonValue.asNative(), newValue.asNative());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMManagedPointer address, byte comparisonValue, byte newValue, @Cached LLVMI8LoadNode read, @Cached LLVMI8StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                boolean success;
                byte currentValue = read.executeWithTarget(address);
                boolean bl = success = currentValue == comparisonValue;
                if (success) {
                    write.executeWithTarget(address, newValue);
                }
                return this.allocResult.execute(frame, currentValue, success);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMManagedPointer address, short comparisonValue, short newValue, @Cached LLVMI16LoadNode read, @Cached LLVMI16StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                boolean success;
                short currentValue = read.executeWithTarget(address);
                boolean bl = success = currentValue == comparisonValue;
                if (success) {
                    write.executeWithTarget(address, newValue);
                }
                return this.allocResult.execute(frame, currentValue, success);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMManagedPointer address, int comparisonValue, int newValue, @Cached LLVMI32LoadNode read, @Cached LLVMI32StoreNode write) {
            Object object = address.getObject();
            synchronized (object) {
                boolean success;
                int currentValue = read.executeWithTarget(address);
                boolean bl = success = currentValue == comparisonValue;
                if (success) {
                    write.executeWithTarget(address, newValue);
                }
                return this.allocResult.execute(frame, currentValue, success);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(rewriteOn={RewriteException.class})
        protected Object doLong(VirtualFrame frame, LLVMManagedPointer address, long comparisonValue, long newValue, @Cached LLVMI64LoadNode read, @Cached LLVMI64StoreNode write) throws RewriteException {
            Object object = address.getObject();
            synchronized (object) {
                boolean success;
                long currentValue;
                try {
                    currentValue = read.executeWithTarget(address);
                }
                catch (UnexpectedResultException ex) {
                    throw new RewriteException();
                }
                boolean bl = success = currentValue == comparisonValue;
                if (success) {
                    write.executeWithTarget(address, newValue);
                }
                return this.allocResult.execute(frame, currentValue, success);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(replaces={"doLong"})
        protected Object doLongGeneric(VirtualFrame frame, LLVMManagedPointer address, long comparisonValue, long newValue, @Cached LLVMI64LoadNode read, @Cached LLVMI64StoreNode write, @Cached LLVMAddressEqualsNode cmp) {
            Object object = address.getObject();
            synchronized (object) {
                Object currentValue = read.executeWithTargetGeneric(address);
                boolean success = cmp.executeWithTarget(currentValue, comparisonValue);
                if (success) {
                    write.executeWithTarget(address, newValue);
                }
                return this.allocResult.execute(frame, currentValue, success);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        protected Object doOp(VirtualFrame frame, LLVMManagedPointer address, LLVMPointer comparisonValue, LLVMPointer newValue, @Cached LLVMPointerLoadNode read, @Cached LLVMPointerStoreNode write, @Cached LLVMAddressEqualsNode cmp) {
            Object object = address.getObject();
            synchronized (object) {
                LLVMPointer currentValue = read.executeWithTarget(address);
                boolean success = cmp.executeWithTarget(currentValue, comparisonValue);
                if (success) {
                    write.executeWithTarget(address, (Object)newValue);
                }
                return this.allocResult.execute(frame, currentValue, success);
            }
        }

        static class RewriteException
        extends SlowPathException {
            private static final long serialVersionUID = 1L;

            RewriteException() {
            }
        }
    }
}

