/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.LLVMReadStringNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.multithreading.LLVMThreadIntrinsics;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMThreadIntrinsics.class)
public final class LLVMThreadIntrinsicsFactory {

    @GeneratedBy(value=LLVMThreadIntrinsics.LLVMThreadGetName.class)
    public static final class LLVMThreadGetNameNodeGen
    extends LLVMThreadIntrinsics.LLVMThreadGetName
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode threadID_;
        @Node.Child
        private LLVMExpressionNode buffer_;
        @Node.Child
        private LLVMExpressionNode targetLen_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMThreadGetNameNodeGen(LLVMExpressionNode threadID, LLVMExpressionNode buffer, LLVMExpressionNode targetLen) {
            this.threadID_ = threadID;
            this.buffer_ = buffer;
            this.targetLen_ = targetLen;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            long targetLenValue_;
            long threadIDValue_;
            int state_0 = this.state_0_;
            try {
                threadIDValue_ = this.threadID_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object bufferValue = this.buffer_.executeGeneric(frameValue);
                Object targetLenValue = this.targetLen_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), bufferValue, targetLenValue);
            }
            Object bufferValue_ = this.buffer_.executeGeneric(frameValue);
            try {
                targetLenValue_ = this.targetLen_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(threadIDValue_, bufferValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(threadIDValue_, bufferValue_, targetLenValue_);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(bufferValue_)) {
                LLVMPointer bufferValue__ = LLVMTypes.asPointer(bufferValue_);
                return this.doIntrinsic(threadIDValue_, bufferValue__, targetLenValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(threadIDValue_, bufferValue_, targetLenValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            long targetLenValue_;
            long threadIDValue_;
            int state_0 = this.state_0_;
            try {
                threadIDValue_ = this.threadID_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object bufferValue = this.buffer_.executeGeneric(frameValue);
                Object targetLenValue = this.targetLen_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), bufferValue, targetLenValue);
            }
            Object bufferValue_ = this.buffer_.executeGeneric(frameValue);
            try {
                targetLenValue_ = this.targetLen_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(threadIDValue_, bufferValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(threadIDValue_, bufferValue_, targetLenValue_);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(bufferValue_)) {
                LLVMPointer bufferValue__ = LLVMTypes.asPointer(bufferValue_);
                return this.doIntrinsic(threadIDValue_, bufferValue__, targetLenValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(threadIDValue_, bufferValue_, targetLenValue_);
        }

        private int executeAndSpecialize(Object threadIDValue, Object bufferValue, Object targetLenValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (threadIDValue instanceof Long) {
                long threadIDValue_ = (Long)threadIDValue;
                if (LLVMTypes.isPointer(bufferValue)) {
                    LLVMPointer bufferValue_ = LLVMTypes.asPointer(bufferValue);
                    if (targetLenValue instanceof Long) {
                        long targetLenValue_ = (Long)targetLenValue;
                        this.state_0_ = state_0 |= 2;
                        return this.doIntrinsic(threadIDValue_, bufferValue_, targetLenValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.threadID_, this.buffer_, this.targetLen_}, new Object[]{threadIDValue, bufferValue, targetLenValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMThreadIntrinsics.LLVMThreadGetName create(LLVMExpressionNode threadID, LLVMExpressionNode buffer, LLVMExpressionNode targetLen) {
            return new LLVMThreadGetNameNodeGen(threadID, buffer, targetLen);
        }
    }

    @GeneratedBy(value=LLVMThreadIntrinsics.LLVMThreadSetName.class)
    public static final class LLVMThreadSetNameNodeGen
    extends LLVMThreadIntrinsics.LLVMThreadSetName
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode id_;
        @Node.Child
        private LLVMExpressionNode namePointer_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private LLVMReadStringNode readString_;

        private LLVMThreadSetNameNodeGen(LLVMExpressionNode id, LLVMExpressionNode namePointer) {
            this.id_ = id;
            this.namePointer_ = namePointer;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            long idValue_;
            int state_0 = this.state_0_;
            try {
                idValue_ = this.id_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object namePointerValue = this.namePointer_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), namePointerValue);
            }
            Object namePointerValue_ = this.namePointer_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(idValue_, namePointerValue_);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(namePointerValue_)) {
                LLVMPointer namePointerValue__ = LLVMTypes.asPointer(namePointerValue_);
                LLVMReadStringNode readString__ = this.readString_;
                if (readString__ != null) {
                    return this.doIntrinsic(idValue_, namePointerValue__, readString__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(idValue_, namePointerValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            long idValue_;
            int state_0 = this.state_0_;
            try {
                idValue_ = this.id_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object namePointerValue = this.namePointer_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), namePointerValue);
            }
            Object namePointerValue_ = this.namePointer_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(idValue_, namePointerValue_);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(namePointerValue_)) {
                LLVMPointer namePointerValue__ = LLVMTypes.asPointer(namePointerValue_);
                LLVMReadStringNode readString__ = this.readString_;
                if (readString__ != null) {
                    return this.doIntrinsic(idValue_, namePointerValue__, readString__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(idValue_, namePointerValue_);
        }

        private int executeAndSpecialize(Object idValue, Object namePointerValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (idValue instanceof Long) {
                long idValue_ = (Long)idValue;
                if (LLVMTypes.isPointer(namePointerValue)) {
                    LLVMPointer namePointerValue_ = LLVMTypes.asPointer(namePointerValue);
                    LLVMReadStringNode readString__ = (LLVMReadStringNode)this.insert(LLVMReadStringNodeGen.create());
                    Objects.requireNonNull(readString__, "Specialization 'doIntrinsic(long, LLVMPointer, LLVMReadStringNode)' cache 'readString' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.readString_ = readString__;
                    this.state_0_ = state_0 |= 2;
                    return this.doIntrinsic(idValue_, namePointerValue_, readString__);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.id_, this.namePointer_}, new Object[]{idValue, namePointerValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            LLVMReadStringNode readString__ = (LLVMReadStringNode)this.insert(LLVMReadStringNodeGen.create());
            Objects.requireNonNull(readString__, "Specialization 'doIntrinsic(long, LLVMPointer, LLVMReadStringNode)' cache 'readString' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.readString_ = readString__;
            assert (NodeUtil.assertRecursion((Node)this.readString_, (int)1));
            ((GenerateAOT.Provider)this.readString_).prepareForAOT(language, root);
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.readString_ = null;
        }

        @NeverDefault
        public static LLVMThreadIntrinsics.LLVMThreadSetName create(LLVMExpressionNode id, LLVMExpressionNode namePointer) {
            return new LLVMThreadSetNameNodeGen(id, namePointer);
        }
    }

    @GeneratedBy(value=LLVMThreadIntrinsics.LLVMThreadSelf.class)
    public static final class LLVMThreadSelfNodeGen
    extends LLVMThreadIntrinsics.LLVMThreadSelf
    implements GenerateAOT.Provider {
        private LLVMThreadSelfNodeGen() {
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return this.doIntrinsic();
        }

        @Override
        public long executeI64(VirtualFrame frameValue) {
            return this.doIntrinsic();
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        }

        @NeverDefault
        public static LLVMThreadIntrinsics.LLVMThreadSelf create() {
            return new LLVMThreadSelfNodeGen();
        }
    }

    @GeneratedBy(value=LLVMThreadIntrinsics.LLVMThreadJoin.class)
    public static final class LLVMThreadJoinNodeGen
    extends LLVMThreadIntrinsics.LLVMThreadJoin
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode threadId_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMThreadJoinNodeGen(LLVMExpressionNode threadId) {
            this.threadId_ = threadId;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            long threadIdValue_;
            int state_0 = this.state_0_;
            try {
                threadIdValue_ = this.threadId_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(threadIdValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doIntrinsic(threadIdValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(threadIdValue_);
        }

        private Object executeAndSpecialize(Object threadIdValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (threadIdValue instanceof Long) {
                long threadIdValue_ = (Long)threadIdValue;
                this.state_0_ = state_0 |= 2;
                return this.doIntrinsic(threadIdValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.threadId_}, new Object[]{threadIdValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMThreadIntrinsics.LLVMThreadJoin create(LLVMExpressionNode threadId) {
            return new LLVMThreadJoinNodeGen(threadId);
        }
    }

    @GeneratedBy(value=LLVMThreadIntrinsics.LLVMThreadSleep.class)
    public static final class LLVMThreadSleepNodeGen
    extends LLVMThreadIntrinsics.LLVMThreadSleep
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode millis_;
        @Node.Child
        private LLVMExpressionNode nanos_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMThreadSleepNodeGen(LLVMExpressionNode millis, LLVMExpressionNode nanos) {
            this.millis_ = millis;
            this.nanos_ = nanos;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int nanosValue_;
            long millisValue_;
            int state_0 = this.state_0_;
            try {
                millisValue_ = this.millis_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object nanosValue = this.nanos_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), nanosValue);
            }
            try {
                nanosValue_ = this.nanos_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(millisValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(millisValue_, nanosValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doSleep(millisValue_, nanosValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(millisValue_, nanosValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int nanosValue_;
            long millisValue_;
            int state_0 = this.state_0_;
            try {
                millisValue_ = this.millis_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object nanosValue = this.nanos_.executeGeneric(frameValue);
                return this.executeAndSpecialize(ex.getResult(), nanosValue);
            }
            try {
                nanosValue_ = this.nanos_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(millisValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(millisValue_, nanosValue_);
            }
            if ((state_0 & 2) != 0) {
                return this.doSleep(millisValue_, nanosValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(millisValue_, nanosValue_);
        }

        private int executeAndSpecialize(Object millisValue, Object nanosValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (millisValue instanceof Long) {
                long millisValue_ = (Long)millisValue;
                if (nanosValue instanceof Integer) {
                    int nanosValue_ = (Integer)nanosValue;
                    this.state_0_ = state_0 |= 2;
                    return this.doSleep(millisValue_, nanosValue_);
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.millis_, this.nanos_}, new Object[]{millisValue, nanosValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMThreadIntrinsics.LLVMThreadSleep create(LLVMExpressionNode millis, LLVMExpressionNode nanos) {
            return new LLVMThreadSleepNodeGen(millis, nanos);
        }
    }

    @GeneratedBy(value=LLVMThreadIntrinsics.LLVMThreadYield.class)
    public static final class LLVMThreadYieldNodeGen
    extends LLVMThreadIntrinsics.LLVMThreadYield
    implements GenerateAOT.Provider {
        private LLVMThreadYieldNodeGen() {
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            return this.doYield();
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        }

        @NeverDefault
        public static LLVMThreadIntrinsics.LLVMThreadYield create() {
            return new LLVMThreadYieldNodeGen();
        }
    }

    @GeneratedBy(value=LLVMThreadIntrinsics.LLVMThreadExit.class)
    public static final class LLVMThreadExitNodeGen
    extends LLVMThreadIntrinsics.LLVMThreadExit
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode retval_;

        private LLVMThreadExitNodeGen(LLVMExpressionNode retval) {
            this.retval_ = retval;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            Object retvalValue_ = this.retval_.executeGeneric(frameValue);
            return this.doIntrinsic(retvalValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            Object retvalValue_ = this.retval_.executeGeneric(frameValue);
            return this.doIntrinsic(retvalValue_);
        }

        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        }

        @NeverDefault
        public static LLVMThreadIntrinsics.LLVMThreadExit create(LLVMExpressionNode retval) {
            return new LLVMThreadExitNodeGen(retval);
        }
    }

    @GeneratedBy(value=LLVMThreadIntrinsics.LLVMThreadCreate.class)
    public static final class LLVMThreadCreateNodeGen
    extends LLVMThreadIntrinsics.LLVMThreadCreate
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode thread_;
        @Node.Child
        private LLVMExpressionNode startRoutine_;
        @Node.Child
        private LLVMExpressionNode arg_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @Node.Child
        private IntrinsicData intrinsic_cache;

        private LLVMThreadCreateNodeGen(LLVMExpressionNode thread, LLVMExpressionNode startRoutine, LLVMExpressionNode arg) {
            this.thread_ = thread;
            this.startRoutine_ = startRoutine;
            this.arg_ = arg;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object threadValue_ = this.thread_.executeGeneric(frameValue);
            Object startRoutineValue_ = this.startRoutine_.executeGeneric(frameValue);
            Object argValue_ = this.arg_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(threadValue_, startRoutineValue_, argValue_);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(threadValue_)) {
                LLVMPointer threadValue__ = LLVMTypes.asPointer(threadValue_);
                if (LLVMTypes.isPointer(startRoutineValue_)) {
                    LLVMPointer startRoutineValue__ = LLVMTypes.asPointer(startRoutineValue_);
                    if (LLVMTypes.isPointer(argValue_)) {
                        LLVMPointer argValue__ = LLVMTypes.asPointer(argValue_);
                        IntrinsicData s0_ = this.intrinsic_cache;
                        if (s0_ != null) {
                            return this.doIntrinsic(threadValue__, startRoutineValue__, argValue__, s0_.store_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(threadValue_, startRoutineValue_, argValue_);
        }

        @Override
        public int executeI32(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object threadValue_ = this.thread_.executeGeneric(frameValue);
            Object startRoutineValue_ = this.startRoutine_.executeGeneric(frameValue);
            Object argValue_ = this.arg_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(threadValue_, startRoutineValue_, argValue_);
            }
            if ((state_0 & 2) != 0 && LLVMTypes.isPointer(threadValue_)) {
                LLVMPointer threadValue__ = LLVMTypes.asPointer(threadValue_);
                if (LLVMTypes.isPointer(startRoutineValue_)) {
                    LLVMPointer startRoutineValue__ = LLVMTypes.asPointer(startRoutineValue_);
                    if (LLVMTypes.isPointer(argValue_)) {
                        LLVMPointer argValue__ = LLVMTypes.asPointer(argValue_);
                        IntrinsicData s0_ = this.intrinsic_cache;
                        if (s0_ != null) {
                            return this.doIntrinsic(threadValue__, startRoutineValue__, argValue__, s0_.store_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(threadValue_, startRoutineValue_, argValue_);
        }

        private int executeAndSpecialize(Object threadValue, Object startRoutineValue, Object argValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(threadValue)) {
                LLVMPointer threadValue_ = LLVMTypes.asPointer(threadValue);
                if (LLVMTypes.isPointer(startRoutineValue)) {
                    LLVMPointer startRoutineValue_ = LLVMTypes.asPointer(startRoutineValue);
                    if (LLVMTypes.isPointer(argValue)) {
                        LLVMPointer argValue_ = LLVMTypes.asPointer(argValue);
                        IntrinsicData s0_ = (IntrinsicData)this.insert(new IntrinsicData());
                        s0_.store_ = (LLVMI64StoreNode)s0_.insert(LLVMI64StoreNode.create());
                        VarHandle.storeStoreFence();
                        this.intrinsic_cache = s0_;
                        this.state_0_ = state_0 |= 2;
                        return this.doIntrinsic(threadValue_, startRoutineValue_, argValue_, s0_.store_);
                    }
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.thread_, this.startRoutine_, this.arg_}, new Object[]{threadValue, startRoutineValue, argValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 2) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            return NodeCost.MONOMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            IntrinsicData s0_ = (IntrinsicData)this.insert(new IntrinsicData());
            s0_.store_ = (LLVMI64StoreNode)s0_.insert(LLVMI64StoreNode.create());
            VarHandle.storeStoreFence();
            this.intrinsic_cache = s0_;
            assert (NodeUtil.assertRecursion((Node)s0_.store_, (int)1));
            ((GenerateAOT.Provider)s0_.store_).prepareForAOT(language, root);
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.intrinsic_cache = null;
        }

        @NeverDefault
        public static LLVMThreadIntrinsics.LLVMThreadCreate create(LLVMExpressionNode thread, LLVMExpressionNode startRoutine, LLVMExpressionNode arg) {
            return new LLVMThreadCreateNodeGen(thread, startRoutine, arg);
        }

        @GeneratedBy(value=LLVMThreadIntrinsics.LLVMThreadCreate.class)
        @DenyReplace
        private static final class IntrinsicData
        extends Node
        implements DSLSupport.SpecializationDataNode {
            @Node.Child
            LLVMI64StoreNode store_;

            IntrinsicData() {
            }

            public NodeCost getCost() {
                return NodeCost.NONE;
            }
        }
    }
}

