/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.va;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.library.GenerateLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.types.Type;

@GenerateLibrary(assertions=NoUncachedAssert.class)
@GenerateAOT
public abstract class LLVMVaListLibrary
extends Library {
    static final LibraryFactory<LLVMVaListLibrary> FACTORY = LibraryFactory.resolve(LLVMVaListLibrary.class);
    private static final Object STOP_ITERATE = new Object();

    public static LibraryFactory<LLVMVaListLibrary> getFactory() {
        return FACTORY;
    }

    public abstract void initialize(Object var1, Object[] var2, int var3, Frame var4);

    public abstract void cleanup(Object var1, Frame var2);

    public abstract void copy(Object var1, Object var2, Frame var3);

    public void copyWithoutFrame(Object srcVaList, Object destVaList) {
        Truffle.getRuntime().iterateFrames(frameInstance -> {
            this.copy(srcVaList, destVaList, frameInstance.getFrame(FrameInstance.FrameAccess.READ_WRITE));
            return STOP_ITERATE;
        });
    }

    public abstract Object shift(Object var1, Type var2, Frame var3);

    static class NoUncachedAssert
    extends LLVMVaListLibrary {
        @Node.Child
        private LLVMVaListLibrary delegate;
        private final boolean isUncachedDelegate;

        NoUncachedAssert(LLVMVaListLibrary delegate) {
            this.delegate = delegate;
            this.isUncachedDelegate = ((Object)((Object)delegate)).getClass().getName().contains("Uncached");
        }

        public boolean accepts(Object receiver) {
            return this.delegate.accepts(receiver);
        }

        @Override
        public void initialize(Object vaList, Object[] arguments, int numberOfExplicitArguments, Frame frame) {
            assert (frame == null || !this.isUncachedDelegate);
            this.delegate.initialize(vaList, arguments, numberOfExplicitArguments, frame);
        }

        @Override
        public void cleanup(Object vaList, Frame frame) {
            assert (frame == null || !this.isUncachedDelegate);
            this.delegate.cleanup(vaList, frame);
        }

        @Override
        public void copy(Object srcVaList, Object destVaList, Frame frame) {
            assert (frame == null || !this.isUncachedDelegate);
            this.delegate.copy(srcVaList, destVaList, frame);
        }

        @Override
        public void copyWithoutFrame(Object srcVaList, Object destVaList) {
            this.delegate.copyWithoutFrame(srcVaList, destVaList);
        }

        @Override
        public Object shift(Object vaList, Type type, Frame frame) {
            assert (frame == null || !this.isUncachedDelegate);
            return this.delegate.shift(vaList, type, frame);
        }
    }
}

