/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.handles;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.ValueProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMMemoryException;
import com.oracle.truffle.llvm.runtime.memory.LLVMHandleMemoryBase;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemory;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class GraalVMResolveHandle
extends LLVMIntrinsic {
    @Specialization
    protected LLVMManagedPointer doIntrinsic(Object rawHandle, @Cached LLVMToNativeNode forceAddressNode, @Cached ConditionProfile isDerefProfile, @Cached BranchProfile invalidHandle, @Cached(value="createClassProfile()") ValueProfile derefHandleContainerProfile, @Cached(value="createClassProfile()") ValueProfile handleContainerProfile) {
        long address = forceAddressNode.executeWithTarget(rawHandle).asNative();
        try {
            if (!this.getLanguage().getNoDerefHandleAssumption().isValid() && isDerefProfile.profile(LLVMHandleMemoryBase.isDerefHandleMemory(address))) {
                return ((LLVMMemory.HandleContainer)derefHandleContainerProfile.profile((Object)this.getContext().getDerefHandleContainer())).getValue(this, address).copy();
            }
            return ((LLVMMemory.HandleContainer)handleContainerProfile.profile((Object)this.getContext().getHandleContainer())).getValue(this, address).copy();
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException ex) {
            invalidHandle.enter();
            throw new LLVMMemoryException((Node)this, "Can't resolve invalid handle: %s", rawHandle);
        }
    }
}

