/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.handles;

import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.except.LLVMMemoryException;
import com.oracle.truffle.llvm.runtime.memory.LLVMHandleMemoryBase;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class GraalVMReleaseHandle
extends LLVMIntrinsic {
    @Specialization
    protected Object doIntrinsic(LLVMNativePointer handle) {
        long address = handle.asNative();
        if (!this.getLanguage().getNoDerefHandleAssumption().isValid() && LLVMHandleMemoryBase.isDerefHandleMemory(address)) {
            this.getContext().getDerefHandleContainer().free(this, address);
        } else {
            this.getContext().getHandleContainer().free(this, address);
        }
        return null;
    }

    @Fallback
    protected Object doFail(Object handle) {
        throw new LLVMMemoryException((Node)this, "Cannot release invalid handle.");
    }
}

