/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMSignal;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMSignal.class)
public final class LLVMSignalNodeGen
extends LLVMSignal
implements GenerateAOT.Provider {
    @Node.Child
    private LLVMExpressionNode signal_;
    @Node.Child
    private LLVMExpressionNode handler_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @Node.Child
    private SignalData signal_cache;

    private LLVMSignalNodeGen(LLVMExpressionNode signal, LLVMExpressionNode handler) {
        this.signal_ = signal;
        this.handler_ = handler;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int signalValue_;
        int state_0 = this.state_0_;
        try {
            signalValue_ = this.signal_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object handlerValue = this.handler_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), handlerValue);
        }
        Object handlerValue_ = this.handler_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(signalValue_, handlerValue_);
        }
        if ((state_0 & 2) != 0 && LLVMTypes.isPointer(handlerValue_)) {
            LLVMPointer handlerValue__ = LLVMTypes.asPointer(handlerValue_);
            SignalData s0_ = this.signal_cache;
            if (s0_ != null) {
                return this.doSignal(signalValue_, handlerValue__, s0_.toNative_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(signalValue_, handlerValue_);
    }

    private LLVMPointer executeAndSpecialize(Object signalValue, Object handlerValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (signalValue instanceof Integer) {
            int signalValue_ = (Integer)signalValue;
            if (LLVMTypes.isPointer(handlerValue)) {
                LLVMPointer handlerValue_ = LLVMTypes.asPointer(handlerValue);
                SignalData s0_ = (SignalData)this.insert(new SignalData());
                s0_.toNative_ = (LLVMToNativeNode)s0_.insert(LLVMToNativeNode.createToNativeWithTarget());
                VarHandle.storeStoreFence();
                this.signal_cache = s0_;
                this.state_0_ = state_0 |= 2;
                return this.doSignal(signalValue_, handlerValue_, s0_.toNative_);
            }
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.signal_, this.handler_}, new Object[]{signalValue, handlerValue});
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 2) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        return NodeCost.MONOMORPHIC;
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        SignalData s0_ = (SignalData)this.insert(new SignalData());
        s0_.toNative_ = (LLVMToNativeNode)s0_.insert(LLVMToNativeNode.createToNativeWithTarget());
        VarHandle.storeStoreFence();
        this.signal_cache = s0_;
        assert (NodeUtil.assertRecursion((Node)s0_.toNative_, (int)1));
        ((GenerateAOT.Provider)s0_.toNative_).prepareForAOT(language, root);
        this.state_0_ |= 2;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
        this.signal_cache = null;
    }

    @NeverDefault
    public static LLVMSignal create(LLVMExpressionNode signal, LLVMExpressionNode handler) {
        return new LLVMSignalNodeGen(signal, handler);
    }

    @GeneratedBy(value=LLVMSignal.class)
    @DenyReplace
    private static final class SignalData
    extends Node
    implements DSLSupport.SpecializationDataNode {
        @Node.Child
        LLVMToNativeNode toNative_;

        SignalData() {
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }
}

