/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class LLVMCTypeIntrinsics
extends LLVMIntrinsic {
    public static boolean isLowercaseLetter(int value) {
        return value >= 97 && value <= 122;
    }

    public static boolean isUppercaseLetter(int value) {
        return value >= 65 && value <= 90;
    }

    public static boolean isAsciiCharacter(int value) {
        return value >= 0 && value < 128;
    }

    public static abstract class LLVMIsupper
    extends LLVMCTypeIntrinsics {
        @Specialization(guards={"isLowercaseLetter(value)"})
        protected int fromLower(int value) {
            return 0;
        }

        @Specialization(guards={"isUppercaseLetter(value)"})
        protected int fromUpper(int value) {
            return 1;
        }

        @Specialization(guards={"isAsciiCharacter(value)"})
        protected int fromCharacter(int value) {
            if (LLVMIsupper.isUppercaseLetter(value)) {
                return 1;
            }
            return 0;
        }

        @Specialization(replaces={"fromLower", "fromUpper", "fromCharacter"})
        @CompilerDirectives.TruffleBoundary
        protected int doIntrinsic(int value) {
            return Character.isUpperCase(value) ? 1 : 0;
        }
    }

    public static abstract class LLVMIsspace
    extends LLVMCTypeIntrinsics {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected int doIntrinsic(int value) {
            return Character.isWhitespace(value) ? 1 : 0;
        }
    }

    public static abstract class LLVMIsalpha
    extends LLVMCTypeIntrinsics {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected int doIntrinsic(int value) {
            return Character.isAlphabetic(value) ? 1 : 0;
        }
    }

    public static abstract class LLVMTolower
    extends LLVMCTypeIntrinsics {
        @Specialization(guards={"isLowercaseLetter(value)"})
        protected int fromLower(int value) {
            return value;
        }

        @Specialization(guards={"isUppercaseLetter(value)"})
        protected int fromUpper(int value) {
            return value + 32;
        }

        @Specialization(guards={"isAsciiCharacter(value)"})
        protected int fromCharacter(int value) {
            if (LLVMTolower.isUppercaseLetter(value)) {
                return this.fromUpper(value);
            }
            return value;
        }

        @Specialization(replaces={"fromLower", "fromUpper", "fromCharacter"})
        @CompilerDirectives.TruffleBoundary
        protected int doIntrinsic(int value) {
            return Character.toLowerCase(value);
        }
    }

    public static abstract class LLVMToUpper
    extends LLVMCTypeIntrinsics {
        @Specialization(guards={"isLowercaseLetter(value)"})
        protected int fromLower(int value) {
            return value - 32;
        }

        @Specialization(guards={"isUppercaseLetter(value)"})
        protected int fromUpper(int value) {
            return value;
        }

        @Specialization(guards={"isAsciiCharacter(value)"})
        protected int fromCharacter(int value) {
            if (LLVMToUpper.isLowercaseLetter(value)) {
                return this.fromLower(value);
            }
            return value;
        }

        @Specialization(replaces={"fromLower", "fromUpper", "fromCharacter"})
        @CompilerDirectives.TruffleBoundary
        protected int doIntrinsic(int value) {
            return Character.toUpperCase(value);
        }
    }
}

