/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.cast.LLVMToI64Node;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMToI64Node.class)
public final class LLVMToI64NodeGen
extends LLVMToI64Node
implements GenerateAOT.Provider {
    @Node.Child
    private LLVMExpressionNode fromNode_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private LLVMToI64NodeGen(LLVMExpressionNode fromNode) {
        this.fromNode_ = fromNode;
    }

    @Override
    public Object executeWithTarget(Object fromNodeValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(fromNodeValue);
        }
        if ((state_0 & 6) != 0) {
            if ((state_0 & 2) != 0 && LLVMTypes.isNativePointer(fromNodeValue)) {
                LLVMNativePointer fromNodeValue_ = LLVMTypes.asNativePointer(fromNodeValue);
                return this.doNative(fromNodeValue_);
            }
            if ((state_0 & 4) != 0 && LLVMTypes.isManagedPointer(fromNodeValue)) {
                LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                return this.doManaged(fromNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(fromNodeValue);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(fromNodeValue_);
        }
        if ((state_0 & 6) != 0) {
            if ((state_0 & 2) != 0 && LLVMTypes.isNativePointer(fromNodeValue_)) {
                LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
                return this.doNative(fromNodeValue__);
            }
            if ((state_0 & 4) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                return this.doManaged(fromNodeValue__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(fromNodeValue_);
    }

    @Override
    public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 4) != 0) {
            return LLVMTypesGen.expectLong(this.executeGeneric(frameValue));
        }
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
        }
        if ((state_0 & 2) != 0 && LLVMTypes.isNativePointer(fromNodeValue_)) {
            LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
            return this.doNative(fromNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
    }

    private Object executeAndSpecialize(Object fromNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isNativePointer(fromNodeValue)) {
            LLVMNativePointer fromNodeValue_ = LLVMTypes.asNativePointer(fromNodeValue);
            this.state_0_ = state_0 |= 2;
            return this.doNative(fromNodeValue_);
        }
        if (LLVMTypes.isManagedPointer(fromNodeValue)) {
            LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
            this.state_0_ = state_0 |= 4;
            return this.doManaged(fromNodeValue_);
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
    }

    public NodeCost getCost() {
        int state_0 = this.state_0_;
        if ((state_0 & 6) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state_0 & 6 & (state_0 & 6) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ |= 2;
        this.state_0_ |= 4;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMToI64Node create(LLVMExpressionNode fromNode) {
        return new LLVMToI64NodeGen(fromNode);
    }

    @GeneratedBy(value=LLVMToI64Node.LLVMBitcastToI64Node.class)
    public static final class LLVMBitcastToI64NodeGen
    extends LLVMToI64Node.LLVMBitcastToI64Node
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMBitcastToI64NodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        public Object executeWithTarget(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0xFFE) != 0) {
                if ((state_0 & 2) != 0 && LLVMTypes.isNativePointer(fromNodeValue)) {
                    LLVMNativePointer fromNodeValue_ = LLVMTypes.asNativePointer(fromNodeValue);
                    return this.doNative(fromNodeValue_);
                }
                if ((state_0 & 4) != 0 && LLVMTypes.isManagedPointer(fromNodeValue)) {
                    LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                    return this.doManaged(fromNodeValue_);
                }
                if ((state_0 & 8) != 0 && fromNodeValue instanceof Double) {
                    double fromNodeValue_ = (Double)fromNodeValue;
                    return this.doI64(fromNodeValue_);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue instanceof Long) {
                    long fromNodeValue_ = (Long)fromNodeValue;
                    return this.doI64(fromNodeValue_);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                    return this.doI1Vector(fromNodeValue_);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                    return this.doI8Vector(fromNodeValue_);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                    return this.doI16Vector(fromNodeValue_);
                }
                if ((state_0 & 0x100) != 0 && fromNodeValue instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                    return this.doI32Vector(fromNodeValue_);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue instanceof LLVMFloatVector) {
                    LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                    return this.doFloatVector(fromNodeValue_);
                }
                if ((state_0 & 0x400) != 0 && fromNodeValue instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                    return this.doI64Vector(fromNodeValue_);
                }
                if ((state_0 & 0x800) != 0 && fromNodeValue instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                    return this.doDoubleVector(fromNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFF6) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeGeneric_double0(state_0, frameValue);
            }
            if ((state_0 & 0xFEE) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeGeneric_long1(state_0, frameValue);
            }
            return this.executeGeneric_generic2(state_0, frameValue);
        }

        private Object executeGeneric_double0(int state_0__, VirtualFrame frameValue) {
            double fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 8) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue) {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x10) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0xFFE) != 0) {
                if ((state_0 & 2) != 0 && LLVMTypes.isNativePointer(fromNodeValue_)) {
                    LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
                    return this.doNative(fromNodeValue__);
                }
                if ((state_0 & 4) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    return this.doManaged(fromNodeValue__);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (Double)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (Long)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                    return this.doI1Vector(fromNodeValue__);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                    return this.doI8Vector(fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                    return this.doI16Vector(fromNodeValue__);
                }
                if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                    return this.doI32Vector(fromNodeValue__);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                    return this.doFloatVector(fromNodeValue__);
                }
                if ((state_0 & 0x400) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                    return this.doI64Vector(fromNodeValue__);
                }
                if ((state_0 & 0x800) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                    return this.doDoubleVector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 4) != 0) {
                return LLVMTypesGen.expectLong(this.executeGeneric(frameValue));
            }
            if ((state_0 & 0xFF2) == 0 && (state_0 & 0xFFA) != 0) {
                return this.executeI64_double3(state_0, frameValue);
            }
            if ((state_0 & 0xFEA) == 0 && (state_0 & 0xFFA) != 0) {
                return this.executeI64_long4(state_0, frameValue);
            }
            return this.executeI64_generic5(state_0, frameValue);
        }

        private long executeI64_double3(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            double fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
            }
            assert ((state_0 & 8) != 0);
            return this.doI64(fromNodeValue_);
        }

        private long executeI64_long4(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
            }
            assert ((state_0 & 0x10) != 0);
            return this.doI64(fromNodeValue_);
        }

        private long executeI64_generic5(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
            }
            if ((state_0 & 0xFFA) != 0) {
                if ((state_0 & 2) != 0 && LLVMTypes.isNativePointer(fromNodeValue_)) {
                    LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
                    return this.doNative(fromNodeValue__);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (Double)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (Long)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector)fromNodeValue_;
                    return this.doI1Vector(fromNodeValue__);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector)fromNodeValue_;
                    return this.doI8Vector(fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector)fromNodeValue_;
                    return this.doI16Vector(fromNodeValue__);
                }
                if ((state_0 & 0x100) != 0 && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector)fromNodeValue_;
                    return this.doI32Vector(fromNodeValue__);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector fromNodeValue__ = (LLVMFloatVector)fromNodeValue_;
                    return this.doFloatVector(fromNodeValue__);
                }
                if ((state_0 & 0x400) != 0 && fromNodeValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector fromNodeValue__ = (LLVMI64Vector)fromNodeValue_;
                    return this.doI64Vector(fromNodeValue__);
                }
                if ((state_0 & 0x800) != 0 && fromNodeValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector fromNodeValue__ = (LLVMDoubleVector)fromNodeValue_;
                    return this.doDoubleVector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
        }

        private Object executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(fromNodeValue)) {
                LLVMNativePointer fromNodeValue_ = LLVMTypes.asNativePointer(fromNodeValue);
                this.state_0_ = state_0 |= 2;
                return this.doNative(fromNodeValue_);
            }
            if (LLVMTypes.isManagedPointer(fromNodeValue)) {
                LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                this.state_0_ = state_0 |= 4;
                return this.doManaged(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (Double)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (Long)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doI1Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doI8Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.doI16Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x100;
                return this.doI32Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x200;
                return this.doFloatVector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI64Vector) {
                LLVMI64Vector fromNodeValue_ = (LLVMI64Vector)fromNodeValue;
                this.state_0_ = state_0 |= 0x400;
                return this.doI64Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector fromNodeValue_ = (LLVMDoubleVector)fromNodeValue;
                this.state_0_ = state_0 |= 0x800;
                return this.doDoubleVector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFFE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0xFFE & (state_0 & 0xFFE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            this.state_0_ |= 0x100;
            this.state_0_ |= 0x200;
            this.state_0_ |= 0x400;
            this.state_0_ |= 0x800;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMToI64Node.LLVMBitcastToI64Node create(LLVMExpressionNode fromNode) {
            return new LLVMBitcastToI64NodeGen(fromNode);
        }
    }

    @GeneratedBy(value=LLVMToI64Node.LLVMUnsignedCastToI64Node.class)
    public static final class LLVMUnsignedCastToI64NodeGen
    extends LLVMToI64Node.LLVMUnsignedCastToI64Node
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile float_profile_;
        @CompilerDirectives.CompilationFinal
        private ConditionProfile double_profile_;

        private LLVMUnsignedCastToI64NodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        public Object executeWithTarget(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0xFFE) != 0) {
                if ((state_0 & 2) != 0 && LLVMTypes.isNativePointer(fromNodeValue)) {
                    LLVMNativePointer fromNodeValue_ = LLVMTypes.asNativePointer(fromNodeValue);
                    return this.doNative(fromNodeValue_);
                }
                if ((state_0 & 4) != 0 && LLVMTypes.isManagedPointer(fromNodeValue)) {
                    LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                    return this.doManaged(fromNodeValue_);
                }
                if ((state_0 & 8) != 0 && fromNodeValue instanceof Boolean) {
                    boolean fromNodeValue_ = (Boolean)fromNodeValue;
                    return this.doI1(fromNodeValue_);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue instanceof Byte) {
                    byte fromNodeValue_ = (Byte)fromNodeValue;
                    return this.doI8(fromNodeValue_);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue instanceof Short) {
                    short fromNodeValue_ = (Short)fromNodeValue;
                    return this.doI16(fromNodeValue_);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue instanceof Integer) {
                    int fromNodeValue_ = (Integer)fromNodeValue;
                    return this.doI32(fromNodeValue_);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue instanceof Long) {
                    long fromNodeValue_ = (Long)fromNodeValue;
                    return this.doI64(fromNodeValue_);
                }
                if ((state_0 & 0x100) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0x7000) >>> 12, fromNodeValue)) {
                    LLVMIVarBit fromNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0x7000) >>> 12, fromNodeValue);
                    return this.doIVarBit(fromNodeValue_);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue instanceof Float) {
                    float fromNodeValue_ = ((Float)fromNodeValue).floatValue();
                    ConditionProfile profile__ = this.float_profile_;
                    if (profile__ != null) {
                        return this.doFloat(fromNodeValue_, profile__);
                    }
                }
                if ((state_0 & 0x400) != 0 && fromNodeValue instanceof Double) {
                    double fromNodeValue_ = (Double)fromNodeValue;
                    ConditionProfile profile__1 = this.double_profile_;
                    if (profile__1 != null) {
                        return this.doDouble(fromNodeValue_, profile__1);
                    }
                }
                if ((state_0 & 0x800) != 0 && fromNodeValue instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                    return this.do80LLVMBitFloat(fromNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFF6) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeGeneric_boolean0(state_0, frameValue);
            }
            if ((state_0 & 0xFEE) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeGeneric_byte1(state_0, frameValue);
            }
            if ((state_0 & 0xFDE) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeGeneric_short2(state_0, frameValue);
            }
            if ((state_0 & 0xFBE) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeGeneric_int3(state_0, frameValue);
            }
            if ((state_0 & 0xF7E) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeGeneric_long4(state_0, frameValue);
            }
            if ((state_0 & 0xDFE) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeGeneric_float5(state_0, frameValue);
            }
            if ((state_0 & 0xBFE) == 0 && (state_0 & 0xFFE) != 0) {
                return this.executeGeneric_double6(state_0, frameValue);
            }
            return this.executeGeneric_generic7(state_0, frameValue);
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            boolean fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 8) != 0);
            return this.doI1(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            byte fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x10) != 0);
            return this.doI8(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            short fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x20) != 0);
            return this.doI16(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x40) != 0);
            return this.doI32(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x80) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_float5(int state_0__, VirtualFrame frameValue) {
            float fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(Float.valueOf(fromNodeValue_));
            }
            assert ((state_0 & 0x200) != 0);
            ConditionProfile profile__ = this.float_profile_;
            if (profile__ != null) {
                return this.doFloat(fromNodeValue_, profile__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(Float.valueOf(fromNodeValue_));
        }

        private Object executeGeneric_double6(int state_0__, VirtualFrame frameValue) {
            double fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x400) != 0);
            ConditionProfile profile__1 = this.double_profile_;
            if (profile__1 != null) {
                return this.doDouble(fromNodeValue_, profile__1);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        private Object executeGeneric_generic7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0xFFE) != 0) {
                if ((state_0 & 2) != 0 && LLVMTypes.isNativePointer(fromNodeValue_)) {
                    LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
                    return this.doNative(fromNodeValue__);
                }
                if ((state_0 & 4) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    return this.doManaged(fromNodeValue__);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (Boolean)fromNodeValue_;
                    return this.doI1(fromNodeValue__);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (Byte)fromNodeValue_;
                    return this.doI8(fromNodeValue__);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (Short)fromNodeValue_;
                    return this.doI16(fromNodeValue__);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (Integer)fromNodeValue_;
                    return this.doI32(fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (Long)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x100) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0x7000) >>> 12, fromNodeValue_)) {
                    LLVMIVarBit fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0x7000) >>> 12, fromNodeValue_);
                    return this.doIVarBit(fromNodeValue__);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = ((Float)fromNodeValue_).floatValue();
                    ConditionProfile profile__ = this.float_profile_;
                    if (profile__ != null) {
                        return this.doFloat(fromNodeValue__, profile__);
                    }
                }
                if ((state_0 & 0x400) != 0 && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (Double)fromNodeValue_;
                    ConditionProfile profile__1 = this.double_profile_;
                    if (profile__1 != null) {
                        return this.doDouble(fromNodeValue__, profile__1);
                    }
                }
                if ((state_0 & 0x800) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                    return this.do80LLVMBitFloat(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 4) != 0) {
                return LLVMTypesGen.expectLong(this.executeGeneric(frameValue));
            }
            if ((state_0 & 0xFF2) == 0 && (state_0 & 0xFFA) != 0) {
                return this.executeI64_boolean8(state_0, frameValue);
            }
            if ((state_0 & 0xFEA) == 0 && (state_0 & 0xFFA) != 0) {
                return this.executeI64_byte9(state_0, frameValue);
            }
            if ((state_0 & 0xFDA) == 0 && (state_0 & 0xFFA) != 0) {
                return this.executeI64_short10(state_0, frameValue);
            }
            if ((state_0 & 0xFBA) == 0 && (state_0 & 0xFFA) != 0) {
                return this.executeI64_int11(state_0, frameValue);
            }
            if ((state_0 & 0xF7A) == 0 && (state_0 & 0xFFA) != 0) {
                return this.executeI64_long12(state_0, frameValue);
            }
            if ((state_0 & 0xDFA) == 0 && (state_0 & 0xFFA) != 0) {
                return this.executeI64_float13(state_0, frameValue);
            }
            if ((state_0 & 0xBFA) == 0 && (state_0 & 0xFFA) != 0) {
                return this.executeI64_double14(state_0, frameValue);
            }
            return this.executeI64_generic15(state_0, frameValue);
        }

        private long executeI64_boolean8(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            boolean fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
            }
            assert ((state_0 & 8) != 0);
            return this.doI1(fromNodeValue_);
        }

        private long executeI64_byte9(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            byte fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
            }
            assert ((state_0 & 0x10) != 0);
            return this.doI8(fromNodeValue_);
        }

        private long executeI64_short10(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            short fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
            }
            assert ((state_0 & 0x20) != 0);
            return this.doI16(fromNodeValue_);
        }

        private long executeI64_int11(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
            }
            assert ((state_0 & 0x40) != 0);
            return this.doI32(fromNodeValue_);
        }

        private long executeI64_long12(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
            }
            assert ((state_0 & 0x80) != 0);
            return this.doI64(fromNodeValue_);
        }

        private long executeI64_float13(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            float fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(Float.valueOf(fromNodeValue_)));
            }
            assert ((state_0 & 0x200) != 0);
            ConditionProfile profile__ = this.float_profile_;
            if (profile__ != null) {
                return this.doFloat(fromNodeValue_, profile__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(Float.valueOf(fromNodeValue_)));
        }

        private long executeI64_double14(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            double fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
            }
            assert ((state_0 & 0x400) != 0);
            ConditionProfile profile__1 = this.double_profile_;
            if (profile__1 != null) {
                return this.doDouble(fromNodeValue_, profile__1);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
        }

        private long executeI64_generic15(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
            }
            if ((state_0 & 0xFFA) != 0) {
                if ((state_0 & 2) != 0 && LLVMTypes.isNativePointer(fromNodeValue_)) {
                    LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
                    return this.doNative(fromNodeValue__);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (Boolean)fromNodeValue_;
                    return this.doI1(fromNodeValue__);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (Byte)fromNodeValue_;
                    return this.doI8(fromNodeValue__);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (Short)fromNodeValue_;
                    return this.doI16(fromNodeValue__);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (Integer)fromNodeValue_;
                    return this.doI32(fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (Long)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x100) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0x7000) >>> 12, fromNodeValue_)) {
                    LLVMIVarBit fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0x7000) >>> 12, fromNodeValue_);
                    return this.doIVarBit(fromNodeValue__);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = ((Float)fromNodeValue_).floatValue();
                    ConditionProfile profile__ = this.float_profile_;
                    if (profile__ != null) {
                        return this.doFloat(fromNodeValue__, profile__);
                    }
                }
                if ((state_0 & 0x400) != 0 && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (Double)fromNodeValue_;
                    ConditionProfile profile__1 = this.double_profile_;
                    if (profile__1 != null) {
                        return this.doDouble(fromNodeValue__, profile__1);
                    }
                }
                if ((state_0 & 0x800) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                    return this.do80LLVMBitFloat(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
        }

        private Object executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(fromNodeValue)) {
                LLVMNativePointer fromNodeValue_ = LLVMTypes.asNativePointer(fromNodeValue);
                this.state_0_ = state_0 |= 2;
                return this.doNative(fromNodeValue_);
            }
            if (LLVMTypes.isManagedPointer(fromNodeValue)) {
                LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                this.state_0_ = state_0 |= 4;
                return this.doManaged(fromNodeValue_);
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (Boolean)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI1(fromNodeValue_);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (Byte)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (Short)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (Integer)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (Long)fromNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.doI64(fromNodeValue_);
            }
            int lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(fromNodeValue);
            if (lLVMIVarBitCast0 != 0) {
                LLVMIVarBit fromNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, fromNodeValue);
                state_0 |= lLVMIVarBitCast0 << 12;
                this.state_0_ = state_0 |= 0x100;
                return this.doIVarBit(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = ((Float)fromNodeValue).floatValue();
                ConditionProfile profile__ = ConditionProfile.create();
                Objects.requireNonNull(profile__, "Specialization 'doFloat(float, ConditionProfile)' cache 'profile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.float_profile_ = profile__;
                this.state_0_ = state_0 |= 0x200;
                return this.doFloat(fromNodeValue_, profile__);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (Double)fromNodeValue;
                ConditionProfile profile__1 = ConditionProfile.create();
                Objects.requireNonNull(profile__1, "Specialization 'doDouble(double, ConditionProfile)' cache 'profile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.double_profile_ = profile__1;
                this.state_0_ = state_0 |= 0x400;
                return this.doDouble(fromNodeValue_, profile__1);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                this.state_0_ = state_0 |= 0x800;
                return this.do80LLVMBitFloat(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0xFFE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0xFFE & (state_0 & 0xFFE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            this.state_0_ |= 0x100;
            ConditionProfile profile__ = ConditionProfile.create();
            Objects.requireNonNull(profile__, "Specialization 'doFloat(float, ConditionProfile)' cache 'profile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.float_profile_ = profile__;
            this.float_profile_.disable();
            this.state_0_ |= 0x200;
            ConditionProfile profile__1 = ConditionProfile.create();
            Objects.requireNonNull(profile__1, "Specialization 'doDouble(double, ConditionProfile)' cache 'profile' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
            VarHandle.storeStoreFence();
            this.double_profile_ = profile__1;
            this.double_profile_.disable();
            this.state_0_ |= 0x400;
            this.state_0_ |= 0x800;
            int state_0 = this.state_0_;
            state_0 |= 1;
            this.state_0_ = state_0 |= 0x7000;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
            this.float_profile_.reset();
            this.double_profile_.reset();
        }

        @NeverDefault
        public static LLVMToI64Node.LLVMUnsignedCastToI64Node create(LLVMExpressionNode fromNode) {
            return new LLVMUnsignedCastToI64NodeGen(fromNode);
        }
    }

    @GeneratedBy(value=LLVMToI64Node.LLVMSignedCastToI64Node.class)
    public static final class LLVMSignedCastToI64NodeGen
    extends LLVMToI64Node.LLVMSignedCastToI64Node
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode fromNode_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMSignedCastToI64NodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        @Override
        public Object executeWithTarget(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0x1FFE) != 0) {
                if ((state_0 & 2) != 0 && LLVMTypes.isNativePointer(fromNodeValue)) {
                    LLVMNativePointer fromNodeValue_ = LLVMTypes.asNativePointer(fromNodeValue);
                    return this.doNative(fromNodeValue_);
                }
                if ((state_0 & 4) != 0 && LLVMTypes.isManagedPointer(fromNodeValue)) {
                    LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                    return this.doManaged(fromNodeValue_);
                }
                if ((state_0 & 8) != 0 && fromNodeValue instanceof Boolean) {
                    boolean fromNodeValue_ = (Boolean)fromNodeValue;
                    return this.doI64(fromNodeValue_);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue instanceof Byte) {
                    byte fromNodeValue_ = (Byte)fromNodeValue;
                    return this.doI64(fromNodeValue_);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue instanceof Short) {
                    short fromNodeValue_ = (Short)fromNodeValue;
                    return this.doI64(fromNodeValue_);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue instanceof Integer) {
                    int fromNodeValue_ = (Integer)fromNodeValue;
                    return this.doI64(fromNodeValue_);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue instanceof Long) {
                    long fromNodeValue_ = (Long)fromNodeValue;
                    return this.doI64(fromNodeValue_);
                }
                if ((state_0 & 0x100) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0xE000) >>> 13, fromNodeValue)) {
                    LLVMIVarBit fromNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0xE000) >>> 13, fromNodeValue);
                    return this.doI64(fromNodeValue_);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue instanceof Float) {
                    float fromNodeValue_ = ((Float)fromNodeValue).floatValue();
                    return this.doI64(fromNodeValue_);
                }
                if ((state_0 & 0x400) != 0 && fromNodeValue instanceof Double) {
                    double fromNodeValue_ = (Double)fromNodeValue;
                    return this.doI64(fromNodeValue_);
                }
                if ((state_0 & 0x800) != 0 && fromNodeValue instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                    return this.doI64(fromNodeValue_);
                }
                if ((state_0 & 0x1000) != 0 && fromNodeValue instanceof LLVM128BitFloat) {
                    LLVM128BitFloat fromNodeValue_ = (LLVM128BitFloat)fromNodeValue;
                    return this.doI64(fromNodeValue_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FF6) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_boolean0(state_0, frameValue);
            }
            if ((state_0 & 0x1FEE) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_byte1(state_0, frameValue);
            }
            if ((state_0 & 0x1FDE) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_short2(state_0, frameValue);
            }
            if ((state_0 & 0x1FBE) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_int3(state_0, frameValue);
            }
            if ((state_0 & 0x1F7E) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_long4(state_0, frameValue);
            }
            if ((state_0 & 0x1DFE) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_float5(state_0, frameValue);
            }
            if ((state_0 & 0x1BFE) == 0 && (state_0 & 0x1FFE) != 0) {
                return this.executeGeneric_double6(state_0, frameValue);
            }
            return this.executeGeneric_generic7(state_0, frameValue);
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            boolean fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 8) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            byte fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x10) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            short fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x20) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x40) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x80) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_float5(int state_0__, VirtualFrame frameValue) {
            float fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(Float.valueOf(fromNodeValue_));
            }
            assert ((state_0 & 0x200) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_double6(int state_0__, VirtualFrame frameValue) {
            double fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            assert ((state_0 & 0x400) != 0);
            return this.doI64(fromNodeValue_);
        }

        private Object executeGeneric_generic7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return this.executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0x1FFE) != 0) {
                if ((state_0 & 2) != 0 && LLVMTypes.isNativePointer(fromNodeValue_)) {
                    LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
                    return this.doNative(fromNodeValue__);
                }
                if ((state_0 & 4) != 0 && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    return this.doManaged(fromNodeValue__);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (Boolean)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (Byte)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (Short)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (Integer)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (Long)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x100) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0xE000) >>> 13, fromNodeValue_)) {
                    LLVMIVarBit fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0xE000) >>> 13, fromNodeValue_);
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = ((Float)fromNodeValue_).floatValue();
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x400) != 0 && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (Double)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x800) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x1000) != 0 && fromNodeValue_ instanceof LLVM128BitFloat) {
                    LLVM128BitFloat fromNodeValue__ = (LLVM128BitFloat)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 4) != 0) {
                return LLVMTypesGen.expectLong(this.executeGeneric(frameValue));
            }
            if ((state_0 & 0x1FF2) == 0 && (state_0 & 0x1FFA) != 0) {
                return this.executeI64_boolean8(state_0, frameValue);
            }
            if ((state_0 & 0x1FEA) == 0 && (state_0 & 0x1FFA) != 0) {
                return this.executeI64_byte9(state_0, frameValue);
            }
            if ((state_0 & 0x1FDA) == 0 && (state_0 & 0x1FFA) != 0) {
                return this.executeI64_short10(state_0, frameValue);
            }
            if ((state_0 & 0x1FBA) == 0 && (state_0 & 0x1FFA) != 0) {
                return this.executeI64_int11(state_0, frameValue);
            }
            if ((state_0 & 0x1F7A) == 0 && (state_0 & 0x1FFA) != 0) {
                return this.executeI64_long12(state_0, frameValue);
            }
            if ((state_0 & 0x1DFA) == 0 && (state_0 & 0x1FFA) != 0) {
                return this.executeI64_float13(state_0, frameValue);
            }
            if ((state_0 & 0x1BFA) == 0 && (state_0 & 0x1FFA) != 0) {
                return this.executeI64_double14(state_0, frameValue);
            }
            return this.executeI64_generic15(state_0, frameValue);
        }

        private long executeI64_boolean8(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            boolean fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
            }
            assert ((state_0 & 8) != 0);
            return this.doI64(fromNodeValue_);
        }

        private long executeI64_byte9(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            byte fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
            }
            assert ((state_0 & 0x10) != 0);
            return this.doI64(fromNodeValue_);
        }

        private long executeI64_short10(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            short fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
            }
            assert ((state_0 & 0x20) != 0);
            return this.doI64(fromNodeValue_);
        }

        private long executeI64_int11(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
            }
            assert ((state_0 & 0x40) != 0);
            return this.doI64(fromNodeValue_);
        }

        private long executeI64_long12(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            long fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
            }
            assert ((state_0 & 0x80) != 0);
            return this.doI64(fromNodeValue_);
        }

        private long executeI64_float13(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            float fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(Float.valueOf(fromNodeValue_)));
            }
            assert ((state_0 & 0x200) != 0);
            return this.doI64(fromNodeValue_);
        }

        private long executeI64_double14(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            double fromNodeValue_;
            int state_0 = state_0__;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
            }
            assert ((state_0 & 0x400) != 0);
            return this.doI64(fromNodeValue_);
        }

        private long executeI64_generic15(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
            }
            if ((state_0 & 0x1FFA) != 0) {
                if ((state_0 & 2) != 0 && LLVMTypes.isNativePointer(fromNodeValue_)) {
                    LLVMNativePointer fromNodeValue__ = LLVMTypes.asNativePointer(fromNodeValue_);
                    return this.doNative(fromNodeValue__);
                }
                if ((state_0 & 8) != 0 && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (Boolean)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x10) != 0 && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (Byte)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x20) != 0 && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (Short)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x40) != 0 && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (Integer)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x80) != 0 && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (Long)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x100) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0xE000) >>> 13, fromNodeValue_)) {
                    LLVMIVarBit fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0xE000) >>> 13, fromNodeValue_);
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x200) != 0 && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = ((Float)fromNodeValue_).floatValue();
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x400) != 0 && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (Double)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x800) != 0 && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
                if ((state_0 & 0x1000) != 0 && fromNodeValue_ instanceof LLVM128BitFloat) {
                    LLVM128BitFloat fromNodeValue__ = (LLVM128BitFloat)fromNodeValue_;
                    return this.doI64(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(this.executeAndSpecialize(fromNodeValue_));
        }

        private Object executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(fromNodeValue)) {
                LLVMNativePointer fromNodeValue_ = LLVMTypes.asNativePointer(fromNodeValue);
                this.state_0_ = state_0 |= 2;
                return this.doNative(fromNodeValue_);
            }
            if (LLVMTypes.isManagedPointer(fromNodeValue)) {
                LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                this.state_0_ = state_0 |= 4;
                return this.doManaged(fromNodeValue_);
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (Boolean)fromNodeValue;
                this.state_0_ = state_0 |= 8;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (Byte)fromNodeValue;
                this.state_0_ = state_0 |= 0x10;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (Short)fromNodeValue;
                this.state_0_ = state_0 |= 0x20;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (Integer)fromNodeValue;
                this.state_0_ = state_0 |= 0x40;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (Long)fromNodeValue;
                this.state_0_ = state_0 |= 0x80;
                return this.doI64(fromNodeValue_);
            }
            int lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(fromNodeValue);
            if (lLVMIVarBitCast0 != 0) {
                LLVMIVarBit fromNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, fromNodeValue);
                state_0 |= lLVMIVarBitCast0 << 13;
                this.state_0_ = state_0 |= 0x100;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = ((Float)fromNodeValue).floatValue();
                this.state_0_ = state_0 |= 0x200;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (Double)fromNodeValue;
                this.state_0_ = state_0 |= 0x400;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat)fromNodeValue;
                this.state_0_ = state_0 |= 0x800;
                return this.doI64(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM128BitFloat) {
                LLVM128BitFloat fromNodeValue_ = (LLVM128BitFloat)fromNodeValue;
                this.state_0_ = state_0 |= 0x1000;
                return this.doI64(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.fromNode_}, new Object[]{fromNodeValue});
        }

        public NodeCost getCost() {
            int state_0 = this.state_0_;
            if ((state_0 & 0x1FFE) == 0) {
                return NodeCost.UNINITIALIZED;
            }
            if ((state_0 & 0x1FFE & (state_0 & 0x1FFE) - 1) == 0) {
                return NodeCost.MONOMORPHIC;
            }
            return NodeCost.POLYMORPHIC;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            this.state_0_ |= 4;
            this.state_0_ |= 8;
            this.state_0_ |= 0x10;
            this.state_0_ |= 0x20;
            this.state_0_ |= 0x40;
            this.state_0_ |= 0x80;
            this.state_0_ |= 0x100;
            this.state_0_ |= 0x200;
            this.state_0_ |= 0x400;
            this.state_0_ |= 0x800;
            this.state_0_ |= 0x1000;
            int state_0 = this.state_0_;
            state_0 |= 1;
            this.state_0_ = state_0 |= 0xE000;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMToI64Node.LLVMSignedCastToI64Node create(LLVMExpressionNode fromNode) {
            return new LLVMSignedCastToI64NodeGen(fromNode);
        }
    }
}

