/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm.syscall;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.CountingConditionProfile;
import com.oracle.truffle.llvm.runtime.memory.LLVMSyscallOperationNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

public abstract class LLVMAMD64SyscallMmapNode
extends LLVMSyscallOperationNode {
    private final CountingConditionProfile mapAnonymousProfile = CountingConditionProfile.create();

    @Override
    public final String getName() {
        return "mmap";
    }

    @Specialization
    protected long doOp(LLVMNativePointer addr, long len, long prot, long flags, long fildes, long off) {
        if (this.mapAnonymousProfile.profile((flags & 0x20L) != 0L)) {
            LLVMNativePointer ptr = this.getLanguage().getLLVMMemory().allocateMemory(this, len);
            return ptr.asNative();
        }
        return -12L;
    }

    @Specialization
    protected long doOp(long addr, long len, long prot, long flags, long fildes, long off) {
        return this.doOp(LLVMNativePointer.create(addr), len, prot, flags, fildes, off);
    }
}

