/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteBooleanNode;
import java.security.SecureRandom;

public abstract class LLVMAMD64RdRandNode
extends LLVMExpressionNode {
    private final SecureRandom random = new SecureRandom();
    @Node.Child
    protected LLVMAMD64WriteBooleanNode writeCFNode;

    @CompilerDirectives.TruffleBoundary
    protected int nextInt() {
        return this.random.nextInt();
    }

    @CompilerDirectives.TruffleBoundary
    protected long nextLong() {
        return this.random.nextLong();
    }

    public LLVMAMD64RdRandNode(LLVMAMD64WriteBooleanNode writeCFNode) {
        this.writeCFNode = writeCFNode;
    }

    public static abstract class LLVMAMD64RdRandqNode
    extends LLVMAMD64RdRandNode {
        public LLVMAMD64RdRandqNode(LLVMAMD64WriteBooleanNode cf) {
            super(cf);
        }

        @Specialization
        protected long doI64(VirtualFrame frame) {
            this.writeCFNode.execute(frame, true);
            return this.nextLong();
        }
    }

    public static abstract class LLVMAMD64RdRandlNode
    extends LLVMAMD64RdRandNode {
        public LLVMAMD64RdRandlNode(LLVMAMD64WriteBooleanNode cf) {
            super(cf);
        }

        @Specialization
        protected int doI32(VirtualFrame frame) {
            this.writeCFNode.execute(frame, true);
            return this.nextInt();
        }
    }

    public static abstract class LLVMAMD64RdRandwNode
    extends LLVMAMD64RdRandNode {
        public LLVMAMD64RdRandwNode(LLVMAMD64WriteBooleanNode writeCFNode) {
            super(writeCFNode);
        }

        @Specialization
        protected short doI16(VirtualFrame frame) {
            this.writeCFNode.execute(frame, true);
            return (short)this.nextInt();
        }
    }
}

