/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64UpdateFlagsNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteBooleanNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteTupelNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64WriteValueNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LongMultiplication;

public abstract class LLVMAMD64ImulNode
extends LLVMStatementNode {
    @Node.Child
    protected LLVMAMD64WriteBooleanNode writeCFNode;
    @Node.Child
    protected LLVMAMD64WriteBooleanNode writePFNode;
    @Node.Child
    protected LLVMAMD64WriteBooleanNode writeAFNode;
    @Node.Child
    protected LLVMAMD64WriteBooleanNode writeZFNode;
    @Node.Child
    protected LLVMAMD64WriteBooleanNode writeSFNode;
    @Node.Child
    protected LLVMAMD64WriteBooleanNode writeOFNode;

    protected void setFlags(VirtualFrame frame, byte value, boolean overflow, boolean sign) {
        this.writeCFNode.execute(frame, overflow);
        this.writePFNode.execute(frame, LLVMAMD64UpdateFlagsNode.getParity(value));
        this.writeAFNode.execute(frame, false);
        this.writeZFNode.execute(frame, false);
        this.writeSFNode.execute(frame, sign);
        this.writeOFNode.execute(frame, overflow);
    }

    public LLVMAMD64ImulNode(LLVMAMD64WriteBooleanNode writeCFNode, LLVMAMD64WriteBooleanNode writePFNode, LLVMAMD64WriteBooleanNode writeAFNode, LLVMAMD64WriteBooleanNode writeZFNode, LLVMAMD64WriteBooleanNode writeSFNode, LLVMAMD64WriteBooleanNode writeOFNode) {
        this.writeCFNode = writeCFNode;
        this.writePFNode = writePFNode;
        this.writeAFNode = writeAFNode;
        this.writeZFNode = writeZFNode;
        this.writeSFNode = writeSFNode;
        this.writeOFNode = writeOFNode;
    }

    @NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64Imulq3Node
    extends LLVMAMD64ImulNode {
        @Node.Child
        private LLVMAMD64WriteValueNode out;

        public LLVMAMD64Imulq3Node(LLVMAMD64WriteBooleanNode writeCFNode, LLVMAMD64WriteBooleanNode writePFNode, LLVMAMD64WriteBooleanNode writeAFNode, LLVMAMD64WriteBooleanNode writeZFNode, LLVMAMD64WriteBooleanNode writeSFNode, LLVMAMD64WriteBooleanNode writeOFNode, LLVMAMD64WriteValueNode out) {
            super(writeCFNode, writePFNode, writeAFNode, writeZFNode, writeSFNode, writeOFNode);
            this.out = out;
        }

        @Specialization
        protected void doI64(VirtualFrame frame, long left, long right) {
            long value = left * right;
            long hi = LongMultiplication.multiplyHigh(left, right);
            boolean overflow = !(value < 0L && hi == -1L || value > 0L && hi == 0L);
            boolean sign = value < 0L;
            this.setFlags(frame, (byte)value, overflow, sign);
            this.out.execute(frame, value);
        }
    }

    @NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64ImulqNode
    extends LLVMAMD64ImulNode {
        @Node.Child
        private LLVMAMD64WriteTupelNode out;

        public LLVMAMD64ImulqNode(LLVMAMD64WriteBooleanNode writeCFNode, LLVMAMD64WriteBooleanNode writePFNode, LLVMAMD64WriteBooleanNode writeAFNode, LLVMAMD64WriteBooleanNode writeZFNode, LLVMAMD64WriteBooleanNode writeSFNode, LLVMAMD64WriteBooleanNode writeOFNode, LLVMAMD64WriteTupelNode out) {
            super(writeCFNode, writePFNode, writeAFNode, writeZFNode, writeSFNode, writeOFNode);
            this.out = out;
        }

        @Specialization
        protected void doOp(VirtualFrame frame, long left, long right) {
            long value = left * right;
            long hi = LongMultiplication.multiplyHigh(left, right);
            boolean overflow = !(value < 0L && hi == -1L || value > 0L && hi == 0L);
            boolean sign = value < 0L;
            this.setFlags(frame, (byte)value, overflow, sign);
            this.out.execute(frame, value, hi);
        }
    }

    @NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64Imull3Node
    extends LLVMAMD64ImulNode {
        @Node.Child
        private LLVMAMD64WriteValueNode out;

        public LLVMAMD64Imull3Node(LLVMAMD64WriteBooleanNode writeCFNode, LLVMAMD64WriteBooleanNode writePFNode, LLVMAMD64WriteBooleanNode writeAFNode, LLVMAMD64WriteBooleanNode writeZFNode, LLVMAMD64WriteBooleanNode writeSFNode, LLVMAMD64WriteBooleanNode writeOFNode, LLVMAMD64WriteValueNode out) {
            super(writeCFNode, writePFNode, writeAFNode, writeZFNode, writeSFNode, writeOFNode);
            this.out = out;
        }

        @Specialization
        protected void doI32(VirtualFrame frame, int left, int right) {
            long value = (long)left * (long)right;
            int valuel = (int)value;
            boolean overflow = (long)valuel != value;
            boolean sign = valuel < 0;
            this.setFlags(frame, (byte)value, overflow, sign);
            this.out.execute(frame, valuel);
        }
    }

    @NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64ImullNode
    extends LLVMAMD64ImulNode {
        @Node.Child
        private LLVMAMD64WriteTupelNode out;

        public LLVMAMD64ImullNode(LLVMAMD64WriteBooleanNode writeCFNode, LLVMAMD64WriteBooleanNode writePFNode, LLVMAMD64WriteBooleanNode writeAFNode, LLVMAMD64WriteBooleanNode writeZFNode, LLVMAMD64WriteBooleanNode writeSFNode, LLVMAMD64WriteBooleanNode writeOFNode, LLVMAMD64WriteTupelNode out) {
            super(writeCFNode, writePFNode, writeAFNode, writeZFNode, writeSFNode, writeOFNode);
            this.out = out;
        }

        @Specialization
        protected void doOp(VirtualFrame frame, int left, int right) {
            long value = (long)left * (long)right;
            int hi = (int)(value >> 32);
            int valuel = (int)value;
            boolean overflow = (long)valuel != value;
            boolean sign = valuel < 0;
            this.setFlags(frame, (byte)value, overflow, sign);
            this.out.execute(frame, valuel, hi);
        }
    }

    @NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64Imulw3Node
    extends LLVMAMD64ImulNode {
        @Node.Child
        private LLVMAMD64WriteValueNode out;

        public LLVMAMD64Imulw3Node(LLVMAMD64WriteBooleanNode writeCFNode, LLVMAMD64WriteBooleanNode writePFNode, LLVMAMD64WriteBooleanNode writeAFNode, LLVMAMD64WriteBooleanNode writeZFNode, LLVMAMD64WriteBooleanNode writeSFNode, LLVMAMD64WriteBooleanNode writeOFNode, LLVMAMD64WriteValueNode out) {
            super(writeCFNode, writePFNode, writeAFNode, writeZFNode, writeSFNode, writeOFNode);
            this.out = out;
        }

        @Specialization
        protected void doI16(VirtualFrame frame, short left, short right) {
            int value = left * right;
            short valuew = (short)value;
            boolean overflow = valuew != value;
            boolean sign = valuew < 0;
            this.setFlags(frame, (byte)value, overflow, sign);
            this.out.execute(frame, value);
        }
    }

    @NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64ImulwNode
    extends LLVMAMD64ImulNode {
        @Node.Child
        private LLVMAMD64WriteTupelNode out;

        public LLVMAMD64ImulwNode(LLVMAMD64WriteBooleanNode writeCFNode, LLVMAMD64WriteBooleanNode writePFNode, LLVMAMD64WriteBooleanNode writeAFNode, LLVMAMD64WriteBooleanNode writeZFNode, LLVMAMD64WriteBooleanNode writeSFNode, LLVMAMD64WriteBooleanNode writeOFNode, LLVMAMD64WriteTupelNode out) {
            super(writeCFNode, writePFNode, writeAFNode, writeZFNode, writeSFNode, writeOFNode);
            this.out = out;
        }

        @Specialization
        protected void doOp(VirtualFrame frame, short left, short right) {
            int value = left * right;
            short hi = (short)(value >> 16);
            short valuew = (short)value;
            boolean overflow = valuew != value;
            boolean sign = valuew < 0;
            this.setFlags(frame, (byte)value, overflow, sign);
            this.out.execute(frame, valuew, hi);
        }
    }

    @NodeChildren(value={@NodeChild(value="left", type=LLVMExpressionNode.class), @NodeChild(value="right", type=LLVMExpressionNode.class)})
    public static abstract class LLVMAMD64ImulbNode
    extends LLVMAMD64ImulNode {
        @Node.Child
        private LLVMAMD64WriteValueNode out;

        public LLVMAMD64ImulbNode(LLVMAMD64WriteBooleanNode writeCFNode, LLVMAMD64WriteBooleanNode writePFNode, LLVMAMD64WriteBooleanNode writeAFNode, LLVMAMD64WriteBooleanNode writeZFNode, LLVMAMD64WriteBooleanNode writeSFNode, LLVMAMD64WriteBooleanNode writeOFNode, LLVMAMD64WriteValueNode out) {
            super(writeCFNode, writePFNode, writeAFNode, writeZFNode, writeSFNode, writeOFNode);
            this.out = out;
        }

        @Specialization
        protected void doOp(VirtualFrame frame, byte left, byte right) {
            short value = (short)(left * right);
            byte valueb = (byte)value;
            boolean overflow = valueb != value;
            boolean sign = valueb < 0;
            this.setFlags(frame, valueb, overflow, sign);
            this.out.execute(frame, value);
        }
    }
}

