/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.support.LLVMAMD64UpdateFlagsNode;

@NodeChildren(value={@NodeChild(value="left"), @NodeChild(value="right")})
public abstract class LLVMAMD64AddNode
extends LLVMExpressionNode {
    @Node.Child
    protected LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags;

    private LLVMAMD64AddNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags) {
        this.flags = flags;
    }

    public static abstract class LLVMAMD64AddqNode
    extends LLVMAMD64AddNode {
        public LLVMAMD64AddqNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected long doI64(VirtualFrame frame, long left, long right) {
            long result = left + right;
            boolean overflow = result < 0L && left > 0L && right > 0L || result >= 0L && left < 0L && right < 0L;
            boolean carry = (left < 0L || right < 0L) && result >= 0L || left < 0L && right < 0L;
            this.flags.execute(frame, overflow, carry, result);
            return result;
        }
    }

    public static abstract class LLVMAMD64AddlNode
    extends LLVMAMD64AddNode {
        public LLVMAMD64AddlNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected int doI32(VirtualFrame frame, int left, int right) {
            int result = left + right;
            boolean overflow = result < 0 && left > 0 && right > 0 || result >= 0 && left < 0 && right < 0;
            boolean carry = (left < 0 || right < 0) && result >= 0 || left < 0 && right < 0;
            this.flags.execute(frame, overflow, carry, result);
            return result;
        }
    }

    public static abstract class LLVMAMD64AddwNode
    extends LLVMAMD64AddNode {
        public LLVMAMD64AddwNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected short doI16(VirtualFrame frame, short left, short right) {
            short result = (short)(left + right);
            boolean overflow = result < 0 && left > 0 && right > 0 || result >= 0 && left < 0 && right < 0;
            boolean carry = (left < 0 || right < 0) && result >= 0 || left < 0 && right < 0;
            this.flags.execute(frame, overflow, carry, result);
            return result;
        }
    }

    public static abstract class LLVMAMD64AddbNode
    extends LLVMAMD64AddNode {
        public LLVMAMD64AddbNode(LLVMAMD64UpdateFlagsNode.LLVMAMD64UpdateCPZSOFlagsNode flags) {
            super(flags);
        }

        @Specialization
        protected byte doI8(VirtualFrame frame, byte left, byte right) {
            byte result = (byte)(left + right);
            boolean overflow = result < 0 && left > 0 && right > 0 || result >= 0 && left < 0 && right < 0;
            boolean carry = (left < 0 || right < 0) && result >= 0 || left < 0 && right < 0;
            this.flags.execute(frame, overflow, carry, result);
            return result;
        }
    }
}

