/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.convert;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;

@GenerateUncached
public abstract class ToI32
extends ForeignToLLVM {
    @Specialization
    protected int fromInt(int value) {
        return value;
    }

    @Specialization
    protected int fromChar(char value) {
        return value;
    }

    @Specialization
    protected int fromShort(short value) {
        return value;
    }

    @Specialization
    protected int fromLong(long value) {
        return (int)value;
    }

    @Specialization
    protected int fromByte(byte value) {
        return value;
    }

    @Specialization
    protected int fromFloat(float value) {
        return (int)value;
    }

    @Specialization
    protected int fromDouble(double value) {
        return (int)value;
    }

    @Specialization
    protected int fromBoolean(boolean value) {
        return value ? 1 : 0;
    }

    @Specialization
    protected int fromString(String value, @Cached BranchProfile exception) {
        return this.getSingleStringCharacter(value, exception);
    }

    @Specialization(limit="5", guards={"foreigns.isForeign(obj)", "interop.isNumber(foreigns.asForeign(obj))"})
    @GenerateAOT.Exclude
    protected int fromForeign(Object obj, @CachedLibrary(value="obj") LLVMAsForeignLibrary foreigns, @CachedLibrary(limit="3") InteropLibrary interop, @Cached BranchProfile exception) {
        try {
            return interop.asInt(foreigns.asForeign(obj));
        }
        catch (UnsupportedMessageException ex) {
            exception.enter();
            throw new LLVMPolyglotException((Node)this, "Polyglot number %s cannot be converted to i32", foreigns.asForeign(obj));
        }
    }

    @Fallback
    protected int fromForeignObject(Object obj) {
        throw new LLVMPolyglotException((Node)this, "Polyglot object %s cannot be converted to i32", obj);
    }

    @CompilerDirectives.TruffleBoundary
    static int slowPathPrimitiveConvert(ForeignToLLVM thiz, Object value) throws UnsupportedTypeException {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value instanceof Character) {
            return ((Character)value).charValue();
        }
        if (value instanceof String) {
            return thiz.getSingleStringCharacter((String)value, BranchProfile.getUncached());
        }
        try {
            return ((InteropLibrary)InteropLibrary.getFactory().getUncached()).asInt(value);
        }
        catch (UnsupportedMessageException ex) {
            throw UnsupportedTypeException.create((Object[])new Object[]{value});
        }
    }
}

