/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.floating;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.llvm.runtime.floating.DoubleHelper;
import com.oracle.truffle.llvm.runtime.floating.LLVMLongDoubleFloatingPoint;
import com.oracle.truffle.nfi.api.SerializableLibrary;
import java.nio.ByteOrder;
import java.util.Arrays;

@CompilerDirectives.ValueType
@ExportLibrary(value=SerializableLibrary.class, useForAOT=false)
public final class LLVM128BitFloat
extends LLVMLongDoubleFloatingPoint {
    public static final long SIGN_BIT = Long.MIN_VALUE;
    private static final int FRACTION_BIT_WIDTH = 112;
    public static final int BIT_WIDTH = 128;
    public static final int EXPONENT_POSITION = 48;
    public static final int BYTE_WIDTH = 16;
    public static final long EXPONENT_MASK = 0x7FFF000000000000L;
    public static final long FRACTION_MASK = 0xFFFFFFFFFFFFL;
    private static final LLVM128BitFloat POSITIVE_INFINITY = LLVM128BitFloat.fromRawValues(false, 0x7FFF000000000000L, 0L);
    private static final LLVM128BitFloat NEGATIVE_INFINITY = LLVM128BitFloat.fromRawValues(true, 0x7FFF000000000000L, 0L);
    private static final LLVM128BitFloat POSITIVE_ZERO = LLVM128BitFloat.fromRawValues(false, 0L, 0L);
    private static final LLVM128BitFloat NEGATIVE_ZERO = LLVM128BitFloat.fromRawValues(true, 0L, 0L);
    private static final int EXPONENT_BIAS = 16383;
    private static final int FLOAT_EXPONENT_BIAS = 127;
    private final long expSignFraction;
    private final long fraction;

    public String toString() {
        return LLVM128BitFloat.toLLVMString(this);
    }

    @CompilerDirectives.TruffleBoundary
    public static String toLLVMString(LLVM128BitFloat value) {
        if (value.isInfinity()) {
            return "INF";
        }
        return String.format("0xK%016x%016x", value.expSignFraction, value.fraction);
    }

    public LLVM128BitFloat(long expSignFraction, long fraction) {
        this.expSignFraction = expSignFraction;
        this.fraction = fraction;
    }

    private LLVM128BitFloat(LLVM128BitFloat value) {
        this.expSignFraction = value.expSignFraction;
        this.fraction = value.fraction;
    }

    public static LLVM128BitFloat fromRawValues(boolean sign, long exponentFraction, long fraction) {
        assert ((exponentFraction & Long.MIN_VALUE) == 0L);
        long expSignFraction = exponentFraction;
        if (sign) {
            expSignFraction |= Long.MIN_VALUE;
        }
        return new LLVM128BitFloat(expSignFraction, fraction);
    }

    public long getExponent() {
        return (this.expSignFraction & 0x7FFF000000000000L) >> 48;
    }

    public long getExpSignFractionPart() {
        return this.expSignFraction;
    }

    public boolean getSign() {
        return (this.expSignFraction & Long.MIN_VALUE) != 0L;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LLVM128BitFloat)) {
            return false;
        }
        LLVM128BitFloat other = (LLVM128BitFloat)obj;
        return this.expSignFraction == other.expSignFraction && this.fraction == other.fraction;
    }

    public boolean isPositiveInfinity() {
        return POSITIVE_INFINITY.equals(this);
    }

    public boolean isNegativeInfinity() {
        return NEGATIVE_INFINITY.equals(this);
    }

    public boolean isInfinity() {
        return this.isPositiveInfinity() || this.isNegativeInfinity();
    }

    public byte[] getBytesBigEndian() {
        byte[] array = new byte[16];
        ByteArraySupport.bigEndian().putLong(array, 0, this.expSignFraction);
        ByteArraySupport.bigEndian().putLong(array, 8, this.fraction);
        return array;
    }

    public static LLVM128BitFloat createPositiveZero() {
        if (CompilerDirectives.inCompiledCode()) {
            return LLVM128BitFloat.fromRawValues(false, 0L, 0L);
        }
        return POSITIVE_ZERO;
    }

    public static long bit(long i) {
        return 1L << (int)i;
    }

    public static LLVM128BitFloat fromLong(long val) {
        if (val == 0L) {
            return LLVM128BitFloat.createPositiveZero();
        }
        boolean sign = val < 0L;
        return LLVM128BitFloat.fromLong(Math.abs(val), sign);
    }

    public long getSecondFractionPart() {
        return this.fraction;
    }

    public long getFirstFractionPart() {
        return this.expSignFraction & 0xFFFFFFFFFFFFL;
    }

    public LLVM128BitFloat negate() {
        return new LLVM128BitFloat(this.expSignFraction ^ Long.MIN_VALUE, this.fraction);
    }

    private long getUnbiasedExponent() {
        return ((this.expSignFraction & 0x7FFF000000000000L) >>> 48) - 16383L;
    }

    private long getFractionAsLong() {
        long unbiasedExponent = this.getUnbiasedExponent();
        long returnFraction = 1L << (int)unbiasedExponent;
        if (unbiasedExponent < 0L) {
            return 0L;
        }
        if (unbiasedExponent <= 48L) {
            returnFraction |= (this.expSignFraction & 0xFFFFFFFFFFFFL) >>> (int)(48L - unbiasedExponent);
        } else if (unbiasedExponent < 64L) {
            returnFraction |= (this.expSignFraction & 0xFFFFFFFFFFFFL) << (int)(unbiasedExponent - 48L);
            returnFraction |= this.fraction >>> (int)(64L - (unbiasedExponent - 48L));
        } else {
            returnFraction = 0L;
        }
        return returnFraction;
    }

    public int toIntValue() {
        int value = (int)this.getFractionAsLong();
        return this.getSign() ? -value : value;
    }

    public long toLongValue() {
        long value = this.getFractionAsLong();
        return this.getSign() ? -value : value;
    }

    @Override
    public double toDoubleValue() {
        if (this.isPositiveInfinity()) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.isNegativeInfinity()) {
            return Double.NEGATIVE_INFINITY;
        }
        long doubleExponent = this.getUnbiasedExponent() + 1023L;
        long doubleFraction = (this.expSignFraction & 0xFFFFFFFFFFFFL) << 4;
        long shiftedSignBit = (this.getSign() ? 1L : 0L) << 63;
        long shiftedExponent = doubleExponent << 52;
        long rawVal = (doubleFraction |= this.fraction >>> 60) | shiftedExponent | shiftedSignBit;
        return Double.longBitsToDouble(rawVal);
    }

    public float toFloatValue() {
        if (this.isPositiveInfinity()) {
            return Float.POSITIVE_INFINITY;
        }
        if (this.isNegativeInfinity()) {
            return Float.NEGATIVE_INFINITY;
        }
        long floatExponent = this.getUnbiasedExponent() + 127L;
        long floatFraction = (this.expSignFraction & 0xFFFFFFFFFFFFL) >>> 25;
        long shiftedSignBit = (this.getSign() ? 1 : 0) << 31;
        long shiftedExponent = floatExponent << 23;
        long rawVal = floatFraction | shiftedExponent | shiftedSignBit;
        return Float.intBitsToFloat((int)rawVal);
    }

    public byte[] getBytes() {
        byte[] array = new byte[16];
        ByteArraySupport.littleEndian().putLong(array, 0, this.fraction);
        ByteArraySupport.littleEndian().putLong(array, 8, this.expSignFraction);
        return array;
    }

    public static LLVM128BitFloat fromBytesBigEndian(byte[] bytes) {
        assert (bytes.length == 16);
        long fraction = ByteArraySupport.bigEndian().getLong(bytes, 0);
        long expSignFraction = ByteArraySupport.bigEndian().getLong(bytes, 8);
        return new LLVM128BitFloat(expSignFraction, fraction);
    }

    public static LLVM128BitFloat fromBytes(byte[] bytes) {
        assert (bytes.length == 16);
        long fraction = ByteArraySupport.littleEndian().getLong(bytes, 0);
        long expSignFraction = ByteArraySupport.littleEndian().getLong(bytes, 8);
        return new LLVM128BitFloat(expSignFraction, fraction);
    }

    public static LLVM128BitFloat fromInt(int val) {
        boolean sign = val < 0;
        return LLVM128BitFloat.fromInt(val, sign);
    }

    private static LLVM128BitFloat fromInt(int val, boolean sign) {
        return LLVM128BitFloat.fromLong(Math.abs(val), sign);
    }

    private static LLVM128BitFloat fromLong(long val, boolean sign) {
        long fraction;
        long exponentFraction;
        int leadingOnePosition = 64 - Long.numberOfLeadingZeros(val);
        long exponent = 16383 + (leadingOnePosition - 1);
        long shiftAmount = 112 - leadingOnePosition + 1;
        if (shiftAmount >= 64L) {
            exponentFraction = exponent << 48 | val << (int)(shiftAmount - 64L);
            fraction = 0L;
        } else {
            exponentFraction = exponent << 48 | val >> (int)(64L - shiftAmount);
            fraction = val << (int)shiftAmount;
        }
        return LLVM128BitFloat.fromRawValues(sign, exponentFraction, fraction);
    }

    public static LLVM128BitFloat fromFloat(float val) {
        return LLVM128BitFloat.fromDouble(val);
    }

    public static LLVM128BitFloat fromDouble(double val) {
        boolean sign;
        boolean bl = sign = val < 0.0;
        if (DoubleHelper.isPositiveZero(val)) {
            return new LLVM128BitFloat(POSITIVE_ZERO);
        }
        if (DoubleHelper.isNegativeZero(val)) {
            return new LLVM128BitFloat(NEGATIVE_ZERO);
        }
        long rawValue = Double.doubleToRawLongBits(val);
        int doubleExponent = DoubleHelper.getUnbiasedExponent(val);
        int biasedExponent = doubleExponent + 16383;
        long doubleFraction = rawValue & DoubleHelper.FRACTION_MASK;
        long shiftAmount = 60L;
        long fraction = doubleFraction << (int)shiftAmount;
        long biasedExponentFraction = (long)biasedExponent << 48 | doubleFraction >> (int)(64L - shiftAmount);
        return LLVM128BitFloat.fromRawValues(sign, biasedExponentFraction, fraction);
    }

    public int hashCode() {
        return Arrays.hashCode(this.getBytes());
    }

    public static int compare(LLVM128BitFloat val1, LLVM128BitFloat val2) {
        return val1.compareOrdered(val2);
    }

    int compareOrdered(LLVM128BitFloat val) {
        if (this.isNegativeInfinity()) {
            if (val.isNegativeInfinity()) {
                return 0;
            }
            return -1;
        }
        if (val.isNegativeInfinity()) {
            return 1;
        }
        if (this.getSign() == val.getSign()) {
            long expDifference = this.getExponent() - val.getExponent();
            if (expDifference == 0L) {
                long fractionFirstPartDifference = this.getFirstFractionPart() - val.getFirstFractionPart();
                if (fractionFirstPartDifference == 0L) {
                    long fractionSecondPartDifference = this.getSecondFractionPart() - val.getSecondFractionPart();
                    if (fractionSecondPartDifference == 0L) {
                        return 0;
                    }
                    if (fractionSecondPartDifference < 0L) {
                        return -1;
                    }
                    return 1;
                }
                return (int)fractionFirstPartDifference;
            }
            return (int)expDifference;
        }
        if (this.isZero() && val.isZero()) {
            return 0;
        }
        if (this.getSign()) {
            return -1;
        }
        return 1;
    }

    public boolean isZero() {
        return this.isPositiveZero() || this.isNegativeZero();
    }

    private boolean isPositiveZero() {
        return this.equals(POSITIVE_ZERO);
    }

    private boolean isNegativeZero() {
        return this.equals(NEGATIVE_ZERO);
    }

    @ExplodeLoop
    public static boolean areOrdered(LLVM128BitFloat ... vals) {
        CompilerAsserts.compilationConstant((Object)vals.length);
        for (LLVM128BitFloat val : vals) {
            if (val.isOrdered()) continue;
            return false;
        }
        return true;
    }

    public boolean isNaN() {
        if (this.getExponent() == 32767L) {
            return !this.isInfinity() && (this.getSecondFractionPart() != 0L || this.getFirstFractionPart() != 0L);
        }
        return false;
    }

    public boolean isOrdered() {
        return !this.isNaN();
    }

    @ExportMessage
    boolean isSerializable() {
        return true;
    }

    @ExportMessage(limit="1")
    void serialize(Object buffer, @CachedLibrary(value="buffer") InteropLibrary interop) {
        try {
            interop.writeBufferLong(buffer, ByteOrder.LITTLE_ENDIAN, 0L, this.fraction);
            interop.writeBufferLong(buffer, ByteOrder.LITTLE_ENDIAN, 8L, this.expSignFraction);
        }
        catch (InvalidBufferOffsetException | UnsupportedMessageException ex) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)ex);
        }
    }
}

