/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.except;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.except.LLVMException;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@ExportLibrary(value=InteropLibrary.class, delegateTo="unwindHeader")
public class LLVMUserException
extends LLVMException {
    private static final long serialVersionUID = 1L;
    final transient LLVMPointer unwindHeader;

    public LLVMUserException(Node location, LLVMPointer unwindHeader) {
        super(location);
        this.unwindHeader = unwindHeader;
    }

    public LLVMPointer getUnwindHeader() {
        return this.unwindHeader;
    }

    public String getMessage() {
        return "LLVMException:" + this.unwindHeader.toString();
    }

    @ExportMessage
    boolean isException() {
        return true;
    }

    @ExportMessage
    RuntimeException throwException() {
        throw this;
    }

    @ExportMessage
    ExceptionType getExceptionType() {
        return ExceptionType.RUNTIME_ERROR;
    }

    @ExportMessage
    boolean hasExceptionMessage() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    String getExceptionMessage() {
        return this.getMessage();
    }

    public static final class LLVMUserExceptionWindows
    extends LLVMUserException {
        private static final long serialVersionUID = 1L;
        final transient LLVMPointer imageBase;
        final transient LLVMPointer exceptionObject;
        final transient long stackOffset;

        public LLVMUserExceptionWindows(Node location, LLVMPointer imageBase, LLVMPointer exceptionObject, LLVMPointer throwInfo, long stackOffset) {
            super(location, throwInfo);
            this.exceptionObject = exceptionObject;
            this.imageBase = imageBase;
            this.stackOffset = stackOffset;
        }

        public LLVMPointer getThrowInfo() {
            return this.unwindHeader;
        }

        public LLVMPointer getImageBase() {
            return this.imageBase;
        }

        public LLVMPointer getExceptionObject() {
            return this.exceptionObject;
        }

        public long getStackPointer() {
            return this.stackOffset;
        }
    }
}

