/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.debug.LLVMDebuggerValue;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprFunctionCallNode;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprFunctionCallNodeGen;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExpressionPair;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.MemberAccessible;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import java.util.List;
import org.graalvm.collections.Pair;

public abstract class DebugExprVarNode
extends LLVMExpressionNode
implements MemberAccessible {
    private final String name;
    private final Node location;

    DebugExprVarNode(String name, Node location) {
        this.name = name;
        this.location = location;
    }

    private Pair<Object, DebugExprType> findMemberAndType(VirtualFrame frameValue) {
        NodeLibrary nodeLibrary = NodeLibrary.getUncached();
        InteropLibrary interopLibrary = InteropLibrary.getUncached();
        try {
            LLVMDebuggerValue entries = (LLVMDebuggerValue)nodeLibrary.getScope((Object)this.location, (Frame)frameValue, true);
            if (interopLibrary.isMemberReadable((Object)entries, this.name)) {
                Object member = interopLibrary.readMember((Object)entries, this.name);
                LLVMDebuggerValue ldv = (LLVMDebuggerValue)member;
                Object metaObj = ldv.resolveMetaObject();
                DebugExprType type = DebugExprType.getTypeFromSymbolTableMetaObject(metaObj);
                return Pair.create((Object)member, (Object)type);
            }
        }
        catch (ClassCastException e) {
            throw DebugExprException.create(this, "\"%s\" cannot be casted to a LLVMDebuggerValue", this.name);
        }
        catch (UnsupportedMessageException e) {
            throw DebugExprException.symbolNotFound(this, this.name, null);
        }
        catch (UnknownIdentifierException e) {
            throw DebugExprException.symbolNotFound(this, e.getUnknownIdentifier(), null);
        }
        return Pair.create(null, (Object)DebugExprType.getVoidType());
    }

    @Override
    public DebugExprType getType(VirtualFrame frame) {
        return (DebugExprType)this.findMemberAndType(frame).getRight();
    }

    @Override
    public Object getMember(VirtualFrame frame) {
        return this.findMemberAndType(frame).getLeft();
    }

    public String getName() {
        return this.name;
    }

    @Specialization
    public Object doVariable(VirtualFrame frame) {
        Object value;
        Pair<Object, DebugExprType> pair = this.findMemberAndType(frame);
        if (pair.getLeft() == null) {
            throw DebugExprException.symbolNotFound(this, this.name, null);
        }
        Object member = pair.getLeft();
        DebugExprType type = (DebugExprType)pair.getRight();
        if (type != null && member != null && (value = type.parse(member)) != null) {
            return value;
        }
        throw DebugExprException.symbolNotFound(this, this.name, null);
    }

    public DebugExprFunctionCallNode createFunctionCall(List<DebugExpressionPair> arguments, Object globalScope) {
        return DebugExprFunctionCallNodeGen.create(this.name, arguments, globalScope);
    }
}

