/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.model.symbols.instructions;

import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.SymbolTable;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.ValueInstruction;
import com.oracle.truffle.llvm.parser.model.visitors.SymbolVisitor;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class CatchPadInstruction
extends ValueInstruction {
    private SymbolImpl within;
    private final Type[] argTypes;
    private SymbolImpl[] argValues;

    private CatchPadInstruction(Type[] argTypes) {
        super(PrimitiveType.I64);
        this.argTypes = argTypes;
    }

    public SymbolImpl getWithinSymbol() {
        return this.within;
    }

    @Override
    public void replace(SymbolImpl oldValue, SymbolImpl newValue) {
        if (this.within == oldValue) {
            this.within = newValue;
        }
    }

    @Override
    public void accept(SymbolVisitor visitor) {
        visitor.visit(this);
    }

    public SymbolImpl[] getClauseSymbols() {
        return this.argValues;
    }

    public Type[] getArgTypes() {
        return this.argTypes;
    }

    public static CatchPadInstruction generate(SymbolTable table, int withinIndex, Type[] argTypes, int[] argValues) {
        CatchPadInstruction l = new CatchPadInstruction(argTypes);
        SymbolImpl[] values = new SymbolImpl[argValues.length];
        for (int i = 0; i < argValues.length; ++i) {
            values[i] = table.getForwardReferenced(argValues[i], l);
        }
        l.within = table.getForwardReferencedOrNull(withinIndex, l);
        l.argValues = values;
        return l;
    }
}

