/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.metadata;

import com.oracle.truffle.llvm.parser.listeners.Metadata;
import com.oracle.truffle.llvm.parser.metadata.MDBaseNode;
import com.oracle.truffle.llvm.parser.metadata.MDName;
import com.oracle.truffle.llvm.parser.metadata.MetadataValueList;
import com.oracle.truffle.llvm.parser.metadata.MetadataVisitor;
import com.oracle.truffle.llvm.parser.metadata.ParseUtil;

public final class MDEnumerator
extends MDName
implements MDBaseNode {
    private final long value;
    private static final int ARGINDEX_38_VALUE = 1;
    private static final int ARGINDEX_38_NAME = 2;
    private static final int ARGINDEX_32_NAME = 1;
    private static final int ARGINDEX_32_VALUE = 2;

    private MDEnumerator(long value) {
        this.value = value;
    }

    @Override
    public void accept(MetadataVisitor visitor) {
        visitor.visit(this);
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public void replace(MDBaseNode oldValue, MDBaseNode newValue) {
        super.replace(oldValue, newValue);
    }

    public static MDEnumerator create38(long[] args, MetadataValueList md) {
        long value = ParseUtil.unrotateSign(args[1]);
        MDEnumerator enumerator = new MDEnumerator(value);
        enumerator.setName(md.getNullable(args[2], enumerator));
        return enumerator;
    }

    public static MDEnumerator create32(long[] args, Metadata md) {
        long value = ParseUtil.asLong(args, 2, md);
        MDEnumerator enumerator = new MDEnumerator(value);
        enumerator.setName(ParseUtil.resolveReference(args, 1, enumerator, md));
        return enumerator;
    }
}

