/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.macho;

import com.oracle.truffle.llvm.parser.filereader.ObjectFileReader;
import com.oracle.truffle.llvm.parser.macho.MachOFile;
import com.oracle.truffle.llvm.parser.macho.MachOHeader;
import com.oracle.truffle.llvm.parser.macho.MachOLoadCommandTable;
import com.oracle.truffle.llvm.runtime.Magic;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import org.graalvm.polyglot.io.ByteSequence;

public final class MachOReader
extends ObjectFileReader {
    private final boolean is64Bit;

    private MachOReader(ByteSequence buffer, boolean littleEndian, boolean is64Bit) {
        super(buffer, littleEndian);
        this.is64Bit = is64Bit;
    }

    public static MachOFile create(ByteSequence buffer) {
        long magic;
        int position = 0;
        int ret = buffer.byteAt(position++) & 0xFF;
        ret = ret << 8 | buffer.byteAt(position++) & 0xFF;
        ret = ret << 8 | buffer.byteAt(position++) & 0xFF;
        if (!MachOFile.isMachOMagicNumber(magic = Integer.toUnsignedLong(ret = ret << 8 | buffer.byteAt(position++) & 0xFF))) {
            throw new LLVMParserException("Invalid Mach-O file!");
        }
        boolean is64Bit = MachOReader.isMachO64MagicNumber(magic);
        MachOReader reader = new MachOReader(buffer, MachOReader.isReversedByteOrder(magic), is64Bit);
        reader.setPosition(position);
        MachOHeader header = MachOHeader.create(reader);
        MachOLoadCommandTable loadCommandTable = MachOLoadCommandTable.create(header, reader);
        return new MachOFile(header, loadCommandTable, reader.byteSequence);
    }

    public boolean is64Bit() {
        return this.is64Bit;
    }

    private static boolean isMachO64MagicNumber(long magic) {
        return magic == Magic.MH_MAGIC_64.magic || magic == Magic.MH_CIGAM_64.magic;
    }

    private static boolean isReversedByteOrder(long magic) {
        return magic == Magic.MH_CIGAM.magic || magic == Magic.MH_CIGAM_64.magic;
    }
}

