/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.macho;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.parser.binary.BinaryParser;
import com.oracle.truffle.llvm.parser.macho.MachOFile;
import com.oracle.truffle.llvm.runtime.DefaultLibraryLocator;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;

public final class MachOLibraryLocator
extends LibraryLocator {
    private final List<String> rPaths;
    private static final String RPATH_PATTERN = "@rpath/";

    public MachOLibraryLocator(MachOFile machOFile, Source source) {
        if (source.isInternal()) {
            this.rPaths = Collections.emptyList();
        } else {
            String origin = BinaryParser.getOrigin(source);
            List<String> machoPaths = machOFile.getRPaths(origin);
            this.rPaths = machoPaths;
        }
    }

    @Override
    public Object locateLibrary(LLVMContext context, String lib, Object reason) {
        Path libPath = Paths.get(lib, new String[0]);
        if (libPath.isAbsolute()) {
            return DefaultLibraryLocator.locateAbsolute(context, libPath);
        }
        Object global = DefaultLibraryLocator.locateGlobal(context, lib);
        if (global != null) {
            return global;
        }
        if (lib.startsWith(RPATH_PATTERN)) {
            String subLib = lib.substring(RPATH_PATTERN.length());
            if (!this.rPaths.isEmpty()) {
                MachOLibraryLocator.traceSearchPath(context, this.rPaths, reason);
                for (String p : this.rPaths) {
                    Path absPath = Paths.get(p, subLib);
                    MachOLibraryLocator.traceTry(context, absPath);
                    try {
                        TruffleFile file = context.getEnv().getInternalTruffleFile(absPath.toUri());
                        if (!file.exists(new LinkOption[0])) continue;
                        return file;
                    }
                    catch (SecurityException securityException) {
                    }
                }
            }
            return DefaultLibraryLocator.locateGlobal(context, subLib);
        }
        return null;
    }
}

